//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "hdPrman/rileyRenderTargetPrim.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyIds.h"
#include "hdPrman/rileyTypes.h"

#include "hdPrman/rileyRenderTargetSchema.h"
#include "hdPrman/rileyRenderOutputPrim.h"
#include "hdPrman/utils.h"

#include "pxr/imaging/hd/sceneIndex.h"

PXR_NAMESPACE_OPEN_SCOPE

HdPrman_RileyRenderTargetPrim::HdPrman_RileyRenderTargetPrim(
    HdContainerDataSourceHandle const &primSource,
    const HdsiPrimManagingSceneIndexObserver * const observer,
    HdPrman_RenderParam * const renderParam)
  : HdPrman_RileyPrimBase(renderParam)
{
    HdPrmanRileyRenderTargetSchema schema =
        HdPrmanRileyRenderTargetSchema::GetFromParent(primSource);


    HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim> renderOutputs =
        HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>(
            observer,
            schema.GetRenderOutputs());

    HdPrman_RileyExtent extent =
        HdPrman_RileyExtent(
            schema.GetExtent());

    HdPrman_RileyString filterMode =
        HdPrman_RileyString(
            schema.GetFilterMode());

    HdPrman_RileyFloat pixelVariance =
        HdPrman_RileyFloat(
            schema.GetPixelVariance(),
            /* fallbackValue = */ 1.0f);

    HdPrman_RileyParamList params =
        HdPrman_RileyParamList(
            schema.GetParams());


    _rileyId = _AcquireRiley()->CreateRenderTarget(
        riley::UserId(),

        renderOutputs.rileyObject,
        extent.rileyObject,
        filterMode.rileyObject,
        pixelVariance.rileyObject,
        params.rileyObject);

    _renderOutputsPrims = std::move(renderOutputs.prims);

// --(BEGIN CUSTOM CODE: Constructor)--
// --(END CUSTOM CODE: Constructor)--
}

void
HdPrman_RileyRenderTargetPrim::_Dirty(
    const HdSceneIndexObserver::DirtiedPrimEntry &entry,
    const HdsiPrimManagingSceneIndexObserver * const observer)
{
    HdPrmanRileyRenderTargetSchema schema =
        HdPrmanRileyRenderTargetSchema::GetFromParent(
            observer->GetSceneIndex()->GetPrim(entry.primPath).dataSource);


    std::optional<HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>> renderOutputs;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderTargetSchema::GetRenderOutputsLocator())) {
        renderOutputs =
            HdPrman_RileyIdList<HdPrman_RileyRenderOutputPrim>(
                observer,
                schema.GetRenderOutputs());
    };

    std::optional<HdPrman_RileyExtent> extent;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderTargetSchema::GetExtentLocator())) {
        extent =
            HdPrman_RileyExtent(
                schema.GetExtent());
    };

    std::optional<HdPrman_RileyString> filterMode;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderTargetSchema::GetFilterModeLocator())) {
        filterMode =
            HdPrman_RileyString(
                schema.GetFilterMode());
    };

    std::optional<HdPrman_RileyFloat> pixelVariance;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderTargetSchema::GetPixelVarianceLocator())) {
        pixelVariance =
            HdPrman_RileyFloat(
                schema.GetPixelVariance(),
                1.0f);
    };

    std::optional<HdPrman_RileyParamList> params;
    if (entry.dirtyLocators.Intersects(
            HdPrmanRileyRenderTargetSchema::GetParamsLocator())) {
        params =
            HdPrman_RileyParamList(
                schema.GetParams());
    };


    _AcquireRiley()->ModifyRenderTarget(_rileyId,
        HdPrman_GetRileyObjectPtr(renderOutputs),
        HdPrman_GetRileyObjectPtr(extent),
        HdPrman_GetRileyObjectPtr(filterMode),
        HdPrman_GetRileyObjectPtr(pixelVariance),
        HdPrman_GetRileyObjectPtr(params)
// --(BEGIN CUSTOM CODE: Modify)--
// --(END CUSTOM CODE: Modify)--
        );


    // Now that the RenderTarget is using the new
    // RileyRenderOutput, we can realease the handles
    // to the old RileyRenderOutput.
    if (renderOutputs) {
        _renderOutputsPrims = std::move(renderOutputs->prims);
    }

}

HdPrman_RileyRenderTargetPrim::~HdPrman_RileyRenderTargetPrim()
{
    _AcquireRiley()->DeleteRenderTarget(_rileyId
// --(BEGIN CUSTOM CODE: Delete)--
// --(END CUSTOM CODE: Delete)--
        );


    // _renderOutputsPrims gets dropped after the RenderTarget was
    // deleted.
}

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER