//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_RENDER_TARGET_PRIM_H
#define EXT_RMANPKG_PLUGIN_RENDERMAN_PLUGIN_HD_PRMAN_RILEY_RENDER_TARGET_PRIM_H

#include "pxr/pxr.h"
#include "hdPrman/api.h"
#include "hdPrman/sceneIndexObserverApi.h"

#ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#include "hdPrman/rileyPrimBase.h"

PXR_NAMESPACE_OPEN_SCOPE

using HdPrman_RileyRenderOutputPrimHandle =
    std::shared_ptr<class HdPrman_RileyRenderOutputPrim>;

using HdPrman_RileyRenderTargetPrimHandle =
    std::shared_ptr<class HdPrman_RileyRenderTargetPrim>;

/// \class HdPrman_RileyRenderTargetPrim
///
/// Wraps a riley RenderTarget object, initializing or updating it
/// using the HdPrmanRileyRenderTargetSchema.
///
class HdPrman_RileyRenderTargetPrim : public HdPrman_RileyPrimBase
{
public:
    HdPrman_RileyRenderTargetPrim(
        HdContainerDataSourceHandle const &primSource,
        const HdsiPrimManagingSceneIndexObserver *observer,
        HdPrman_RenderParam * renderParam);

    ~HdPrman_RileyRenderTargetPrim() override;

    using RileyId = riley::RenderTargetId;

    const RileyId &GetRileyId() const { return _rileyId; }

protected:
    void _Dirty(
        const HdSceneIndexObserver::DirtiedPrimEntry &entry,
        const HdsiPrimManagingSceneIndexObserver * observer) override;

private:
    // If there is a riley render target constructed from a riley render
    // output, the render target needs to be deleted before the render
    // output is deleted.
    // To ensure this, we keep handles to the prims wrapping the render
    // outputs here.
    std::vector<HdPrman_RileyRenderOutputPrimHandle> _renderOutputsPrims;


// --(BEGIN CUSTOM CODE: Fields)--
// --(END CUSTOM CODE: Fields)--

    RileyId _rileyId;
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif // #ifdef HDPRMAN_USE_SCENE_INDEX_OBSERVER

#endif
