//===--------- ur_level_zero.hpp - Level Zero Adapter ---------------------===//
//
// Copyright (C) 2023 Intel Corporation
//
// Part of the Unified-Runtime Project, under the Apache License v2.0 with LLVM
// Exceptions. See LICENSE.TXT
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
#pragma once

#include <cassert>
#include <cinttypes>
#include <list>
#include <map>
#include <stdarg.h>
#include <string>
#include <unordered_map>
#include <vector>

#include <loader/ze_loader.h>
#include <ur/ur.hpp>
#include <ur_ddi.h>
#include <ze_api.h>
#include <zes_api.h>

#include "common.hpp"
#include "context.hpp"
#include "device.hpp"
#include "event.hpp"
#include "image.hpp"
#include "kernel.hpp"
#include "memory.hpp"
#include "physical_mem.hpp"
#include "platform.hpp"
#include "program.hpp"
#include "queue.hpp"
#include "sampler.hpp"
#include "usm.hpp"
