# Corpora for fuzz tests with fixed API calls scenarios
Corpora in 'corpus' directory contain UR API calls in a predefined order described below.
All such scenarios begin with single calls to urLoaderInit() and urAdapterGet().
Corpus files are binary files containing ASCII characters which are interpreted by the test
backwards, meaning that bytes are read from the end of the file to the beginning of the file.

More corpora can be generated by fuzzer. Just run the test with a first positional parameter
which provides the path where any new corpus will be saved. The path has to exist.
It's worth running the test with tracing enabled while picking scenarios to be added to the repository
for future short fuzz tests runs. Example of running the test with generating new corpus files:
```
UR_ADAPTERS_FORCE_LOAD=build/lib/libur_adapter_mock.so \
XPTI_TRACE_ENABLE=1 \
XPTI_FRAMEWORK_DISPATCHER=build/lib/libxptifw.so \
XPTI_SUBSCRIBERS=build/lib/libcollector.so \
UR_ENABLE_LAYERS=UR_LAYER_TRACING \
./build/bin/fuzztest-base test/fuzz/corpus -seed=1 -max_total_time=120 -verbosity=1
```

Pass path to a corpus file instead to run a single scenario:
```
UR_ADAPTERS_FORCE_LOAD=build/lib/libur_adapter_mock.so \
XPTI_TRACE_ENABLE=1 \
XPTI_FRAMEWORK_DISPATCHER=build/lib/libxptifw.so \
XPTI_SUBSCRIBERS=build/lib/libcollector.so \
UR_ENABLE_LAYERS=UR_LAYER_TRACING \
./build/bin/fuzztest-base test/fuzz/corpus/alloc -verbosity=1
```

More details on seed corpora for fuzzer can be found
[here](https://github.com/google/fuzzing/blob/master/tutorial/libFuzzerTutorial.md#seed-corpus).

## create-release
Test device/context/pool create and release

urPlatformGet()
urPlatformGet()
urDeviceGet()
urDeviceGet()
urDeviceRelease()
urDeviceGet()
urDeviceGet()
urContextCreate()
urContextRelease()
urContextCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolRelease()
urUSMPoolRelease()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolRelease()
urUSMPoolRelease()
urUSMPoolRelease()
urUSMPoolRelease()
urContextRelease()

## pool-alloc
Allocate with host and device pools

urPlatformGet()
urPlatformGet()
urDeviceGet()
urDeviceGet()
urContextCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMPoolCreate()
urUSMHostAlloc()
urUSMDeviceAlloc()
urUSMFree()
urUSMPoolRelease()
urUSMPoolRelease()
urUSMFree()
urUSMPoolRelease()
urUSMPoolRelease()
urContextRelease()

## alloc
Allocate on host/device, no pools

urPlatformGet()
urPlatformGet()
urDeviceGet()
urDeviceGet()
urContextCreate()
urUSMHostAlloc()
urUSMDeviceAlloc()
urUSMFree()
urUSMFree()
urContextRelease()

## kernel-launch
Launch kernel

urPlatformGet()
urPlatformGet()
urDeviceGet()
urDeviceGet()
urContextCreate()
urProgramCreateWithIL()
urProgramBuild()
urKernelCreate()
urQueueCreate()
urEnqueueKernelLaunch()
urEventWait()
urEventRelease()
urQueueFinish()
urQueueRelease()
urKernelRelease()
urProgramRelease()
urContextRelease()
