# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "managedservices assignment wait",
)
class Wait(AAZWaitCommand):
    """Place the CLI in a waiting state until a condition is met.
    """

    _aaz_info = {
        "resources": [
            ["mgmt-plane", "/{scope}/providers/microsoft.managedservices/registrationassignments/{}", "2019-06-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.assignment = AAZStrArg(
            options=["--assignment"],
            help="The identifier (guid) or the fully qualified resource id of the registration assignment. When resource id is used, subscription id and resource group parameters are ignored.",
            required=True,
        )
        _args_schema.scope = AAZStrArg(
            options=["--scope"],
            help="Scope of the resource.",
            required=True,
        )
        _args_schema.include_definition = AAZBoolArg(
            options=["--include-definition"],
            help="Tells whether to return registration definition details also along with registration assignment details.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.RegistrationAssignmentsGet(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=False)
        return result

    class RegistrationAssignmentsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/{scope}/providers/Microsoft.ManagedServices/registrationAssignments/{registrationAssignmentId}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "registrationAssignmentId", self.ctx.args.assignment,
                    required=True,
                ),
                **self.serialize_url_param(
                    "scope", self.ctx.args.scope,
                    skip_quote=True,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expandRegistrationDefinition", self.ctx.args.include_definition,
                ),
                **self.serialize_query_param(
                    "api-version", "2019-06-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.id = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.properties = AAZObjectType()
            _schema_on_200.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.properties
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.registration_definition = AAZObjectType(
                serialized_name="registrationDefinition",
                flags={"read_only": True},
            )
            properties.registration_definition_id = AAZStrType(
                serialized_name="registrationDefinitionId",
                flags={"required": True},
            )

            registration_definition = cls._schema_on_200.properties.registration_definition
            registration_definition.id = AAZStrType(
                flags={"read_only": True},
            )
            registration_definition.name = AAZStrType(
                flags={"read_only": True},
            )
            registration_definition.plan = AAZObjectType()
            registration_definition.properties = AAZObjectType()
            registration_definition.type = AAZStrType(
                flags={"read_only": True},
            )

            plan = cls._schema_on_200.properties.registration_definition.plan
            plan.name = AAZStrType(
                flags={"required": True},
            )
            plan.product = AAZStrType(
                flags={"required": True},
            )
            plan.publisher = AAZStrType(
                flags={"required": True},
            )
            plan.version = AAZStrType(
                flags={"required": True},
            )

            properties = cls._schema_on_200.properties.registration_definition.properties
            properties.authorizations = AAZListType()
            properties.description = AAZStrType()
            properties.managed_by_tenant_id = AAZStrType(
                serialized_name="managedByTenantId",
            )
            properties.managed_by_tenant_name = AAZStrType(
                serialized_name="managedByTenantName",
            )
            properties.managee_tenant_id = AAZStrType(
                serialized_name="manageeTenantId",
            )
            properties.managee_tenant_name = AAZStrType(
                serialized_name="manageeTenantName",
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.registration_definition_name = AAZStrType(
                serialized_name="registrationDefinitionName",
            )

            authorizations = cls._schema_on_200.properties.registration_definition.properties.authorizations
            authorizations.Element = AAZObjectType()

            _element = cls._schema_on_200.properties.registration_definition.properties.authorizations.Element
            _element.delegated_role_definition_ids = AAZListType(
                serialized_name="delegatedRoleDefinitionIds",
            )
            _element.principal_id = AAZStrType(
                serialized_name="principalId",
                flags={"required": True},
            )
            _element.principal_id_display_name = AAZStrType(
                serialized_name="principalIdDisplayName",
            )
            _element.role_definition_id = AAZStrType(
                serialized_name="roleDefinitionId",
                flags={"required": True},
            )

            delegated_role_definition_ids = cls._schema_on_200.properties.registration_definition.properties.authorizations.Element.delegated_role_definition_ids
            delegated_role_definition_ids.Element = AAZStrType()

            return cls._schema_on_200


class _WaitHelper:
    """Helper class for Wait"""


__all__ = ["Wait"]
