---
title: Staticcheck 2026.1 release notes
linkTitle: "2026.1 (v0.7.0)"
weight: -11
---

## Improved Go 1.25 and Go 1.26 support

This release updates Staticcheck’s database of deprecated standard library APIs
to cover the Go 1.25 and Go 1.26 releases, as well as to add some
`crypto/elliptic` deprecations from Go 1.21 that were missing. Furthermore, it
adds support for `new(expr)`, which was added in Go 1.26.

## Other changes

- Version mismatch checks have been relaxed and no longer care about mismatches
  in the patch level. For example, Staticcheck built with Go 1.26.0 will be able
  to check code using Go 1.26.1.
- Staticcheck no longer opens `staticcheck.conf` files that aren't regular files
  (or symlinks to regular files). See [this gomodfs
  issue](https://github.com/tailscale/gomodfs/issues/17) for the motivation
  behind this change.
- Staticcheck now exits with a non-zero status code if it encountered an
  invalid configuration file.

## Checks

### Changed checks

The following checks have been improved:

- {{< check "SA1026" >}} no longer panics when checking code that tries to
  marshal named functions ({{< issue "1660" >}}).
- {{< check "SA4000" >}} no longer flags `var _ = T{} == T{}`, a pattern used to
  ensure that type `T` is comparable ({{< issue "1670" >}}).
- {{< check "SA4000" >}} now correctly skips structs containing floats.
- {{< check "SA4000" >}} now skips functions from the `math/rand/v2` package.
- {{< check "SA4003" >}} now skips over generated files.
- {{< check "SA4030" >}} now also checks uses of `math/rand/v2`.
- {{< check "SA5008" >}} has been updated with better support for `encoding/json/v2`.
- {{< check "SA5010" >}} no longer tries to reason about generics, to avoid
  false positives.
- {{< check "ST1019" >}} no longer flags duplicate imports of unsafe, mainly to
  play nice with cgo.
- {{< check "ST1003" >}} and {{< check "QF1002" >}} now emit more concise
  positions, benefitting users of gopls ({{< issue 1647 >}}).
- {{< check "ST1019" >}} now allows importing the same package twice, once using
  a blank import ({{< issue "1688" >}}).
- {{< check "QF1008" >}} no longer offers to delete all embedded fields from a
  selector expression. Even when two fields are individually superfluous,
  removing both might change the semantics of the code ({{< issue "1682" >}}).
- {{< check "QF1012" >}} now detects more uses of `bytes.Buffer` ({{< issue "1097" >}}).
- A bug in the intermediate representation was fixed, affecting the behavior of
  various checks ({{< issue "1654" >}}).
