#include <functional>
#include <mutex>
#include <thread>

#include "test.h"

#include "epoch.h"

using namespace std;

TEST_CASE("advance") {
	Epoch e;
	CHECK(e.cur() == 1);
	e.advance();
	CHECK(e.cur() == 2);
	e.advance();
	CHECK(e.cur() == 3);
	e.advance();
	CHECK(e.cur() == 4);
}

void epoch_waiter(Epoch* e) {
	mutex m;
	unique_lock<mutex> ul(m);
	size_t cur = e->cur();
	e->wait(&ul);
	CHECK(e->cur() == cur + 1);
}

TEST_CASE("wait") {
	Epoch e;
	e.advance();
	e.advance();
	e.advance();
	e.advance();
	e.advance();
	thread t(bind(&epoch_waiter, &e));
	usleep(1000);
	e.advance();
	t.join();
}

