/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QDir>
#include <QGridLayout>
#include <QSplitter>
#include <QScrollArea>
#include <QWidget>
#include <QVBoxLayout>
#include <QLineEdit>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_FileSystemHierarchyPreferencesWidget.h"
#include "../nongui/ConfigSettings.hpp"


namespace Ui
{
class FileSystemHierarchyPreferencesWidget;
} // namespace Ui


namespace MsXpS
{

namespace MassXpert
{


class FileSystemHierarchyPreferencesWidget : public QWidget
{
  Q_OBJECT

  public:
  FileSystemHierarchyPreferencesWidget(const QString &application_name,
                                       QWidget *parent = nullptr);

  ~FileSystemHierarchyPreferencesWidget();

  bool initializeGeneralConcepts(bool because_init_failed = false);
  bool initialize(bool because_init_failed = false);

  bool checkDataDir(const QDir &);

  QScrollArea *getMainScrollArea();

  void fillInAllTheWidgetry();

  void saveSettings();

  public slots:
  void browseDirPushButtonClicked();
  void eraseSettingsPushButtonClicked();

  protected:
  QString m_applicationName;
  ConfigSettingsSPtr msp_configSettings;

  Ui::FileSystemHierarchyPreferencesWidget *mp_ui;

  QVBoxLayout *mp_groupBoxVertLayout = nullptr;
  QSplitter *mp_splitter             = nullptr;
  QScrollArea *mp_scrollArea         = nullptr;

  QWidget *mp_scrollAreaContentsWidget               = nullptr;
  QVBoxLayout *mp_scrollAreaContentsWidgetVertLayout = nullptr;
  QVBoxLayout *mp_scrollAreaVBoxLayout               = nullptr;

  QMap<QLineEdit *, QPushButton *> m_lineEditPushButtonMap;
  QMap<QLineEdit *, ConfigSettingSPtr> m_lineEditConfigSettingMap;

  QWidget *setupNewWidgetry(ConfigSettingSPtr config_setting_sp);
};


} // namespace MassXpert
} // namespace MsXpS
