# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class ApiDefinitionInfo(_serialization.Model):
    """Information about the formal API definition for the app.

    :ivar url: The URL of the API definition.
    :vartype url: str
    """

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword url: The URL of the API definition.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class ApiManagementConfig(_serialization.Model):
    """Azure API management (APIM) configuration linked to the app.

    :ivar id: APIM-Api Identifier.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: APIM-Api Identifier.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AppServiceCertificate(_serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.KeyVaultSecretStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, key_vault_id: Optional[str] = None, key_vault_secret_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None


class AppServiceCertificateCollection(_serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.AppServiceCertificateResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value:
         list[~azure.mgmt.certificateregistration.models.AppServiceCertificateResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.kind = kind
        self.location = location
        self.type: Optional[str] = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str,
     ~azure.mgmt.certificateregistration.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.certificateregistration.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.certificateregistration.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.certificateregistration.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.certificateregistration.models.CertificateOrderContact
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
        "contact": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
        "contact": {"key": "properties.contact", "type": "CertificateOrderContact"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        certificates: Optional[dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str,
         ~azure.mgmt.certificateregistration.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or
         ~azure.mgmt.certificateregistration.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token: Optional[str] = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional[Union[str, "_models.CertificateOrderStatus"]] = None
        self.signed_certificate: Optional["_models.CertificateDetails"] = None
        self.csr = csr
        self.intermediate: Optional["_models.CertificateDetails"] = None
        self.root: Optional["_models.CertificateDetails"] = None
        self.serial_number: Optional[str] = None
        self.last_certificate_issuance_time: Optional[datetime.datetime] = None
        self.expiration_time: Optional[datetime.datetime] = None
        self.is_private_key_external: Optional[bool] = None
        self.app_service_certificate_not_renewable_reasons: Optional[
            list[Union[str, "_models.ResourceNotRenewableReason"]]
        ] = None
        self.next_auto_renewal_time_stamp: Optional[datetime.datetime] = None
        self.contact: Optional["_models.CertificateOrderContact"] = None


class AppServiceCertificateOrderCollection(_serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateOrder]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.AppServiceCertificateOrder"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.AppServiceCertificateOrder]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.kind = kind
        self.type: Optional[str] = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str,
     ~azure.mgmt.certificateregistration.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be 1).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.certificateregistration.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.certificateregistration.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.certificateregistration.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.certificateregistration.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.certificateregistration.models.CertificateOrderContact
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
        "contact": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
        "contact": {"key": "properties.contact", "type": "CertificateOrderContact"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str,
         ~azure.mgmt.certificateregistration.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be 1).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or
         ~azure.mgmt.certificateregistration.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token: Optional[str] = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional[Union[str, "_models.CertificateOrderStatus"]] = None
        self.signed_certificate: Optional["_models.CertificateDetails"] = None
        self.csr = csr
        self.intermediate: Optional["_models.CertificateDetails"] = None
        self.root: Optional["_models.CertificateDetails"] = None
        self.serial_number: Optional[str] = None
        self.last_certificate_issuance_time: Optional[datetime.datetime] = None
        self.expiration_time: Optional[datetime.datetime] = None
        self.is_private_key_external: Optional[bool] = None
        self.app_service_certificate_not_renewable_reasons: Optional[
            list[Union[str, "_models.ResourceNotRenewableReason"]]
        ] = None
        self.next_auto_renewal_time_stamp: Optional[datetime.datetime] = None
        self.contact: Optional["_models.CertificateOrderContact"] = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None


class AppServiceEnvironment(_serialization.Model):
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar provisioning_state: Provisioning state of the App Service Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Known values are: "Preparing",
     "Ready", "Scaling", and "Deleting".
    :vartype status: str or ~azure.mgmt.certificateregistration.models.HostingEnvironmentStatus
    :ivar virtual_network: Description of the Virtual Network. Required.
    :vartype virtual_network: ~azure.mgmt.certificateregistration.models.VirtualNetworkProfile
    :ivar internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
     and "Web, Publishing".
    :vartype internal_load_balancing_mode: str or
     ~azure.mgmt.certificateregistration.models.LoadBalancingMode
    :ivar multi_size: Front-end VM size, e.g. "Medium", "Large".
    :vartype multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :ivar ipssl_address_count: Number of IP SSL addresses reserved for the App Service Environment.
    :vartype ipssl_address_count: int
    :ivar dns_suffix: DNS suffix of the App Service Environment.
    :vartype dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :ivar front_end_scale_factor: Scale factor for front-ends.
    :vartype front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :ivar cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :vartype cluster_settings: list[~azure.mgmt.certificateregistration.models.NameValuePair]
    :ivar user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :vartype user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
     "Manual".
    :vartype upgrade_preference: str or
     ~azure.mgmt.certificateregistration.models.UpgradePreference
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    :ivar zone_redundant: Whether or not this App Service Environment is zone-redundant.
    :vartype zone_redundant: bool
    :ivar custom_dns_suffix_configuration: Full view of the custom domain suffix configuration for
     ASEv3.
    :vartype custom_dns_suffix_configuration:
     ~azure.mgmt.certificateregistration.models.CustomDnsSuffixConfiguration
    :ivar networking_configuration: Full view of networking configuration for an ASE.
    :vartype networking_configuration:
     ~azure.mgmt.certificateregistration.models.AseV3NetworkingConfiguration
    :ivar upgrade_availability: Whether an upgrade is available for this App Service Environment.
     Known values are: "None" and "Ready".
    :vartype upgrade_availability: str or
     ~azure.mgmt.certificateregistration.models.UpgradeAvailability
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "virtual_network": {"required": True},
        "multi_role_count": {"readonly": True},
        "maximum_number_of_machines": {"readonly": True},
        "suspended": {"readonly": True},
        "has_linux_workers": {"readonly": True},
        "upgrade_availability": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "virtual_network": {"key": "virtualNetwork", "type": "VirtualNetworkProfile"},
        "internal_load_balancing_mode": {"key": "internalLoadBalancingMode", "type": "str"},
        "multi_size": {"key": "multiSize", "type": "str"},
        "multi_role_count": {"key": "multiRoleCount", "type": "int"},
        "ipssl_address_count": {"key": "ipsslAddressCount", "type": "int"},
        "dns_suffix": {"key": "dnsSuffix", "type": "str"},
        "maximum_number_of_machines": {"key": "maximumNumberOfMachines", "type": "int"},
        "front_end_scale_factor": {"key": "frontEndScaleFactor", "type": "int"},
        "suspended": {"key": "suspended", "type": "bool"},
        "cluster_settings": {"key": "clusterSettings", "type": "[NameValuePair]"},
        "user_whitelisted_ip_ranges": {"key": "userWhitelistedIpRanges", "type": "[str]"},
        "has_linux_workers": {"key": "hasLinuxWorkers", "type": "bool"},
        "upgrade_preference": {"key": "upgradePreference", "type": "str"},
        "dedicated_host_count": {"key": "dedicatedHostCount", "type": "int"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "custom_dns_suffix_configuration": {
            "key": "customDnsSuffixConfiguration",
            "type": "CustomDnsSuffixConfiguration",
        },
        "networking_configuration": {"key": "networkingConfiguration", "type": "AseV3NetworkingConfiguration"},
        "upgrade_availability": {"key": "upgradeAvailability", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_network: "_models.VirtualNetworkProfile",
        internal_load_balancing_mode: Optional[Union[str, "_models.LoadBalancingMode"]] = None,
        multi_size: Optional[str] = None,
        ipssl_address_count: Optional[int] = None,
        dns_suffix: Optional[str] = None,
        front_end_scale_factor: Optional[int] = None,
        cluster_settings: Optional[list["_models.NameValuePair"]] = None,
        user_whitelisted_ip_ranges: Optional[list[str]] = None,
        upgrade_preference: Union[str, "_models.UpgradePreference"] = "None",
        dedicated_host_count: Optional[int] = None,
        zone_redundant: Optional[bool] = None,
        custom_dns_suffix_configuration: Optional["_models.CustomDnsSuffixConfiguration"] = None,
        networking_configuration: Optional["_models.AseV3NetworkingConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_network: Description of the Virtual Network. Required.
        :paramtype virtual_network: ~azure.mgmt.certificateregistration.models.VirtualNetworkProfile
        :keyword internal_load_balancing_mode: Specifies which endpoints to serve internally in the
         Virtual Network for the App Service Environment. Known values are: "None", "Web", "Publishing",
         and "Web, Publishing".
        :paramtype internal_load_balancing_mode: str or
         ~azure.mgmt.certificateregistration.models.LoadBalancingMode
        :keyword multi_size: Front-end VM size, e.g. "Medium", "Large".
        :paramtype multi_size: str
        :keyword ipssl_address_count: Number of IP SSL addresses reserved for the App Service
         Environment.
        :paramtype ipssl_address_count: int
        :keyword dns_suffix: DNS suffix of the App Service Environment.
        :paramtype dns_suffix: str
        :keyword front_end_scale_factor: Scale factor for front-ends.
        :paramtype front_end_scale_factor: int
        :keyword cluster_settings: Custom settings for changing the behavior of the App Service
         Environment.
        :paramtype cluster_settings: list[~azure.mgmt.certificateregistration.models.NameValuePair]
        :keyword user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
        :paramtype user_whitelisted_ip_ranges: list[str]
        :keyword upgrade_preference: Upgrade Preference. Known values are: "None", "Early", "Late", and
         "Manual".
        :paramtype upgrade_preference: str or
         ~azure.mgmt.certificateregistration.models.UpgradePreference
        :keyword dedicated_host_count: Dedicated Host Count.
        :paramtype dedicated_host_count: int
        :keyword zone_redundant: Whether or not this App Service Environment is zone-redundant.
        :paramtype zone_redundant: bool
        :keyword custom_dns_suffix_configuration: Full view of the custom domain suffix configuration
         for ASEv3.
        :paramtype custom_dns_suffix_configuration:
         ~azure.mgmt.certificateregistration.models.CustomDnsSuffixConfiguration
        :keyword networking_configuration: Full view of networking configuration for an ASE.
        :paramtype networking_configuration:
         ~azure.mgmt.certificateregistration.models.AseV3NetworkingConfiguration
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.status: Optional[Union[str, "_models.HostingEnvironmentStatus"]] = None
        self.virtual_network = virtual_network
        self.internal_load_balancing_mode = internal_load_balancing_mode
        self.multi_size = multi_size
        self.multi_role_count: Optional[int] = None
        self.ipssl_address_count = ipssl_address_count
        self.dns_suffix = dns_suffix
        self.maximum_number_of_machines: Optional[int] = None
        self.front_end_scale_factor = front_end_scale_factor
        self.suspended: Optional[bool] = None
        self.cluster_settings = cluster_settings
        self.user_whitelisted_ip_ranges = user_whitelisted_ip_ranges
        self.has_linux_workers: Optional[bool] = None
        self.upgrade_preference = upgrade_preference
        self.dedicated_host_count = dedicated_host_count
        self.zone_redundant = zone_redundant
        self.custom_dns_suffix_configuration = custom_dns_suffix_configuration
        self.networking_configuration = networking_configuration
        self.upgrade_availability: Optional[Union[str, "_models.UpgradeAvailability"]] = None


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: Description of a SKU for a scalable resource.
    :vartype sku: ~azure.mgmt.certificateregistration.models.SkuDescription
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.certificateregistration.models.ExtendedLocation
    :ivar worker_tier_name: Target worker tier assigned to the App Service plan.
    :vartype worker_tier_name: str
    :ivar status: App Service plan status. Known values are: "Ready", "Pending", and "Creating".
    :vartype status: str or ~azure.mgmt.certificateregistration.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     App Service plan.
    :vartype hosting_environment_profile:
     ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar number_of_workers: The number of instances that are assigned to this App Service plan.
    :vartype number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :ivar per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :vartype per_site_scaling: bool
    :ivar elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :vartype elastic_scale_enabled: bool
    :ivar maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :vartype maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :ivar is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :vartype is_spot: bool
    :ivar spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :vartype spot_expiration_time: ~datetime.datetime
    :ivar free_offer_expiration_time: The time when the server farm free offer expires.
    :vartype free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :ivar reserved: If Linux app service plan :code:`<code>true</code>`, :code:`<code>false</code>`
     otherwise.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype is_xenon: bool
    :ivar hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :vartype hyper_v: bool
    :ivar target_worker_count: Scaling worker count.
    :vartype target_worker_count: int
    :ivar target_worker_size_id: Scaling worker size ID.
    :vartype target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Known values are:
     "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.ProvisioningState
    :ivar kube_environment_profile: Specification for the Kubernetes Environment to use for the App
     Service plan.
    :vartype kube_environment_profile:
     ~azure.mgmt.certificateregistration.models.KubeEnvironmentProfile
    :ivar zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
     availability zone balancing.
     If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
     balancing.
    :vartype zone_redundant: bool
    :ivar async_scaling_enabled: If :code:`<code>true</code>`, this App Service Plan will attempt
     to scale asynchronously if there are insufficient workers to scale synchronously.
     If :code:`<code>false</code>`, this App Service Plan will only attempt sync scaling.
    :vartype async_scaling_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "subscription": {"readonly": True},
        "maximum_number_of_workers": {"readonly": True},
        "number_of_workers": {"readonly": True},
        "geo_region": {"readonly": True},
        "number_of_sites": {"readonly": True},
        "resource_group": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "SkuDescription"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "worker_tier_name": {"key": "properties.workerTierName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "maximum_number_of_workers": {"key": "properties.maximumNumberOfWorkers", "type": "int"},
        "number_of_workers": {"key": "properties.numberOfWorkers", "type": "int"},
        "geo_region": {"key": "properties.geoRegion", "type": "str"},
        "per_site_scaling": {"key": "properties.perSiteScaling", "type": "bool"},
        "elastic_scale_enabled": {"key": "properties.elasticScaleEnabled", "type": "bool"},
        "maximum_elastic_worker_count": {"key": "properties.maximumElasticWorkerCount", "type": "int"},
        "number_of_sites": {"key": "properties.numberOfSites", "type": "int"},
        "is_spot": {"key": "properties.isSpot", "type": "bool"},
        "spot_expiration_time": {"key": "properties.spotExpirationTime", "type": "iso-8601"},
        "free_offer_expiration_time": {"key": "properties.freeOfferExpirationTime", "type": "iso-8601"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "target_worker_count": {"key": "properties.targetWorkerCount", "type": "int"},
        "target_worker_size_id": {"key": "properties.targetWorkerSizeId", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "kube_environment_profile": {"key": "properties.kubeEnvironmentProfile", "type": "KubeEnvironmentProfile"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "async_scaling_enabled": {"key": "properties.asyncScalingEnabled", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.SkuDescription"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        worker_tier_name: Optional[str] = None,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        per_site_scaling: bool = False,
        elastic_scale_enabled: Optional[bool] = None,
        maximum_elastic_worker_count: Optional[int] = None,
        is_spot: Optional[bool] = None,
        spot_expiration_time: Optional[datetime.datetime] = None,
        free_offer_expiration_time: Optional[datetime.datetime] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        target_worker_count: Optional[int] = None,
        target_worker_size_id: Optional[int] = None,
        kube_environment_profile: Optional["_models.KubeEnvironmentProfile"] = None,
        zone_redundant: bool = False,
        async_scaling_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: Description of a SKU for a scalable resource.
        :paramtype sku: ~azure.mgmt.certificateregistration.models.SkuDescription
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.certificateregistration.models.ExtendedLocation
        :keyword worker_tier_name: Target worker tier assigned to the App Service plan.
        :paramtype worker_tier_name: str
        :keyword hosting_environment_profile: Specification for the App Service Environment to use for
         the App Service plan.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
        :keyword per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
         can be scaled independently.
         If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
         instances of the plan.
        :paramtype per_site_scaling: bool
        :keyword elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale
         as if the ServerFarm was ElasticPremium sku.
        :paramtype elastic_scale_enabled: bool
        :keyword maximum_elastic_worker_count: Maximum number of total workers allowed for this
         ElasticScaleEnabled App Service Plan.
        :paramtype maximum_elastic_worker_count: int
        :keyword is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
        :paramtype is_spot: bool
        :keyword spot_expiration_time: The time when the server farm expires. Valid only if it is a
         spot server farm.
        :paramtype spot_expiration_time: ~datetime.datetime
        :keyword free_offer_expiration_time: The time when the server farm free offer expires.
        :paramtype free_offer_expiration_time: ~datetime.datetime
        :keyword reserved: If Linux app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype is_xenon: bool
        :keyword hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
         :code:`<code>false</code>` otherwise.
        :paramtype hyper_v: bool
        :keyword target_worker_count: Scaling worker count.
        :paramtype target_worker_count: int
        :keyword target_worker_size_id: Scaling worker size ID.
        :paramtype target_worker_size_id: int
        :keyword kube_environment_profile: Specification for the Kubernetes Environment to use for the
         App Service plan.
        :paramtype kube_environment_profile:
         ~azure.mgmt.certificateregistration.models.KubeEnvironmentProfile
        :keyword zone_redundant: If :code:`<code>true</code>`, this App Service Plan will perform
         availability zone balancing.
         If :code:`<code>false</code>`, this App Service Plan will not perform availability zone
         balancing.
        :paramtype zone_redundant: bool
        :keyword async_scaling_enabled: If :code:`<code>true</code>`, this App Service Plan will
         attempt to scale asynchronously if there are insufficient workers to scale synchronously.
         If :code:`<code>false</code>`, this App Service Plan will only attempt sync scaling.
        :paramtype async_scaling_enabled: bool
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.extended_location = extended_location
        self.worker_tier_name = worker_tier_name
        self.status: Optional[Union[str, "_models.StatusOptions"]] = None
        self.subscription: Optional[str] = None
        self.hosting_environment_profile = hosting_environment_profile
        self.maximum_number_of_workers: Optional[int] = None
        self.number_of_workers: Optional[int] = None
        self.geo_region: Optional[str] = None
        self.per_site_scaling = per_site_scaling
        self.elastic_scale_enabled = elastic_scale_enabled
        self.maximum_elastic_worker_count = maximum_elastic_worker_count
        self.number_of_sites: Optional[int] = None
        self.is_spot = is_spot
        self.spot_expiration_time = spot_expiration_time
        self.free_offer_expiration_time = free_offer_expiration_time
        self.resource_group: Optional[str] = None
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.target_worker_count = target_worker_count
        self.target_worker_size_id = target_worker_size_id
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.kube_environment_profile = kube_environment_profile
        self.zone_redundant = zone_redundant
        self.async_scaling_enabled = async_scaling_enabled


class AppServicePlanCollection(_serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServicePlan]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.AppServicePlan"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.AppServicePlan]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ArmIdWrapper(_serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class AseV3NetworkingConfiguration(ProxyOnlyResource):
    """Full view of networking configuration for an ASE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar windows_outbound_ip_addresses:
    :vartype windows_outbound_ip_addresses: list[str]
    :ivar linux_outbound_ip_addresses:
    :vartype linux_outbound_ip_addresses: list[str]
    :ivar external_inbound_ip_addresses:
    :vartype external_inbound_ip_addresses: list[str]
    :ivar internal_inbound_ip_addresses:
    :vartype internal_inbound_ip_addresses: list[str]
    :ivar allow_new_private_endpoint_connections: Property to enable and disable new private
     endpoint connection creation on ASE.
    :vartype allow_new_private_endpoint_connections: bool
    :ivar ftp_enabled: Property to enable and disable FTP on ASEV3.
    :vartype ftp_enabled: bool
    :ivar remote_debug_enabled: Property to enable and disable Remote Debug on ASEV3.
    :vartype remote_debug_enabled: bool
    :ivar inbound_ip_address_override: Customer provided Inbound IP Address. Only able to be set on
     Ase create.
    :vartype inbound_ip_address_override: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "windows_outbound_ip_addresses": {"readonly": True},
        "linux_outbound_ip_addresses": {"readonly": True},
        "external_inbound_ip_addresses": {"readonly": True},
        "internal_inbound_ip_addresses": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "windows_outbound_ip_addresses": {"key": "properties.windowsOutboundIpAddresses", "type": "[str]"},
        "linux_outbound_ip_addresses": {"key": "properties.linuxOutboundIpAddresses", "type": "[str]"},
        "external_inbound_ip_addresses": {"key": "properties.externalInboundIpAddresses", "type": "[str]"},
        "internal_inbound_ip_addresses": {"key": "properties.internalInboundIpAddresses", "type": "[str]"},
        "allow_new_private_endpoint_connections": {
            "key": "properties.allowNewPrivateEndpointConnections",
            "type": "bool",
        },
        "ftp_enabled": {"key": "properties.ftpEnabled", "type": "bool"},
        "remote_debug_enabled": {"key": "properties.remoteDebugEnabled", "type": "bool"},
        "inbound_ip_address_override": {"key": "properties.inboundIpAddressOverride", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        allow_new_private_endpoint_connections: Optional[bool] = None,
        ftp_enabled: Optional[bool] = None,
        remote_debug_enabled: Optional[bool] = None,
        inbound_ip_address_override: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword allow_new_private_endpoint_connections: Property to enable and disable new private
         endpoint connection creation on ASE.
        :paramtype allow_new_private_endpoint_connections: bool
        :keyword ftp_enabled: Property to enable and disable FTP on ASEV3.
        :paramtype ftp_enabled: bool
        :keyword remote_debug_enabled: Property to enable and disable Remote Debug on ASEV3.
        :paramtype remote_debug_enabled: bool
        :keyword inbound_ip_address_override: Customer provided Inbound IP Address. Only able to be set
         on Ase create.
        :paramtype inbound_ip_address_override: str
        """
        super().__init__(kind=kind, **kwargs)
        self.windows_outbound_ip_addresses: Optional[list[str]] = None
        self.linux_outbound_ip_addresses: Optional[list[str]] = None
        self.external_inbound_ip_addresses: Optional[list[str]] = None
        self.internal_inbound_ip_addresses: Optional[list[str]] = None
        self.allow_new_private_endpoint_connections = allow_new_private_endpoint_connections
        self.ftp_enabled = ftp_enabled
        self.remote_debug_enabled = remote_debug_enabled
        self.inbound_ip_address_override = inbound_ip_address_override


class AutoHealActions(_serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :ivar action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent", and
     "CustomAction".
    :vartype action_type: str or ~azure.mgmt.certificateregistration.models.AutoHealActionType
    :ivar custom_action: Custom action to be taken.
    :vartype custom_action: ~azure.mgmt.certificateregistration.models.AutoHealCustomAction
    :ivar min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :vartype min_process_execution_time: str
    """

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "custom_action": {"key": "customAction", "type": "AutoHealCustomAction"},
        "min_process_execution_time": {"key": "minProcessExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_type: Optional[Union[str, "_models.AutoHealActionType"]] = None,
        custom_action: Optional["_models.AutoHealCustomAction"] = None,
        min_process_execution_time: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_type: Predefined action to be taken. Known values are: "Recycle", "LogEvent",
         and "CustomAction".
        :paramtype action_type: str or ~azure.mgmt.certificateregistration.models.AutoHealActionType
        :keyword custom_action: Custom action to be taken.
        :paramtype custom_action: ~azure.mgmt.certificateregistration.models.AutoHealCustomAction
        :keyword min_process_execution_time: Minimum time the process must execute
         before taking the action.
        :paramtype min_process_execution_time: str
        """
        super().__init__(**kwargs)
        self.action_type = action_type
        self.custom_action = custom_action
        self.min_process_execution_time = min_process_execution_time


class AutoHealCustomAction(_serialization.Model):
    """Custom action to be executed
    when an auto heal rule is triggered.

    :ivar exe: Executable to be run.
    :vartype exe: str
    :ivar parameters: Parameters for the executable.
    :vartype parameters: str
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(self, *, exe: Optional[str] = None, parameters: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword exe: Executable to be run.
        :paramtype exe: str
        :keyword parameters: Parameters for the executable.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.parameters = parameters


class AutoHealRules(_serialization.Model):
    """Rules that can be defined for auto-heal.

    :ivar triggers: Conditions that describe when to execute the auto-heal actions.
    :vartype triggers: ~azure.mgmt.certificateregistration.models.AutoHealTriggers
    :ivar actions: Actions to be executed when a rule is triggered.
    :vartype actions: ~azure.mgmt.certificateregistration.models.AutoHealActions
    """

    _attribute_map = {
        "triggers": {"key": "triggers", "type": "AutoHealTriggers"},
        "actions": {"key": "actions", "type": "AutoHealActions"},
    }

    def __init__(
        self,
        *,
        triggers: Optional["_models.AutoHealTriggers"] = None,
        actions: Optional["_models.AutoHealActions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword triggers: Conditions that describe when to execute the auto-heal actions.
        :paramtype triggers: ~azure.mgmt.certificateregistration.models.AutoHealTriggers
        :keyword actions: Actions to be executed when a rule is triggered.
        :paramtype actions: ~azure.mgmt.certificateregistration.models.AutoHealActions
        """
        super().__init__(**kwargs)
        self.triggers = triggers
        self.actions = actions


class AutoHealTriggers(_serialization.Model):
    """Triggers for auto-heal.

    :ivar requests: A rule based on total requests.
    :vartype requests: ~azure.mgmt.certificateregistration.models.RequestsBasedTrigger
    :ivar private_bytes_in_kb: A rule based on private bytes.
    :vartype private_bytes_in_kb: int
    :ivar status_codes: A rule based on status codes.
    :vartype status_codes: list[~azure.mgmt.certificateregistration.models.StatusCodesBasedTrigger]
    :ivar slow_requests: A rule based on request execution time.
    :vartype slow_requests: ~azure.mgmt.certificateregistration.models.SlowRequestsBasedTrigger
    :ivar slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
    :vartype slow_requests_with_path:
     list[~azure.mgmt.certificateregistration.models.SlowRequestsBasedTrigger]
    :ivar status_codes_range: A rule based on status codes ranges.
    :vartype status_codes_range:
     list[~azure.mgmt.certificateregistration.models.StatusCodesRangeBasedTrigger]
    """

    _attribute_map = {
        "requests": {"key": "requests", "type": "RequestsBasedTrigger"},
        "private_bytes_in_kb": {"key": "privateBytesInKB", "type": "int"},
        "status_codes": {"key": "statusCodes", "type": "[StatusCodesBasedTrigger]"},
        "slow_requests": {"key": "slowRequests", "type": "SlowRequestsBasedTrigger"},
        "slow_requests_with_path": {"key": "slowRequestsWithPath", "type": "[SlowRequestsBasedTrigger]"},
        "status_codes_range": {"key": "statusCodesRange", "type": "[StatusCodesRangeBasedTrigger]"},
    }

    def __init__(
        self,
        *,
        requests: Optional["_models.RequestsBasedTrigger"] = None,
        private_bytes_in_kb: Optional[int] = None,
        status_codes: Optional[list["_models.StatusCodesBasedTrigger"]] = None,
        slow_requests: Optional["_models.SlowRequestsBasedTrigger"] = None,
        slow_requests_with_path: Optional[list["_models.SlowRequestsBasedTrigger"]] = None,
        status_codes_range: Optional[list["_models.StatusCodesRangeBasedTrigger"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requests: A rule based on total requests.
        :paramtype requests: ~azure.mgmt.certificateregistration.models.RequestsBasedTrigger
        :keyword private_bytes_in_kb: A rule based on private bytes.
        :paramtype private_bytes_in_kb: int
        :keyword status_codes: A rule based on status codes.
        :paramtype status_codes:
         list[~azure.mgmt.certificateregistration.models.StatusCodesBasedTrigger]
        :keyword slow_requests: A rule based on request execution time.
        :paramtype slow_requests: ~azure.mgmt.certificateregistration.models.SlowRequestsBasedTrigger
        :keyword slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
        :paramtype slow_requests_with_path:
         list[~azure.mgmt.certificateregistration.models.SlowRequestsBasedTrigger]
        :keyword status_codes_range: A rule based on status codes ranges.
        :paramtype status_codes_range:
         list[~azure.mgmt.certificateregistration.models.StatusCodesRangeBasedTrigger]
        """
        super().__init__(**kwargs)
        self.requests = requests
        self.private_bytes_in_kb = private_bytes_in_kb
        self.status_codes = status_codes
        self.slow_requests = slow_requests
        self.slow_requests_with_path = slow_requests_with_path
        self.status_codes_range = status_codes_range


class AzureStorageInfoValue(_serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.AzureStorageType
    :ivar account_name: Name of the storage account.
    :vartype account_name: str
    :ivar share_name: Name of the file share (container name, for Blob storage).
    :vartype share_name: str
    :ivar access_key: Access key for the storage account.
    :vartype access_key: str
    :ivar mount_path: Path to mount the storage within the site's runtime environment.
    :vartype mount_path: str
    :ivar state: State of the storage account. Known values are: "Ok", "InvalidCredentials",
     "InvalidShare", and "NotValidated".
    :vartype state: str or ~azure.mgmt.certificateregistration.models.AzureStorageState
    :ivar protocol: Mounting protocol to use for the storage account. Known values are: "Smb",
     "Http", and "Nfs".
    :vartype protocol: str or ~azure.mgmt.certificateregistration.models.AzureStorageProtocol
    """

    _validation = {
        "state": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
        "access_key": {"key": "accessKey", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AzureStorageType"]] = None,
        account_name: Optional[str] = None,
        share_name: Optional[str] = None,
        access_key: Optional[str] = None,
        mount_path: Optional[str] = None,
        protocol: Optional[Union[str, "_models.AzureStorageProtocol"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of storage. Known values are: "AzureFiles" and "AzureBlob".
        :paramtype type: str or ~azure.mgmt.certificateregistration.models.AzureStorageType
        :keyword account_name: Name of the storage account.
        :paramtype account_name: str
        :keyword share_name: Name of the file share (container name, for Blob storage).
        :paramtype share_name: str
        :keyword access_key: Access key for the storage account.
        :paramtype access_key: str
        :keyword mount_path: Path to mount the storage within the site's runtime environment.
        :paramtype mount_path: str
        :keyword protocol: Mounting protocol to use for the storage account. Known values are: "Smb",
         "Http", and "Nfs".
        :paramtype protocol: str or ~azure.mgmt.certificateregistration.models.AzureStorageProtocol
        """
        super().__init__(**kwargs)
        self.type = type
        self.account_name = account_name
        self.share_name = share_name
        self.access_key = access_key
        self.mount_path = mount_path
        self.state: Optional[Union[str, "_models.AzureStorageState"]] = None
        self.protocol = protocol


class Capability(_serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :ivar name: Name of the SKU capability.
    :vartype name: str
    :ivar value: Value of the SKU capability.
    :vartype value: str
    :ivar reason: Reason of the SKU capability.
    :vartype reason: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, value: Optional[str] = None, reason: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the SKU capability.
        :paramtype name: str
        :keyword value: Value of the SKU capability.
        :paramtype value: str
        :keyword reason: Reason of the SKU capability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.reason = reason


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
    :ivar key_vault_id: Azure Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Azure Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.certificateregistration.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan.
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "password": {"key": "properties.password", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "canonical_name": {"key": "properties.canonicalName", "type": "str"},
        "domain_validation_method": {"key": "properties.domainValidationMethod", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        password: Optional[str] = None,
        host_names: Optional[list[str]] = None,
        pfx_blob: Optional[bytes] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword key_vault_id: Azure Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Azure Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan.
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.password = password
        self.friendly_name: Optional[str] = None
        self.subject_name: Optional[str] = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name: Optional[str] = None
        self.self_link: Optional[str] = None
        self.issuer: Optional[str] = None
        self.issue_date: Optional[datetime.datetime] = None
        self.expiration_date: Optional[datetime.datetime] = None
        self.thumbprint: Optional[str] = None
        self.valid: Optional[bool] = None
        self.cer_blob: Optional[bytes] = None
        self.public_key_hash: Optional[str] = None
        self.hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class CertificateCollection(_serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Certificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.Certificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CertificateDetails(_serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        "version": {"readonly": True},
        "serial_number": {"readonly": True},
        "thumbprint": {"readonly": True},
        "subject": {"readonly": True},
        "not_before": {"readonly": True},
        "not_after": {"readonly": True},
        "signature_algorithm": {"readonly": True},
        "issuer": {"readonly": True},
        "raw_data": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "not_before": {"key": "notBefore", "type": "iso-8601"},
        "not_after": {"key": "notAfter", "type": "iso-8601"},
        "signature_algorithm": {"key": "signatureAlgorithm", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "raw_data": {"key": "rawData", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version: Optional[int] = None
        self.serial_number: Optional[str] = None
        self.thumbprint: Optional[str] = None
        self.subject: Optional[str] = None
        self.not_before: Optional[datetime.datetime] = None
        self.not_after: Optional[datetime.datetime] = None
        self.signature_algorithm: Optional[str] = None
        self.issuer: Optional[str] = None
        self.raw_data: Optional[str] = None


class CertificateEmail(_serialization.Model):
    """SSL certificate email.

    :ivar email_id: Email id.
    :vartype email_id: str
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    """

    _attribute_map = {
        "email_id": {"key": "emailId", "type": "str"},
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
    }

    def __init__(
        self, *, email_id: Optional[str] = None, time_stamp: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword email_id: Email id.
        :paramtype email_id: str
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(_serialization.Model):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar action_type: Action type. Known values are: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", and "Unknown".
    :vartype action_type: str or
     ~azure.mgmt.certificateregistration.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        "action_type": {"readonly": True},
        "created_at": {"readonly": True},
    }

    _attribute_map = {
        "action_type": {"key": "actionType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.action_type: Optional[Union[str, "_models.CertificateOrderActionType"]] = None
        self.created_at: Optional[datetime.datetime] = None


class CertificateOrderContact(_serialization.Model):
    """CertificateOrderContact.

    :ivar email:
    :vartype email: str
    :ivar name_first:
    :vartype name_first: str
    :ivar name_last:
    :vartype name_last: str
    :ivar phone:
    :vartype phone: str
    """

    _attribute_map = {
        "email": {"key": "email", "type": "str"},
        "name_first": {"key": "nameFirst", "type": "str"},
        "name_last": {"key": "nameLast", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        email: Optional[str] = None,
        name_first: Optional[str] = None,
        name_last: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword email:
        :paramtype email: str
        :keyword name_first:
        :paramtype name_first: str
        :keyword name_last:
        :paramtype name_last: str
        :keyword phone:
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.email = email
        self.name_first = name_first
        self.name_last = name_last
        self.phone = phone


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar password: Certificate password.
    :vartype password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar host_names: Host names the certificate applies to.
    :vartype host_names: list[str]
    :ivar pfx_blob: Pfx blob.
    :vartype pfx_blob: bytes
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytes
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
    :ivar key_vault_id: Key Vault Csm resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.certificateregistration.models.KeyVaultSecretStatus
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar canonical_name: CNAME of the certificate to be issued via free certificate.
    :vartype canonical_name: str
    :ivar domain_validation_method: Method of domain validation for free cert.
    :vartype domain_validation_method: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "subject_name": {"readonly": True},
        "site_name": {"readonly": True},
        "self_link": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "cer_blob": {"readonly": True},
        "public_key_hash": {"readonly": True},
        "hosting_environment_profile": {"readonly": True},
        "key_vault_secret_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "subject_name": {"key": "properties.subjectName", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "pfx_blob": {"key": "properties.pfxBlob", "type": "bytearray"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "self_link": {"key": "properties.selfLink", "type": "str"},
        "issuer": {"key": "properties.issuer", "type": "str"},
        "issue_date": {"key": "properties.issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "valid": {"key": "properties.valid", "type": "bool"},
        "cer_blob": {"key": "properties.cerBlob", "type": "bytearray"},
        "public_key_hash": {"key": "properties.publicKeyHash", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "key_vault_secret_status": {"key": "properties.keyVaultSecretStatus", "type": "str"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "canonical_name": {"key": "properties.canonicalName", "type": "str"},
        "domain_validation_method": {"key": "properties.domainValidationMethod", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: Optional[str] = None,
        password: Optional[str] = None,
        host_names: Optional[list[str]] = None,
        pfx_blob: Optional[bytes] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        server_farm_id: Optional[str] = None,
        canonical_name: Optional[str] = None,
        domain_validation_method: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword host_names: Host names the certificate applies to.
        :paramtype host_names: list[str]
        :keyword pfx_blob: Pfx blob.
        :paramtype pfx_blob: bytes
        :keyword key_vault_id: Key Vault Csm resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword canonical_name: CNAME of the certificate to be issued via free certificate.
        :paramtype canonical_name: str
        :keyword domain_validation_method: Method of domain validation for free cert.
        :paramtype domain_validation_method: str
        """
        super().__init__(kind=kind, **kwargs)
        self.password = password
        self.friendly_name: Optional[str] = None
        self.subject_name: Optional[str] = None
        self.host_names = host_names
        self.pfx_blob = pfx_blob
        self.site_name: Optional[str] = None
        self.self_link: Optional[str] = None
        self.issuer: Optional[str] = None
        self.issue_date: Optional[datetime.datetime] = None
        self.expiration_date: Optional[datetime.datetime] = None
        self.thumbprint: Optional[str] = None
        self.valid: Optional[bool] = None
        self.cer_blob: Optional[bytes] = None
        self.public_key_hash: Optional[str] = None
        self.hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.key_vault_secret_status: Optional[Union[str, "_models.KeyVaultSecretStatus"]] = None
        self.server_farm_id = server_farm_id
        self.canonical_name = canonical_name
        self.domain_validation_method = domain_validation_method


class CipherSuites(_serialization.Model):
    """Describes valid TLS cipher suites.

    :ivar suites: List of TLS Cipher Suites that are supported by App Service.
    :vartype suites: list[str]
    """

    _attribute_map = {
        "suites": {"key": "suites", "type": "[str]"},
    }

    def __init__(self, *, suites: Optional[list[str]] = None, **kwargs: Any) -> None:
        """
        :keyword suites: List of TLS Cipher Suites that are supported by App Service.
        :paramtype suites: list[str]
        """
        super().__init__(**kwargs)
        self.suites = suites


class CloningInfo(_serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to server.

    :ivar correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :vartype correlation_id: str
    :ivar overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :vartype overwrite: bool
    :ivar clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :vartype clone_custom_host_names: bool
    :ivar clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :vartype clone_source_control: bool
    :ivar source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots. Required.
    :vartype source_web_app_id: str
    :ivar source_web_app_location: Location of source app ex: West US or North Europe.
    :vartype source_web_app_location: str
    :ivar hosting_environment: App Service Environment.
    :vartype hosting_environment: str
    :ivar app_settings_overrides: Application setting overrides for cloned app. If specified, these
     settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :vartype app_settings_overrides: dict[str, str]
    :ivar configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :vartype configure_load_balancing: bool
    :ivar traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
     /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :vartype traffic_manager_profile_id: str
    :ivar traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :vartype traffic_manager_profile_name: str
    """

    _validation = {
        "source_web_app_id": {"required": True},
    }

    _attribute_map = {
        "correlation_id": {"key": "correlationId", "type": "str"},
        "overwrite": {"key": "overwrite", "type": "bool"},
        "clone_custom_host_names": {"key": "cloneCustomHostNames", "type": "bool"},
        "clone_source_control": {"key": "cloneSourceControl", "type": "bool"},
        "source_web_app_id": {"key": "sourceWebAppId", "type": "str"},
        "source_web_app_location": {"key": "sourceWebAppLocation", "type": "str"},
        "hosting_environment": {"key": "hostingEnvironment", "type": "str"},
        "app_settings_overrides": {"key": "appSettingsOverrides", "type": "{str}"},
        "configure_load_balancing": {"key": "configureLoadBalancing", "type": "bool"},
        "traffic_manager_profile_id": {"key": "trafficManagerProfileId", "type": "str"},
        "traffic_manager_profile_name": {"key": "trafficManagerProfileName", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_web_app_id: str,
        correlation_id: Optional[str] = None,
        overwrite: Optional[bool] = None,
        clone_custom_host_names: Optional[bool] = None,
        clone_source_control: Optional[bool] = None,
        source_web_app_location: Optional[str] = None,
        hosting_environment: Optional[str] = None,
        app_settings_overrides: Optional[dict[str, str]] = None,
        configure_load_balancing: Optional[bool] = None,
        traffic_manager_profile_id: Optional[str] = None,
        traffic_manager_profile_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
         operations
         together to use the same snapshot.
        :paramtype correlation_id: str
        :keyword overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
         :code:`<code>false</code>`.
        :paramtype overwrite: bool
        :keyword clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from
         source app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_custom_host_names: bool
        :keyword clone_source_control: :code:`<code>true</code>` to clone source control from source
         app; otherwise, :code:`<code>false</code>`.
        :paramtype clone_source_control: bool
        :keyword source_web_app_id: ARM resource ID of the source app. App resource ID is of the form
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
         for production slots and
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
         for other slots. Required.
        :paramtype source_web_app_id: str
        :keyword source_web_app_location: Location of source app ex: West US or North Europe.
        :paramtype source_web_app_location: str
        :keyword hosting_environment: App Service Environment.
        :paramtype hosting_environment: str
        :keyword app_settings_overrides: Application setting overrides for cloned app. If specified,
         these settings override the settings cloned
         from source app. Otherwise, application settings from source app are retained.
        :paramtype app_settings_overrides: dict[str, str]
        :keyword configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
         source and destination app.
        :paramtype configure_load_balancing: bool
        :keyword traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if
         it exists. Traffic Manager resource ID is of the form
         /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
        :paramtype traffic_manager_profile_id: str
        :keyword traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
         needed if Traffic Manager profile does not already exist.
        :paramtype traffic_manager_profile_name: str
        """
        super().__init__(**kwargs)
        self.correlation_id = correlation_id
        self.overwrite = overwrite
        self.clone_custom_host_names = clone_custom_host_names
        self.clone_source_control = clone_source_control
        self.source_web_app_id = source_web_app_id
        self.source_web_app_location = source_web_app_location
        self.hosting_environment = hosting_environment
        self.app_settings_overrides = app_settings_overrides
        self.configure_load_balancing = configure_load_balancing
        self.traffic_manager_profile_id = traffic_manager_profile_id
        self.traffic_manager_profile_name = traffic_manager_profile_name


class ConnStringInfo(_serialization.Model):
    """Database connection string information.

    :ivar name: Name of connection string.
    :vartype name: str
    :ivar connection_string: Connection string value.
    :vartype connection_string: str
    :ivar type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
     "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.ConnectionStringType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        connection_string: Optional[str] = None,
        type: Optional[Union[str, "_models.ConnectionStringType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of connection string.
        :paramtype name: str
        :keyword connection_string: Connection string value.
        :paramtype connection_string: str
        :keyword type: Type of database. Known values are: "MySql", "SQLServer", "SQLAzure", "Custom",
         "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache", and "PostgreSQL".
        :paramtype type: str or ~azure.mgmt.certificateregistration.models.ConnectionStringType
        """
        super().__init__(**kwargs)
        self.name = name
        self.connection_string = connection_string
        self.type = type


class Container(_serialization.Model):
    """Container App container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.certificateregistration.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.certificateregistration.models.ContainerResources
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "ContainerResources"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        name: Optional[str] = None,
        command: Optional[list[str]] = None,
        args: Optional[list[str]] = None,
        env: Optional[list["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.ContainerResources"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.certificateregistration.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.certificateregistration.models.ContainerResources
        """
        super().__init__(**kwargs)
        self.image = image
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources


class ContainerResources(_serialization.Model):
    """Container App container resource requirements.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "250Mb".
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[float] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "250Mb".
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class CorsSettings(_serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :ivar allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :vartype allowed_origins: list[str]
    :ivar support_credentials: Gets or sets whether CORS requests with credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :vartype support_credentials: bool
    """

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "support_credentials": {"key": "supportCredentials", "type": "bool"},
    }

    def __init__(
        self, *, allowed_origins: Optional[list[str]] = None, support_credentials: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: Gets or sets the list of origins that should be allowed to make
         cross-origin
         calls (for example: http://example.com:12345). Use "*" to allow all.
        :paramtype allowed_origins: list[str]
        :keyword support_credentials: Gets or sets whether CORS requests with credentials are allowed.
         See
         https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
         for more details.
        :paramtype support_credentials: bool
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.support_credentials = support_credentials


class CsmOperationCollection(_serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmOperationDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.CsmOperationDescription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.CsmOperationDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CsmOperationDescription(_serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar is_data_action:
    :vartype is_data_action: bool
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.certificateregistration.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties:
     ~azure.mgmt.certificateregistration.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "CsmOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "CsmOperationDescriptionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword is_data_action:
        :paramtype is_data_action: bool
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.certificateregistration.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties:
         ~azure.mgmt.certificateregistration.models.CsmOperationDescriptionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(_serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.certificateregistration.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification:
         ~azure.mgmt.certificateregistration.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(_serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class CsmUsageQuota(_serialization.Model):
    """Usage of the quota resource.

    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: int
    :ivar limit: The resource limit.
    :vartype limit: int
    :ivar name: Quota name.
    :vartype name: ~azure.mgmt.certificateregistration.models.LocalizableString
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "LocalizableString"},
    }

    def __init__(
        self,
        *,
        unit: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.LocalizableString"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Units of measurement for the quota resource.
        :paramtype unit: str
        :keyword next_reset_time: Next reset time for the resource counter.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: The current value of the resource counter.
        :paramtype current_value: int
        :keyword limit: The resource limit.
        :paramtype limit: int
        :keyword name: Quota name.
        :paramtype name: ~azure.mgmt.certificateregistration.models.LocalizableString
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class CsmUsageQuotaCollection(_serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmUsageQuota]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.CsmUsageQuota"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.CsmUsageQuota]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CustomDnsSuffixConfiguration(ProxyOnlyResource):
    """Full view of the custom domain suffix configuration for ASEv3.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Known values are: "Succeeded", "Failed", "Degraded", and
     "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.certificateregistration.models.CustomDnsSuffixProvisioningState
    :ivar provisioning_details:
    :vartype provisioning_details: str
    :ivar dns_suffix: The default custom domain suffix to use for all sites deployed on the ASE.
    :vartype dns_suffix: str
    :ivar certificate_url: The URL referencing the Azure Key Vault certificate secret that should
     be used as the default SSL/TLS certificate for sites with the custom domain suffix.
    :vartype certificate_url: str
    :ivar key_vault_reference_identity: The user-assigned identity to use for resolving the key
     vault certificate reference. If not specified, the system-assigned ASE identity will be used if
     available.
    :vartype key_vault_reference_identity: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "provisioning_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "provisioning_details": {"key": "properties.provisioningDetails", "type": "str"},
        "dns_suffix": {"key": "properties.dnsSuffix", "type": "str"},
        "certificate_url": {"key": "properties.certificateUrl", "type": "str"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        dns_suffix: Optional[str] = None,
        certificate_url: Optional[str] = None,
        key_vault_reference_identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword dns_suffix: The default custom domain suffix to use for all sites deployed on the ASE.
        :paramtype dns_suffix: str
        :keyword certificate_url: The URL referencing the Azure Key Vault certificate secret that
         should be used as the default SSL/TLS certificate for sites with the custom domain suffix.
        :paramtype certificate_url: str
        :keyword key_vault_reference_identity: The user-assigned identity to use for resolving the key
         vault certificate reference. If not specified, the system-assigned ASE identity will be used if
         available.
        :paramtype key_vault_reference_identity: str
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state: Optional[Union[str, "_models.CustomDnsSuffixProvisioningState"]] = None
        self.provisioning_details: Optional[str] = None
        self.dns_suffix = dns_suffix
        self.certificate_url = certificate_url
        self.key_vault_reference_identity = key_vault_reference_identity


class CustomScaleRule(_serialization.Model):
    """Container App container Custom scaling rule.

    :ivar type: Type of the custom scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe custom scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        metadata: Optional[dict[str, str]] = None,
        auth: Optional[list["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the custom scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe custom scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.type = type
        self.metadata = metadata
        self.auth = auth


class Dapr(_serialization.Model):
    """Container App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_port: Port on which the Dapr side car.
    :vartype app_port: int
    :ivar components: Collection of Dapr components.
    :vartype components: list[~azure.mgmt.certificateregistration.models.DaprComponent]
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "app_id": {"key": "appId", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "components": {"key": "components", "type": "[DaprComponent]"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        app_id: Optional[str] = None,
        app_port: Optional[int] = None,
        components: Optional[list["_models.DaprComponent"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_port: Port on which the Dapr side car.
        :paramtype app_port: int
        :keyword components: Collection of Dapr components.
        :paramtype components: list[~azure.mgmt.certificateregistration.models.DaprComponent]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_port = app_port
        self.components = components


class DaprComponent(_serialization.Model):
    """Dapr component configuration.

    :ivar name: Component name.
    :vartype name: str
    :ivar type: Component type.
    :vartype type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.certificateregistration.models.DaprMetadata]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "metadata": {"key": "metadata", "type": "[DaprMetadata]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        version: Optional[str] = None,
        metadata: Optional[list["_models.DaprMetadata"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Component name.
        :paramtype name: str
        :keyword type: Component type.
        :paramtype type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.certificateregistration.models.DaprMetadata]
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.version = version
        self.metadata = metadata


class DaprConfig(_serialization.Model):
    """App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_port: Tells Dapr which port your application is listening on.
    :vartype app_port: int
    :ivar http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
     sending multi-KB headers. Default is 65KB.
    :vartype http_read_buffer_size: int
    :ivar http_max_request_size: Increasing max size of request body http servers parameter in MB
     to handle uploading of big files. Default is 4 MB.
    :vartype http_max_request_size: int
    :ivar log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn,
     error. Default is info. Known values are: "info", "debug", "warn", and "error".
    :vartype log_level: str or ~azure.mgmt.certificateregistration.models.DaprLogLevel
    :ivar enable_api_logging: Enables API logging for the Dapr sidecar.
    :vartype enable_api_logging: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "app_id": {"key": "appId", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "http_read_buffer_size": {"key": "httpReadBufferSize", "type": "int"},
        "http_max_request_size": {"key": "httpMaxRequestSize", "type": "int"},
        "log_level": {"key": "logLevel", "type": "str"},
        "enable_api_logging": {"key": "enableApiLogging", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: bool = False,
        app_id: Optional[str] = None,
        app_port: Optional[int] = None,
        http_read_buffer_size: Optional[int] = None,
        http_max_request_size: Optional[int] = None,
        log_level: Optional[Union[str, "_models.DaprLogLevel"]] = None,
        enable_api_logging: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_port: Tells Dapr which port your application is listening on.
        :paramtype app_port: int
        :keyword http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
         sending multi-KB headers. Default is 65KB.
        :paramtype http_read_buffer_size: int
        :keyword http_max_request_size: Increasing max size of request body http servers parameter in
         MB to handle uploading of big files. Default is 4 MB.
        :paramtype http_max_request_size: int
        :keyword log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info,
         warn, error. Default is info. Known values are: "info", "debug", "warn", and "error".
        :paramtype log_level: str or ~azure.mgmt.certificateregistration.models.DaprLogLevel
        :keyword enable_api_logging: Enables API logging for the Dapr sidecar.
        :paramtype enable_api_logging: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_port = app_port
        self.http_read_buffer_size = http_read_buffer_size
        self.http_max_request_size = http_max_request_size
        self.log_level = log_level
        self.enable_api_logging = enable_api_logging


class DaprMetadata(_serialization.Model):
    """Container App Dapr component metadata.

    :ivar name: Metadata property name.
    :vartype name: str
    :ivar value: Metadata property value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the metadata property
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metadata property name.
        :paramtype name: str
        :keyword value: Metadata property value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the metadata property
         value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class DataProviderMetadata(_serialization.Model):
    """Additional configuration for a data providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider_name:
    :vartype provider_name: str
    :ivar property_bag: Settings for the data provider.
    :vartype property_bag:
     list[~azure.mgmt.certificateregistration.models.KeyValuePairStringObject]
    """

    _validation = {
        "property_bag": {"readonly": True},
    }

    _attribute_map = {
        "provider_name": {"key": "providerName", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "[KeyValuePairStringObject]"},
    }

    def __init__(self, *, provider_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword provider_name:
        :paramtype provider_name: str
        """
        super().__init__(**kwargs)
        self.provider_name = provider_name
        self.property_bag: Optional[list["_models.KeyValuePairStringObject"]] = None


class DataTableResponseColumn(_serialization.Model):
    """Column definition.

    :ivar column_name: Name of the column.
    :vartype column_name: str
    :ivar data_type: Data type which looks like 'String' or 'Int32'.
    :vartype data_type: str
    :ivar column_type: Column Type.
    :vartype column_type: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "column_type": {"key": "columnType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Name of the column.
        :paramtype column_name: str
        :keyword data_type: Data type which looks like 'String' or 'Int32'.
        :paramtype data_type: str
        :keyword column_type: Column Type.
        :paramtype column_type: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DataTableResponseObject(_serialization.Model):
    """Data Table which defines columns and raw row values.

    :ivar table_name: Name of the table.
    :vartype table_name: str
    :ivar columns: List of columns with data types.
    :vartype columns: list[~azure.mgmt.certificateregistration.models.DataTableResponseColumn]
    :ivar rows: Raw row values.
    :vartype rows: list[list[str]]
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "columns": {"key": "columns", "type": "[DataTableResponseColumn]"},
        "rows": {"key": "rows", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[list["_models.DataTableResponseColumn"]] = None,
        rows: Optional[list[list[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Name of the table.
        :paramtype table_name: str
        :keyword columns: List of columns with data types.
        :paramtype columns: list[~azure.mgmt.certificateregistration.models.DataTableResponseColumn]
        :keyword rows: Raw row values.
        :paramtype rows: list[list[str]]
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DefaultErrorResponse(_serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.certificateregistration.models.DefaultErrorResponseError
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DefaultErrorResponseError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error: Optional["_models.DefaultErrorResponseError"] = None


class DefaultErrorResponseError(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details:
    :vartype details:
     list[~azure.mgmt.certificateregistration.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[DefaultErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self, *, details: Optional[list["_models.DefaultErrorResponseErrorDetailsItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword details:
        :paramtype details:
         list[~azure.mgmt.certificateregistration.models.DefaultErrorResponseErrorDetailsItem]
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details = details
        self.innererror: Optional[str] = None


class DefaultErrorResponseErrorDetailsItem(_serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None


class DeletedSite(ProxyOnlyResource):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "deleted_site_id": {"readonly": True},
        "deleted_timestamp": {"readonly": True},
        "subscription": {"readonly": True},
        "resource_group": {"readonly": True},
        "deleted_site_name": {"readonly": True},
        "slot": {"readonly": True},
        "kind_properties_kind": {"readonly": True},
        "geo_region_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deleted_site_id": {"key": "properties.deletedSiteId", "type": "int"},
        "deleted_timestamp": {"key": "properties.deletedTimestamp", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "deleted_site_name": {"key": "properties.deletedSiteName", "type": "str"},
        "slot": {"key": "properties.slot", "type": "str"},
        "kind_properties_kind": {"key": "properties.kind", "type": "str"},
        "geo_region_name": {"key": "properties.geoRegionName", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.deleted_site_id: Optional[int] = None
        self.deleted_timestamp: Optional[str] = None
        self.subscription: Optional[str] = None
        self.resource_group: Optional[str] = None
        self.deleted_site_name: Optional[str] = None
        self.slot: Optional[str] = None
        self.kind_properties_kind: Optional[str] = None
        self.geo_region_name: Optional[str] = None


class DetectorInfo(_serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of detector.
    :vartype id: str
    :ivar name: Name of detector.
    :vartype name: str
    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar author: Author of the detector.
    :vartype author: str
    :ivar category: Problem category. This serves for organizing group for detectors.
    :vartype category: str
    :ivar support_topic_list: List of Support Topics for which this detector is enabled.
    :vartype support_topic_list: list[~azure.mgmt.certificateregistration.models.SupportTopic]
    :ivar analysis_type: Analysis Types for which this detector should apply to.
    :vartype analysis_type: list[str]
    :ivar type: Whether this detector is an Analysis Detector or not. Known values are: "Detector",
     "Analysis", and "CategoryOverview".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.DetectorType
    :ivar score: Defines score of a detector to power ML based matching.
    :vartype score: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "description": {"readonly": True},
        "author": {"readonly": True},
        "category": {"readonly": True},
        "support_topic_list": {"readonly": True},
        "analysis_type": {"readonly": True},
        "type": {"readonly": True},
        "score": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "author": {"key": "author", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "support_topic_list": {"key": "supportTopicList", "type": "[SupportTopic]"},
        "analysis_type": {"key": "analysisType", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.author: Optional[str] = None
        self.category: Optional[str] = None
        self.support_topic_list: Optional[list["_models.SupportTopic"]] = None
        self.analysis_type: Optional[list[str]] = None
        self.type: Optional[Union[str, "_models.DetectorType"]] = None
        self.score: Optional[float] = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metadata: metadata for the detector.
    :vartype metadata: ~azure.mgmt.certificateregistration.models.DetectorInfo
    :ivar dataset: Data Set.
    :vartype dataset: list[~azure.mgmt.certificateregistration.models.DiagnosticData]
    :ivar status: Indicates status of the most severe insight.
    :vartype status: ~azure.mgmt.certificateregistration.models.Status
    :ivar data_providers_metadata: Additional configuration for different data providers to be used
     by the UI.
    :vartype data_providers_metadata:
     list[~azure.mgmt.certificateregistration.models.DataProviderMetadata]
    :ivar suggested_utterances: Suggested utterances where the detector can be applicable.
    :vartype suggested_utterances:
     ~azure.mgmt.certificateregistration.models.QueryUtterancesResults
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "DetectorInfo"},
        "dataset": {"key": "properties.dataset", "type": "[DiagnosticData]"},
        "status": {"key": "properties.status", "type": "Status"},
        "data_providers_metadata": {"key": "properties.dataProvidersMetadata", "type": "[DataProviderMetadata]"},
        "suggested_utterances": {"key": "properties.suggestedUtterances", "type": "QueryUtterancesResults"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        metadata: Optional["_models.DetectorInfo"] = None,
        dataset: Optional[list["_models.DiagnosticData"]] = None,
        status: Optional["_models.Status"] = None,
        data_providers_metadata: Optional[list["_models.DataProviderMetadata"]] = None,
        suggested_utterances: Optional["_models.QueryUtterancesResults"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword metadata: metadata for the detector.
        :paramtype metadata: ~azure.mgmt.certificateregistration.models.DetectorInfo
        :keyword dataset: Data Set.
        :paramtype dataset: list[~azure.mgmt.certificateregistration.models.DiagnosticData]
        :keyword status: Indicates status of the most severe insight.
        :paramtype status: ~azure.mgmt.certificateregistration.models.Status
        :keyword data_providers_metadata: Additional configuration for different data providers to be
         used by the UI.
        :paramtype data_providers_metadata:
         list[~azure.mgmt.certificateregistration.models.DataProviderMetadata]
        :keyword suggested_utterances: Suggested utterances where the detector can be applicable.
        :paramtype suggested_utterances:
         ~azure.mgmt.certificateregistration.models.QueryUtterancesResults
        """
        super().__init__(kind=kind, **kwargs)
        self.metadata = metadata
        self.dataset = dataset
        self.status = status
        self.data_providers_metadata = data_providers_metadata
        self.suggested_utterances = suggested_utterances


class DetectorResponseCollection(_serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DetectorResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.DetectorResponse"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.DetectorResponse]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticData(_serialization.Model):
    """Set of data with rendering instructions.

    :ivar table: Data in table form.
    :vartype table: ~azure.mgmt.certificateregistration.models.DataTableResponseObject
    :ivar rendering_properties: Properties that describe how the table should be rendered.
    :vartype rendering_properties: ~azure.mgmt.certificateregistration.models.Rendering
    """

    _attribute_map = {
        "table": {"key": "table", "type": "DataTableResponseObject"},
        "rendering_properties": {"key": "renderingProperties", "type": "Rendering"},
    }

    def __init__(
        self,
        *,
        table: Optional["_models.DataTableResponseObject"] = None,
        rendering_properties: Optional["_models.Rendering"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table: Data in table form.
        :paramtype table: ~azure.mgmt.certificateregistration.models.DataTableResponseObject
        :keyword rendering_properties: Properties that describe how the table should be rendered.
        :paramtype rendering_properties: ~azure.mgmt.certificateregistration.models.Rendering
        """
        super().__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class Dimension(_serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
    where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class EnvironmentVar(_serialization.Model):
    """Container App container environment variable.

    :ivar name: Environment variable name.
    :vartype name: str
    :ivar value: Non-secret environment variable value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the environment variable
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Environment variable name.
        :paramtype name: str
        :keyword value: Non-secret environment variable value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the environment
         variable value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
    :ivar details: Error Details.
    :vartype details: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
    :ivar target: The error target.
    :vartype target: str
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "details": {"key": "details", "type": "[ErrorEntity]"},
        "target": {"key": "target", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[list[str]] = None,
        inner_errors: Optional[list["_models.ErrorEntity"]] = None,
        details: Optional[list["_models.ErrorEntity"]] = None,
        target: Optional[str] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
        :keyword details: Error Details.
        :paramtype details: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
        :keyword target: The error target.
        :paramtype target: str
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.details = details
        self.target = target
        self.code = code
        self.message = message


class Experiments(_serialization.Model):
    """Routing rules in production experiments.

    :ivar ramp_up_rules: List of ramp-up rules.
    :vartype ramp_up_rules: list[~azure.mgmt.certificateregistration.models.RampUpRule]
    """

    _attribute_map = {
        "ramp_up_rules": {"key": "rampUpRules", "type": "[RampUpRule]"},
    }

    def __init__(self, *, ramp_up_rules: Optional[list["_models.RampUpRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword ramp_up_rules: List of ramp-up rules.
        :paramtype ramp_up_rules: list[~azure.mgmt.certificateregistration.models.RampUpRule]
        """
        super().__init__(**kwargs)
        self.ramp_up_rules = ramp_up_rules


class ExtendedLocation(_serialization.Model):
    """Extended Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of extended location.
    :vartype name: str
    :ivar type: Type of extended location.
    :vartype type: str
    """

    _validation = {
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of extended location.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type: Optional[str] = None


class FunctionAppConfig(_serialization.Model):
    """Function app configuration.

    :ivar deployment: Function app deployment configuration.
    :vartype deployment: ~azure.mgmt.certificateregistration.models.FunctionsDeployment
    :ivar runtime: Function app runtime settings.
    :vartype runtime: ~azure.mgmt.certificateregistration.models.FunctionsRuntime
    :ivar scale_and_concurrency: Function app scale and concurrency settings.
    :vartype scale_and_concurrency:
     ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrency
    """

    _attribute_map = {
        "deployment": {"key": "deployment", "type": "FunctionsDeployment"},
        "runtime": {"key": "runtime", "type": "FunctionsRuntime"},
        "scale_and_concurrency": {"key": "scaleAndConcurrency", "type": "FunctionsScaleAndConcurrency"},
    }

    def __init__(
        self,
        *,
        deployment: Optional["_models.FunctionsDeployment"] = None,
        runtime: Optional["_models.FunctionsRuntime"] = None,
        scale_and_concurrency: Optional["_models.FunctionsScaleAndConcurrency"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword deployment: Function app deployment configuration.
        :paramtype deployment: ~azure.mgmt.certificateregistration.models.FunctionsDeployment
        :keyword runtime: Function app runtime settings.
        :paramtype runtime: ~azure.mgmt.certificateregistration.models.FunctionsRuntime
        :keyword scale_and_concurrency: Function app scale and concurrency settings.
        :paramtype scale_and_concurrency:
         ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrency
        """
        super().__init__(**kwargs)
        self.deployment = deployment
        self.runtime = runtime
        self.scale_and_concurrency = scale_and_concurrency


class FunctionsAlwaysReadyConfig(_serialization.Model):
    """Sets the number of 'Always Ready' instances for a function group or a specific function.

    :ivar name: Either a function group or a function name is required. For additional information
     see https://aka.ms/flexconsumption/alwaysready.
    :vartype name: str
    :ivar instance_count: Sets the number of 'Always Ready' instances for a given function group or
     a specific function. For additional information see https://aka.ms/flexconsumption/alwaysready.
    :vartype instance_count: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "instance_count": {"key": "instanceCount", "type": "int"},
    }

    def __init__(self, *, name: Optional[str] = None, instance_count: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword name: Either a function group or a function name is required. For additional
         information see https://aka.ms/flexconsumption/alwaysready.
        :paramtype name: str
        :keyword instance_count: Sets the number of 'Always Ready' instances for a given function group
         or a specific function. For additional information see
         https://aka.ms/flexconsumption/alwaysready.
        :paramtype instance_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.instance_count = instance_count


class FunctionsDeployment(_serialization.Model):
    """Configuration section for the function app deployment.

    :ivar storage: Storage for deployed package used by the function app.
    :vartype storage: ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorage
    """

    _attribute_map = {
        "storage": {"key": "storage", "type": "FunctionsDeploymentStorage"},
    }

    def __init__(self, *, storage: Optional["_models.FunctionsDeploymentStorage"] = None, **kwargs: Any) -> None:
        """
        :keyword storage: Storage for deployed package used by the function app.
        :paramtype storage: ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorage
        """
        super().__init__(**kwargs)
        self.storage = storage


class FunctionsDeploymentStorage(_serialization.Model):
    """Storage for deployed package used by the function app.

    :ivar type: Property to select Azure Storage type. Available options: blobContainer.
     "blobContainer"
    :vartype type: str or ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorageType
    :ivar value: Property to set the URL for the selected Azure Storage type. Example: For
     blobContainer, the value could be https://\\
     :code:`<storageAccountName>`.blob.core.windows.net/\\ :code:`<containerName>`.
    :vartype value: str
    :ivar authentication: Authentication method to access the storage account for deployment.
    :vartype authentication:
     ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorageAuthentication
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "authentication": {"key": "authentication", "type": "FunctionsDeploymentStorageAuthentication"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.FunctionsDeploymentStorageType"]] = None,
        value: Optional[str] = None,
        authentication: Optional["_models.FunctionsDeploymentStorageAuthentication"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Property to select Azure Storage type. Available options: blobContainer.
         "blobContainer"
        :paramtype type: str or
         ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorageType
        :keyword value: Property to set the URL for the selected Azure Storage type. Example: For
         blobContainer, the value could be https://\\
         :code:`<storageAccountName>`.blob.core.windows.net/\\ :code:`<containerName>`.
        :paramtype value: str
        :keyword authentication: Authentication method to access the storage account for deployment.
        :paramtype authentication:
         ~azure.mgmt.certificateregistration.models.FunctionsDeploymentStorageAuthentication
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value
        self.authentication = authentication


class FunctionsDeploymentStorageAuthentication(_serialization.Model):
    """Authentication method to access the storage account for deployment.

    :ivar type: Property to select authentication type to access the selected storage account.
     Available options: SystemAssignedIdentity, UserAssignedIdentity,
     StorageAccountConnectionString. Known values are: "SystemAssignedIdentity",
     "UserAssignedIdentity", and "StorageAccountConnectionString".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.AuthenticationType
    :ivar user_assigned_identity_resource_id: Use this property for UserAssignedIdentity. Set the
     resource ID of the identity. Do not set a value for this property when using other
     authentication type.
    :vartype user_assigned_identity_resource_id: str
    :ivar storage_account_connection_string_name: Use this property for
     StorageAccountConnectionString. Set the name of the app setting that has the storage account
     connection string. Do not set a value for this property when using other authentication type.
    :vartype storage_account_connection_string_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identity_resource_id": {"key": "userAssignedIdentityResourceId", "type": "str"},
        "storage_account_connection_string_name": {"key": "storageAccountConnectionStringName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        user_assigned_identity_resource_id: Optional[str] = None,
        storage_account_connection_string_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Property to select authentication type to access the selected storage account.
         Available options: SystemAssignedIdentity, UserAssignedIdentity,
         StorageAccountConnectionString. Known values are: "SystemAssignedIdentity",
         "UserAssignedIdentity", and "StorageAccountConnectionString".
        :paramtype type: str or ~azure.mgmt.certificateregistration.models.AuthenticationType
        :keyword user_assigned_identity_resource_id: Use this property for UserAssignedIdentity. Set
         the resource ID of the identity. Do not set a value for this property when using other
         authentication type.
        :paramtype user_assigned_identity_resource_id: str
        :keyword storage_account_connection_string_name: Use this property for
         StorageAccountConnectionString. Set the name of the app setting that has the storage account
         connection string. Do not set a value for this property when using other authentication type.
        :paramtype storage_account_connection_string_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identity_resource_id = user_assigned_identity_resource_id
        self.storage_account_connection_string_name = storage_account_connection_string_name


class FunctionsRuntime(_serialization.Model):
    """Function app runtime name and version.

    :ivar name: Function app runtime name. Available options: dotnet-isolated, node, java,
     powershell, python, custom. Known values are: "dotnet-isolated", "node", "java", "powershell",
     "python", and "custom".
    :vartype name: str or ~azure.mgmt.certificateregistration.models.RuntimeName
    :ivar version: Function app runtime version. Example: 8 (for dotnet-isolated).
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[Union[str, "_models.RuntimeName"]] = None, version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Function app runtime name. Available options: dotnet-isolated, node, java,
         powershell, python, custom. Known values are: "dotnet-isolated", "node", "java", "powershell",
         "python", and "custom".
        :paramtype name: str or ~azure.mgmt.certificateregistration.models.RuntimeName
        :keyword version: Function app runtime version. Example: 8 (for dotnet-isolated).
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.version = version


class FunctionsScaleAndConcurrency(_serialization.Model):
    """Scale and concurrency settings for the function app.

    :ivar always_ready: 'Always Ready' configuration for the function app.
    :vartype always_ready:
     list[~azure.mgmt.certificateregistration.models.FunctionsAlwaysReadyConfig]
    :ivar maximum_instance_count: The maximum number of instances for the function app.
    :vartype maximum_instance_count: int
    :ivar instance_memory_mb: Set the amount of memory allocated to each instance of the function
     app in MB. CPU and network bandwidth are allocated proportionally.
    :vartype instance_memory_mb: int
    :ivar triggers: Scale and concurrency settings for the function app triggers.
    :vartype triggers:
     ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrencyTriggers
    """

    _attribute_map = {
        "always_ready": {"key": "alwaysReady", "type": "[FunctionsAlwaysReadyConfig]"},
        "maximum_instance_count": {"key": "maximumInstanceCount", "type": "int"},
        "instance_memory_mb": {"key": "instanceMemoryMB", "type": "int"},
        "triggers": {"key": "triggers", "type": "FunctionsScaleAndConcurrencyTriggers"},
    }

    def __init__(
        self,
        *,
        always_ready: Optional[list["_models.FunctionsAlwaysReadyConfig"]] = None,
        maximum_instance_count: Optional[int] = None,
        instance_memory_mb: Optional[int] = None,
        triggers: Optional["_models.FunctionsScaleAndConcurrencyTriggers"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword always_ready: 'Always Ready' configuration for the function app.
        :paramtype always_ready:
         list[~azure.mgmt.certificateregistration.models.FunctionsAlwaysReadyConfig]
        :keyword maximum_instance_count: The maximum number of instances for the function app.
        :paramtype maximum_instance_count: int
        :keyword instance_memory_mb: Set the amount of memory allocated to each instance of the
         function app in MB. CPU and network bandwidth are allocated proportionally.
        :paramtype instance_memory_mb: int
        :keyword triggers: Scale and concurrency settings for the function app triggers.
        :paramtype triggers:
         ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrencyTriggers
        """
        super().__init__(**kwargs)
        self.always_ready = always_ready
        self.maximum_instance_count = maximum_instance_count
        self.instance_memory_mb = instance_memory_mb
        self.triggers = triggers


class FunctionsScaleAndConcurrencyTriggers(_serialization.Model):
    """Scale and concurrency settings for the function app triggers.

    :ivar http: Scale and concurrency settings for the HTTP trigger.
    :vartype http:
     ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrencyTriggersHttp
    """

    _attribute_map = {
        "http": {"key": "http", "type": "FunctionsScaleAndConcurrencyTriggersHttp"},
    }

    def __init__(
        self, *, http: Optional["_models.FunctionsScaleAndConcurrencyTriggersHttp"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword http: Scale and concurrency settings for the HTTP trigger.
        :paramtype http:
         ~azure.mgmt.certificateregistration.models.FunctionsScaleAndConcurrencyTriggersHttp
        """
        super().__init__(**kwargs)
        self.http = http


class FunctionsScaleAndConcurrencyTriggersHttp(_serialization.Model):
    """Scale and concurrency settings for the HTTP trigger.

    :ivar per_instance_concurrency: The maximum number of concurrent HTTP trigger invocations per
     instance.
    :vartype per_instance_concurrency: int
    """

    _attribute_map = {
        "per_instance_concurrency": {"key": "perInstanceConcurrency", "type": "int"},
    }

    def __init__(self, *, per_instance_concurrency: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword per_instance_concurrency: The maximum number of concurrent HTTP trigger invocations
         per instance.
        :paramtype per_instance_concurrency: int
        """
        super().__init__(**kwargs)
        self.per_instance_concurrency = per_instance_concurrency


class HandlerMapping(_serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain
    extension.
    For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
    extension.

    :ivar extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :vartype extension: str
    :ivar script_processor: The absolute path to the FastCGI application.
    :vartype script_processor: str
    :ivar arguments: Command-line arguments to be passed to the script processor.
    :vartype arguments: str
    """

    _attribute_map = {
        "extension": {"key": "extension", "type": "str"},
        "script_processor": {"key": "scriptProcessor", "type": "str"},
        "arguments": {"key": "arguments", "type": "str"},
    }

    def __init__(
        self,
        *,
        extension: Optional[str] = None,
        script_processor: Optional[str] = None,
        arguments: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extension: Requests with this extension will be handled using the specified FastCGI
         application.
        :paramtype extension: str
        :keyword script_processor: The absolute path to the FastCGI application.
        :paramtype script_processor: str
        :keyword arguments: Command-line arguments to be passed to the script processor.
        :paramtype arguments: str
        """
        super().__init__(**kwargs)
        self.extension = extension
        self.script_processor = script_processor
        self.arguments = arguments


class HostingEnvironmentProfile(_serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the App Service Environment.
    :vartype id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the App Service Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar site_name: App Service app name.
    :vartype site_name: str
    :ivar domain_id: Fully qualified ARM domain resource URI.
    :vartype domain_id: str
    :ivar azure_resource_name: Azure resource name.
    :vartype azure_resource_name: str
    :ivar azure_resource_type: Azure resource type. Known values are: "Website" and
     "TrafficManager".
    :vartype azure_resource_type: str or
     ~azure.mgmt.certificateregistration.models.AzureResourceType
    :ivar custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName" and
     "A".
    :vartype custom_host_name_dns_record_type: str or
     ~azure.mgmt.certificateregistration.models.CustomHostNameDnsRecordType
    :ivar host_name_type: Hostname type. Known values are: "Verified" and "Managed".
    :vartype host_name_type: str or ~azure.mgmt.certificateregistration.models.HostNameType
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.certificateregistration.models.SslState
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_ip": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "site_name": {"key": "properties.siteName", "type": "str"},
        "domain_id": {"key": "properties.domainId", "type": "str"},
        "azure_resource_name": {"key": "properties.azureResourceName", "type": "str"},
        "azure_resource_type": {"key": "properties.azureResourceType", "type": "str"},
        "custom_host_name_dns_record_type": {"key": "properties.customHostNameDnsRecordType", "type": "str"},
        "host_name_type": {"key": "properties.hostNameType", "type": "str"},
        "ssl_state": {"key": "properties.sslState", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "virtual_ip": {"key": "properties.virtualIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        site_name: Optional[str] = None,
        domain_id: Optional[str] = None,
        azure_resource_name: Optional[str] = None,
        azure_resource_type: Optional[Union[str, "_models.AzureResourceType"]] = None,
        custom_host_name_dns_record_type: Optional[Union[str, "_models.CustomHostNameDnsRecordType"]] = None,
        host_name_type: Optional[Union[str, "_models.HostNameType"]] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword site_name: App Service app name.
        :paramtype site_name: str
        :keyword domain_id: Fully qualified ARM domain resource URI.
        :paramtype domain_id: str
        :keyword azure_resource_name: Azure resource name.
        :paramtype azure_resource_name: str
        :keyword azure_resource_type: Azure resource type. Known values are: "Website" and
         "TrafficManager".
        :paramtype azure_resource_type: str or
         ~azure.mgmt.certificateregistration.models.AzureResourceType
        :keyword custom_host_name_dns_record_type: Custom DNS record type. Known values are: "CName"
         and "A".
        :paramtype custom_host_name_dns_record_type: str or
         ~azure.mgmt.certificateregistration.models.CustomHostNameDnsRecordType
        :keyword host_name_type: Hostname type. Known values are: "Verified" and "Managed".
        :paramtype host_name_type: str or ~azure.mgmt.certificateregistration.models.HostNameType
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.certificateregistration.models.SslState
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        """
        super().__init__(kind=kind, **kwargs)
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
        self.ssl_state = ssl_state
        self.thumbprint = thumbprint
        self.virtual_ip: Optional[str] = None


class HostNameBindingCollection(_serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HostNameBinding]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.HostNameBinding"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.HostNameBinding]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class HostNameSslState(_serialization.Model):
    """SSL-enabled hostname.

    :ivar name: Hostname.
    :vartype name: str
    :ivar ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
    :vartype ssl_state: str or ~azure.mgmt.certificateregistration.models.SslState
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    :ivar thumbprint: SSL certificate thumbprint.
    :vartype thumbprint: str
    :ivar to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :vartype to_update: bool
    :ivar host_type: Indicates whether the hostname is a standard or repository hostname. Known
     values are: "Standard" and "Repository".
    :vartype host_type: str or ~azure.mgmt.certificateregistration.models.HostType
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ssl_state": {"key": "sslState", "type": "str"},
        "virtual_ip": {"key": "virtualIP", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "to_update": {"key": "toUpdate", "type": "bool"},
        "host_type": {"key": "hostType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ssl_state: Optional[Union[str, "_models.SslState"]] = None,
        virtual_ip: Optional[str] = None,
        thumbprint: Optional[str] = None,
        to_update: Optional[bool] = None,
        host_type: Optional[Union[str, "_models.HostType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname.
        :paramtype name: str
        :keyword ssl_state: SSL type. Known values are: "Disabled", "SniEnabled", and "IpBasedEnabled".
        :paramtype ssl_state: str or ~azure.mgmt.certificateregistration.models.SslState
        :keyword virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
        :paramtype virtual_ip: str
        :keyword thumbprint: SSL certificate thumbprint.
        :paramtype thumbprint: str
        :keyword to_update: Set to :code:`<code>true</code>` to update existing hostname.
        :paramtype to_update: bool
        :keyword host_type: Indicates whether the hostname is a standard or repository hostname. Known
         values are: "Standard" and "Repository".
        :paramtype host_type: str or ~azure.mgmt.certificateregistration.models.HostType
        """
        super().__init__(**kwargs)
        self.name = name
        self.ssl_state = ssl_state
        self.virtual_ip = virtual_ip
        self.thumbprint = thumbprint
        self.to_update = to_update
        self.host_type = host_type


class HttpScaleRule(_serialization.Model):
    """Container App container Custom scaling rule.

    :ivar metadata: Metadata properties to describe http scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[dict[str, str]] = None,
        auth: Optional[list["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe http scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar service_bus_namespace: The name of the Service Bus namespace.
    :vartype service_bus_namespace: str
    :ivar relay_name: The name of the Service Bus relay.
    :vartype relay_name: str
    :ivar relay_arm_uri: The ARM URI to the Service Bus relay.
    :vartype relay_arm_uri: str
    :ivar hostname: The hostname of the endpoint.
    :vartype hostname: str
    :ivar port: The port of the endpoint.
    :vartype port: int
    :ivar send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the Service Bus key. This is used to authenticate to Service
     Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :vartype send_key_value: str
    :ivar service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :vartype service_bus_suffix: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "service_bus_namespace": {"key": "properties.serviceBusNamespace", "type": "str"},
        "relay_name": {"key": "properties.relayName", "type": "str"},
        "relay_arm_uri": {"key": "properties.relayArmUri", "type": "str"},
        "hostname": {"key": "properties.hostname", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "send_key_name": {"key": "properties.sendKeyName", "type": "str"},
        "send_key_value": {"key": "properties.sendKeyValue", "type": "str"},
        "service_bus_suffix": {"key": "properties.serviceBusSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        service_bus_namespace: Optional[str] = None,
        relay_name: Optional[str] = None,
        relay_arm_uri: Optional[str] = None,
        hostname: Optional[str] = None,
        port: Optional[int] = None,
        send_key_name: Optional[str] = None,
        send_key_value: Optional[str] = None,
        service_bus_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword service_bus_namespace: The name of the Service Bus namespace.
        :paramtype service_bus_namespace: str
        :keyword relay_name: The name of the Service Bus relay.
        :paramtype relay_name: str
        :keyword relay_arm_uri: The ARM URI to the Service Bus relay.
        :paramtype relay_arm_uri: str
        :keyword hostname: The hostname of the endpoint.
        :paramtype hostname: str
        :keyword port: The port of the endpoint.
        :paramtype port: int
        :keyword send_key_name: The name of the Service Bus key which has Send permissions. This is
         used to authenticate to Service Bus.
        :paramtype send_key_name: str
        :keyword send_key_value: The value of the Service Bus key. This is used to authenticate to
         Service Bus. In ARM this key will not be returned
         normally, use the POST /listKeys API instead.
        :paramtype send_key_value: str
        :keyword service_bus_suffix: The suffix for the service bus endpoint. By default this is
         .servicebus.windows.net.
        :paramtype service_bus_suffix: str
        """
        super().__init__(kind=kind, **kwargs)
        self.service_bus_namespace = service_bus_namespace
        self.relay_name = relay_name
        self.relay_arm_uri = relay_arm_uri
        self.hostname = hostname
        self.port = port
        self.send_key_name = send_key_name
        self.send_key_value = send_key_value
        self.service_bus_suffix = service_bus_suffix


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar value: String representation of the identity.
    :vartype value: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "value": {"key": "properties.id", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword value: String representation of the identity.
        :paramtype value: str
        """
        super().__init__(kind=kind, **kwargs)
        self.value = value


class IdentifierCollection(_serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Identifier]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Identifier"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.Identifier]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class IpSecurityRestriction(_serialization.Model):
    """IP security restriction on an app.

        :ivar ip_address: IP address the security restriction is valid for.
         It can be in form of pure ipv4 address (required SubnetMask property) or
         CIDR notation such as ipv4/mask (leading bit match). For CIDR,
         SubnetMask property must not be specified.
        :vartype ip_address: str
        :ivar subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
        :vartype subnet_mask: str
        :ivar vnet_subnet_resource_id: Virtual network resource id.
        :vartype vnet_subnet_resource_id: str
        :ivar vnet_traffic_tag: (internal) Vnet traffic tag.
        :vartype vnet_traffic_tag: int
        :ivar subnet_traffic_tag: (internal) Subnet traffic tag.
        :vartype subnet_traffic_tag: int
        :ivar action: Allow or Deny access for this IP range.
        :vartype action: str
        :ivar tag: Defines what this IP filter will be used for. This is to support IP filtering on
         proxies. Known values are: "Default", "XffProxy", and "ServiceTag".
        :vartype tag: str or ~azure.mgmt.certificateregistration.models.IpFilterTag
        :ivar priority: Priority of IP restriction rule.
        :vartype priority: int
        :ivar name: IP restriction rule name.
        :vartype name: str
        :ivar description: IP restriction rule description.
        :vartype description: str
        :ivar headers: IP restriction rule headers.
    X-Forwarded-Host
        (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
    The matching logic is ..


         * If the property is null or empty (default), all hosts(or lack of) are allowed.
         * A value is compared using ordinal-ignore-case (excluding port number).
         * Subdomain wildcards are permitted but don't match the root domain. For example,
           *.contoso.com matches the subdomain foo.contoso.com
    but not the root domain contoso.com or multi-level foo.bar.contoso.com
         * Unicode host names are allowed but are converted to Punycode for matching.

    X-Forwarded-For
        (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
    The matching logic is ..


         * If the property is null or empty (default), any forwarded-for chains (or lack of) are
           allowed.
         * If any address (excluding port number) in the chain (comma separated) matches the CIDR
           defined by the property.

    X-Azure-FDID and X-FD-HealthProbe.
    The matching logic is exact match.
        :vartype headers: dict[str, list[str]]
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet_mask": {"key": "subnetMask", "type": "str"},
        "vnet_subnet_resource_id": {"key": "vnetSubnetResourceId", "type": "str"},
        "vnet_traffic_tag": {"key": "vnetTrafficTag", "type": "int"},
        "subnet_traffic_tag": {"key": "subnetTrafficTag", "type": "int"},
        "action": {"key": "action", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "headers": {"key": "headers", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        subnet_mask: Optional[str] = None,
        vnet_subnet_resource_id: Optional[str] = None,
        vnet_traffic_tag: Optional[int] = None,
        subnet_traffic_tag: Optional[int] = None,
        action: Optional[str] = None,
        tag: Optional[Union[str, "_models.IpFilterTag"]] = None,
        priority: Optional[int] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        headers: Optional[dict[str, list[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
               :keyword ip_address: IP address the security restriction is valid for.
                It can be in form of pure ipv4 address (required SubnetMask property) or
                CIDR notation such as ipv4/mask (leading bit match). For CIDR,
                SubnetMask property must not be specified.
               :paramtype ip_address: str
               :keyword subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
               :paramtype subnet_mask: str
               :keyword vnet_subnet_resource_id: Virtual network resource id.
               :paramtype vnet_subnet_resource_id: str
               :keyword vnet_traffic_tag: (internal) Vnet traffic tag.
               :paramtype vnet_traffic_tag: int
               :keyword subnet_traffic_tag: (internal) Subnet traffic tag.
               :paramtype subnet_traffic_tag: int
               :keyword action: Allow or Deny access for this IP range.
               :paramtype action: str
               :keyword tag: Defines what this IP filter will be used for. This is to support IP filtering on
                proxies. Known values are: "Default", "XffProxy", and "ServiceTag".
               :paramtype tag: str or ~azure.mgmt.certificateregistration.models.IpFilterTag
               :keyword priority: Priority of IP restriction rule.
               :paramtype priority: int
               :keyword name: IP restriction rule name.
               :paramtype name: str
               :keyword description: IP restriction rule description.
               :paramtype description: str
               :keyword headers: IP restriction rule headers.
        X-Forwarded-Host
                (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
        The matching logic is ..


                 * If the property is null or empty (default), all hosts(or lack of) are allowed.
                 * A value is compared using ordinal-ignore-case (excluding port number).
                 * Subdomain wildcards are permitted but don't match the root domain. For example,
                   *.contoso.com matches the subdomain foo.contoso.com
        but not the root domain contoso.com or multi-level foo.bar.contoso.com
                 * Unicode host names are allowed but are converted to Punycode for matching.

        X-Forwarded-For
                (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
        The matching logic is ..


                 * If the property is null or empty (default), any forwarded-for chains (or lack of)
                   are allowed.
                 * If any address (excluding port number) in the chain (comma separated) matches the
                   CIDR defined by the property.

        X-Azure-FDID and X-FD-HealthProbe.
        The matching logic is exact match.
               :paramtype headers: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.subnet_mask = subnet_mask
        self.vnet_subnet_resource_id = vnet_subnet_resource_id
        self.vnet_traffic_tag = vnet_traffic_tag
        self.subnet_traffic_tag = subnet_traffic_tag
        self.action = action
        self.tag = tag
        self.priority = priority
        self.name = name
        self.description = description
        self.headers = headers


class KeyValuePairStringObject(_serialization.Model):
    """KeyValuePairStringObject.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key:
    :vartype key: str
    :ivar value: Any object.
    :vartype value: JSON
    """

    _validation = {
        "key": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.key: Optional[str] = None
        self.value: Optional[JSON] = None


class KubeEnvironmentProfile(_serialization.Model):
    """Specification for a Kubernetes Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID of the Kubernetes Environment.
    :vartype id: str
    :ivar name: Name of the Kubernetes Environment.
    :vartype name: str
    :ivar type: Resource type of the Kubernetes Environment.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID of the Kubernetes Environment.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class LocalizableString(_serialization.Model):
    """Localizable string object containing the name and a localized value.

    :ivar value: Non-localized name.
    :vartype value: str
    :ivar localized_value: Localized name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Non-localized name.
        :paramtype value: str
        :keyword localized_value: Localized name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class LogSpecification(_serialization.Model):
    """Log Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar blob_duration:
    :vartype blob_duration: str
    :ivar log_filter_pattern:
    :vartype log_filter_pattern: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
        "log_filter_pattern": {"key": "logFilterPattern", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        log_filter_pattern: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        :keyword log_filter_pattern:
        :paramtype log_filter_pattern: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration
        self.log_filter_pattern = log_filter_pattern


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Type of managed service identity. Known values are: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :ivar user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.certificateregistration.models.UserAssignedIdentity]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity. Known values are: "SystemAssigned",
         "UserAssigned", "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.certificateregistration.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The list of user assigned identities associated with the
         resource. The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.certificateregistration.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id: Optional[str] = None
        self.principal_id: Optional[str] = None
        self.user_assigned_identities = user_assigned_identities


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(_serialization.Model):
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.certificateregistration.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.certificateregistration.models.MetricAvailability]
    :ivar supported_time_grain_types:
    :vartype supported_time_grain_types: list[str]
    :ivar supported_aggregation_types:
    :vartype supported_aggregation_types: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supports_instance_level_aggregation": {"key": "supportsInstanceLevelAggregation", "type": "bool"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "category": {"key": "category", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[list["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[list["_models.MetricAvailability"]] = None,
        supported_time_grain_types: Optional[list[str]] = None,
        supported_aggregation_types: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.certificateregistration.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.certificateregistration.models.MetricAvailability]
        :keyword supported_time_grain_types:
        :paramtype supported_time_grain_types: list[str]
        :keyword supported_aggregation_types:
        :paramtype supported_aggregation_types: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class NameIdentifier(_serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class NameValuePair(_serialization.Model):
    """Name value pair.

    :ivar name: Pair name.
    :vartype name: str
    :ivar value: Pair value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Pair name.
        :paramtype name: str
        :keyword value: Pair value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class Operation(_serialization.Model):
    """An operation on a resource.

    :ivar id: Operation ID.
    :vartype id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar status: The current status of the operation. Known values are: "InProgress", "Failed",
     "Succeeded", "TimedOut", and "Created".
    :vartype status: str or ~azure.mgmt.certificateregistration.models.OperationStatus
    :ivar errors: Any errors associate with the operation.
    :vartype errors: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
    :ivar created_time: Time when operation has started.
    :vartype created_time: ~datetime.datetime
    :ivar modified_time: Time when operation has been updated.
    :vartype modified_time: ~datetime.datetime
    :ivar expiration_time: Time when operation will expire.
    :vartype expiration_time: ~datetime.datetime
    :ivar geo_master_operation_id: Applicable only for stamp operation ids.
    :vartype geo_master_operation_id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[ErrorEntity]"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "modified_time": {"key": "modifiedTime", "type": "iso-8601"},
        "expiration_time": {"key": "expirationTime", "type": "iso-8601"},
        "geo_master_operation_id": {"key": "geoMasterOperationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatus"]] = None,
        errors: Optional[list["_models.ErrorEntity"]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        expiration_time: Optional[datetime.datetime] = None,
        geo_master_operation_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Operation ID.
        :paramtype id: str
        :keyword name: Operation name.
        :paramtype name: str
        :keyword status: The current status of the operation. Known values are: "InProgress", "Failed",
         "Succeeded", "TimedOut", and "Created".
        :paramtype status: str or ~azure.mgmt.certificateregistration.models.OperationStatus
        :keyword errors: Any errors associate with the operation.
        :paramtype errors: list[~azure.mgmt.certificateregistration.models.ErrorEntity]
        :keyword created_time: Time when operation has started.
        :paramtype created_time: ~datetime.datetime
        :keyword modified_time: Time when operation has been updated.
        :paramtype modified_time: ~datetime.datetime
        :keyword expiration_time: Time when operation will expire.
        :paramtype expiration_time: ~datetime.datetime
        :keyword geo_master_operation_id: Applicable only for stamp operation ids.
        :paramtype geo_master_operation_id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.errors = errors
        self.created_time = created_time
        self.modified_time = modified_time
        self.expiration_time = expiration_time
        self.geo_master_operation_id = geo_master_operation_id


class OutboundVnetRouting(_serialization.Model):
    """Outbound traffic options over virtual network.

    :ivar all_traffic: Enables all other routing options defined in OutboundVnetRouting if this
     setting is set to true.
    :vartype all_traffic: bool
    :ivar application_traffic: This causes all outbound traffic to have Virtual Network Security
     Groups and User Defined Routes applied. Previously called VnetRouteAllEnabled.
    :vartype application_traffic: bool
    :ivar content_share_traffic: Enables accessing content over virtual network. Previously called
     VnetContentShareEnabled.
    :vartype content_share_traffic: bool
    :ivar image_pull_traffic: Enables pulling image over Virtual Network. Previously called
     VnetImagePullEnabled.
    :vartype image_pull_traffic: bool
    :ivar backup_restore_traffic: Enables Backup and Restore operations over virtual network.
     Previously called VnetBackupRestoreEnabled.
    :vartype backup_restore_traffic: bool
    """

    _attribute_map = {
        "all_traffic": {"key": "allTraffic", "type": "bool"},
        "application_traffic": {"key": "applicationTraffic", "type": "bool"},
        "content_share_traffic": {"key": "contentShareTraffic", "type": "bool"},
        "image_pull_traffic": {"key": "imagePullTraffic", "type": "bool"},
        "backup_restore_traffic": {"key": "backupRestoreTraffic", "type": "bool"},
    }

    def __init__(
        self,
        *,
        all_traffic: Optional[bool] = None,
        application_traffic: Optional[bool] = None,
        content_share_traffic: Optional[bool] = None,
        image_pull_traffic: Optional[bool] = None,
        backup_restore_traffic: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword all_traffic: Enables all other routing options defined in OutboundVnetRouting if this
         setting is set to true.
        :paramtype all_traffic: bool
        :keyword application_traffic: This causes all outbound traffic to have Virtual Network Security
         Groups and User Defined Routes applied. Previously called VnetRouteAllEnabled.
        :paramtype application_traffic: bool
        :keyword content_share_traffic: Enables accessing content over virtual network. Previously
         called VnetContentShareEnabled.
        :paramtype content_share_traffic: bool
        :keyword image_pull_traffic: Enables pulling image over Virtual Network. Previously called
         VnetImagePullEnabled.
        :paramtype image_pull_traffic: bool
        :keyword backup_restore_traffic: Enables Backup and Restore operations over virtual network.
         Previously called VnetBackupRestoreEnabled.
        :paramtype backup_restore_traffic: bool
        """
        super().__init__(**kwargs)
        self.all_traffic = all_traffic
        self.application_traffic = application_traffic
        self.content_share_traffic = content_share_traffic
        self.image_pull_traffic = image_pull_traffic
        self.backup_restore_traffic = backup_restore_traffic


class PrivateEndpointConnectionCollection(_serialization.Model):
    """PrivateEndpointConnectionCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value:
     list[~azure.mgmt.certificateregistration.models.RemotePrivateEndpointConnectionARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RemotePrivateEndpointConnectionARMResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.RemotePrivateEndpointConnectionARMResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value:
         list[~azure.mgmt.certificateregistration.models.RemotePrivateEndpointConnectionARMResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PrivateLinkConnectionApprovalRequestResource(ProxyOnlyResource):  # pylint: disable=name-too-long
    """Private Endpoint Connection Approval ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.certificateregistration.models.PrivateLinkConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.certificateregistration.models.PrivateLinkConnectionState
        """
        super().__init__(kind=kind, **kwargs)
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkConnectionState(_serialization.Model):
    """The state of a private link connection.

    :ivar status: Status of a private link connection.
    :vartype status: str
    :ivar description: Description of a private link connection.
    :vartype description: str
    :ivar actions_required: ActionsRequired for a private link connection.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of a private link connection.
        :paramtype status: str
        :keyword description: Description of a private link connection.
        :paramtype description: str
        :keyword actions_required: ActionsRequired for a private link connection.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    All required parameters must be populated in order to send to server.

    :ivar id: Required.
    :vartype id: str
    :ivar name: Name of a private link resource. Required.
    :vartype name: str
    :ivar type: Required.
    :vartype type: str
    :ivar properties: Properties of a private link resource. Required.
    :vartype properties: ~azure.mgmt.certificateregistration.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"required": True},
        "name": {"required": True},
        "type": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        type: str,
        properties: "_models.PrivateLinkResourceProperties",
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Required.
        :paramtype id: str
        :keyword name: Name of a private link resource. Required.
        :paramtype name: str
        :keyword type: Required.
        :paramtype type: str
        :keyword properties: Properties of a private link resource. Required.
        :paramtype properties: ~azure.mgmt.certificateregistration.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.properties = properties


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: GroupId of a private link resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of a private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: RequiredZoneNames of a private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[list[str]] = None
        self.required_zone_names: Optional[list[str]] = None


class PrivateLinkResourcesWrapper(_serialization.Model):
    """Wrapper for a collection of private link resources.

    All required parameters must be populated in order to send to server.

    :ivar value: Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.PrivateLinkResource]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: list["_models.PrivateLinkResource"], **kwargs: Any) -> None:
        """
        :keyword value: Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :vartype is_push_enabled: bool
    :ivar tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :vartype tag_whitelist_json: str
    :ivar tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :vartype tags_requiring_auth: str
    :ivar dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that will
     be evaluated from user claims in the push registration endpoint.
    :vartype dynamic_tags_json: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_push_enabled": {"key": "properties.isPushEnabled", "type": "bool"},
        "tag_whitelist_json": {"key": "properties.tagWhitelistJson", "type": "str"},
        "tags_requiring_auth": {"key": "properties.tagsRequiringAuth", "type": "str"},
        "dynamic_tags_json": {"key": "properties.dynamicTagsJson", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        is_push_enabled: Optional[bool] = None,
        tag_whitelist_json: Optional[str] = None,
        tags_requiring_auth: Optional[str] = None,
        dynamic_tags_json: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
        :paramtype is_push_enabled: bool
        :keyword tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
         whitelisted for use by the push registration endpoint.
        :paramtype tag_whitelist_json: str
        :keyword tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
         user authentication to be used in the push registration endpoint.
         Tags can consist of alphanumeric characters and the following:
         '_', '@', '#', '.', ':', '-'.
         Validation should be performed at the PushRequestHandler.
        :paramtype tags_requiring_auth: str
        :keyword dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
         will be evaluated from user claims in the push registration endpoint.
        :paramtype dynamic_tags_json: str
        """
        super().__init__(kind=kind, **kwargs)
        self.is_push_enabled = is_push_enabled
        self.tag_whitelist_json = tag_whitelist_json
        self.tags_requiring_auth = tags_requiring_auth
        self.dynamic_tags_json = dynamic_tags_json


class QueryUtterancesResult(_serialization.Model):
    """Result for utterances query.

    :ivar sample_utterance: A sample utterance.
    :vartype sample_utterance: ~azure.mgmt.certificateregistration.models.SampleUtterance
    :ivar score: Score of a sample utterance.
    :vartype score: float
    """

    _attribute_map = {
        "sample_utterance": {"key": "sampleUtterance", "type": "SampleUtterance"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self,
        *,
        sample_utterance: Optional["_models.SampleUtterance"] = None,
        score: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sample_utterance: A sample utterance.
        :paramtype sample_utterance: ~azure.mgmt.certificateregistration.models.SampleUtterance
        :keyword score: Score of a sample utterance.
        :paramtype score: float
        """
        super().__init__(**kwargs)
        self.sample_utterance = sample_utterance
        self.score = score


class QueryUtterancesResults(_serialization.Model):
    """Suggested utterances where the detector can be applicable.

    :ivar query: Search Query.
    :vartype query: str
    :ivar results: Array of utterance results for search query.
    :vartype results: list[~azure.mgmt.certificateregistration.models.QueryUtterancesResult]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "results": {"key": "results", "type": "[QueryUtterancesResult]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        results: Optional[list["_models.QueryUtterancesResult"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword query: Search Query.
        :paramtype query: str
        :keyword results: Array of utterance results for search query.
        :paramtype results: list[~azure.mgmt.certificateregistration.models.QueryUtterancesResult]
        """
        super().__init__(**kwargs)
        self.query = query
        self.results = results


class QueueScaleRule(_serialization.Model):
    """Container App container Azure Queue based scaling rule.

    :ivar queue_name: Queue name.
    :vartype queue_name: str
    :ivar queue_length: Queue length.
    :vartype queue_length: int
    :ivar auth: Authentication secrets for the queue scale rule.
    :vartype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
    """

    _attribute_map = {
        "queue_name": {"key": "queueName", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
    }

    def __init__(
        self,
        *,
        queue_name: Optional[str] = None,
        queue_length: Optional[int] = None,
        auth: Optional[list["_models.ScaleRuleAuth"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword queue_name: Queue name.
        :paramtype queue_name: str
        :keyword queue_length: Queue length.
        :paramtype queue_length: int
        :keyword auth: Authentication secrets for the queue scale rule.
        :paramtype auth: list[~azure.mgmt.certificateregistration.models.ScaleRuleAuth]
        """
        super().__init__(**kwargs)
        self.queue_name = queue_name
        self.queue_length = queue_length
        self.auth = auth


class RampUpRule(_serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
    to gradually change routing % based on performance.

    :ivar action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :vartype action_host_name: str
    :ivar reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :vartype reroute_percentage: float
    :ivar change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches \\n\\
     :code:`<code>MinReroutePercentage</code>` or
     :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
     in :code:`<code>ChangeIntervalInMinutes</code>`.\\nCustom decision algorithm
     can be provided in TiPCallback site extension which URL can be specified in
     :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :vartype change_step: float
    :ivar change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :vartype change_interval_in_minutes: int
    :ivar min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will stay.
    :vartype min_reroute_percentage: float
    :ivar max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will stay.
    :vartype max_reroute_percentage: float
    :ivar change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified.
    :vartype change_decision_callback_url: str
    :ivar name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :vartype name: str
    """

    _attribute_map = {
        "action_host_name": {"key": "actionHostName", "type": "str"},
        "reroute_percentage": {"key": "reroutePercentage", "type": "float"},
        "change_step": {"key": "changeStep", "type": "float"},
        "change_interval_in_minutes": {"key": "changeIntervalInMinutes", "type": "int"},
        "min_reroute_percentage": {"key": "minReroutePercentage", "type": "float"},
        "max_reroute_percentage": {"key": "maxReroutePercentage", "type": "float"},
        "change_decision_callback_url": {"key": "changeDecisionCallbackUrl", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_host_name: Optional[str] = None,
        reroute_percentage: Optional[float] = None,
        change_step: Optional[float] = None,
        change_interval_in_minutes: Optional[int] = None,
        min_reroute_percentage: Optional[float] = None,
        max_reroute_percentage: Optional[float] = None,
        change_decision_callback_url: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_host_name: Hostname of a slot to which the traffic will be redirected if
         decided to. E.g. myapp-stage.azurewebsites.net.
        :paramtype action_host_name: str
        :keyword reroute_percentage: Percentage of the traffic which will be redirected to
         :code:`<code>ActionHostName</code>`.
        :paramtype reroute_percentage: float
        :keyword change_step: In auto ramp up scenario this is the step to add/remove from
         :code:`<code>ReroutePercentage</code>` until it reaches \\n\\
         :code:`<code>MinReroutePercentage</code>` or
         :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
         in :code:`<code>ChangeIntervalInMinutes</code>`.\\nCustom decision algorithm
         can be provided in TiPCallback site extension which URL can be specified in
         :code:`<code>ChangeDecisionCallbackUrl</code>`.
        :paramtype change_step: float
        :keyword change_interval_in_minutes: Specifies interval in minutes to reevaluate
         ReroutePercentage.
        :paramtype change_interval_in_minutes: int
        :keyword min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
         stay.
        :paramtype min_reroute_percentage: float
        :keyword max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
         stay.
        :paramtype max_reroute_percentage: float
        :keyword change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
         site extension which URL can be specified.
        :paramtype change_decision_callback_url: str
        :keyword name: Name of the routing rule. The recommended name would be to point to the slot
         which will receive the traffic in the experiment.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action_host_name = action_host_name
        self.reroute_percentage = reroute_percentage
        self.change_step = change_step
        self.change_interval_in_minutes = change_interval_in_minutes
        self.min_reroute_percentage = min_reroute_percentage
        self.max_reroute_percentage = max_reroute_percentage
        self.change_decision_callback_url = change_decision_callback_url
        self.name = name


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :vartype delay_existing_revoke_in_hours: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "delay_existing_revoke_in_hours": {"key": "properties.delayExistingRevokeInHours", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after
         the new certificate is issued.
        :paramtype delay_existing_revoke_in_hours: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RemotePrivateEndpointConnectionARMResource(ProxyOnlyResource):  # pylint: disable=name-too-long
    """Remote Private Endpoint Connection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :vartype private_endpoint: ~azure.mgmt.certificateregistration.models.ArmIdWrapper
    :ivar private_link_service_connection_state: The state of a private link connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.certificateregistration.models.PrivateLinkConnectionState
    :ivar ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "ArmIdWrapper"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkConnectionState",
        },
        "ip_addresses": {"key": "properties.ipAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        private_endpoint: Optional["_models.ArmIdWrapper"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkConnectionState"] = None,
        ip_addresses: Optional[list[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword private_endpoint: PrivateEndpoint of a remote private endpoint connection.
        :paramtype private_endpoint: ~azure.mgmt.certificateregistration.models.ArmIdWrapper
        :keyword private_link_service_connection_state: The state of a private link connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.certificateregistration.models.PrivateLinkConnectionState
        :keyword ip_addresses: Private IPAddresses mapped to the remote private endpoint.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(kind=kind, **kwargs)
        self.provisioning_state: Optional[str] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.ip_addresses = ip_addresses


class Rendering(_serialization.Model):
    """Instructions for rendering the data.

    :ivar type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries",
     "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
     "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
     "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
     "SummaryCard", "SearchComponent", and "AppInsightEnablement".
    :vartype type: str or ~azure.mgmt.certificateregistration.models.RenderingType
    :ivar title: Title of data.
    :vartype title: str
    :ivar description: Description of the data that will help it be interpreted.
    :vartype description: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RenderingType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Rendering Type. Known values are: "NoGraph", "Table", "TimeSeries",
         "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
         "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
         "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
         "SummaryCard", "SearchComponent", and "AppInsightEnablement".
        :paramtype type: str or ~azure.mgmt.certificateregistration.models.RenderingType
        :keyword title: Title of data.
        :paramtype title: str
        :keyword description: Description of the data that will help it be interpreted.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RequestsBasedTrigger(_serialization.Model):
    """Trigger based on total requests.

    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(self, *, count: Optional[int] = None, time_interval: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.count = count
        self.time_interval = time_interval


class ResourceConfig(_serialization.Model):
    """Function app resource requirements.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "1Gi".
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[float] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "1Gi".
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class SampleUtterance(_serialization.Model):
    """Sample utterance.

    :ivar text: Text attribute of sample utterance.
    :vartype text: str
    :ivar links: Links attribute of sample utterance.
    :vartype links: list[str]
    :ivar qid: Question id of sample utterance (for stackoverflow questions titles).
    :vartype qid: str
    """

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "links": {"key": "links", "type": "[str]"},
        "qid": {"key": "qid", "type": "str"},
    }

    def __init__(
        self, *, text: Optional[str] = None, links: Optional[list[str]] = None, qid: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword text: Text attribute of sample utterance.
        :paramtype text: str
        :keyword links: Links attribute of sample utterance.
        :paramtype links: list[str]
        :keyword qid: Question id of sample utterance (for stackoverflow questions titles).
        :paramtype qid: str
        """
        super().__init__(**kwargs)
        self.text = text
        self.links = links
        self.qid = qid


class Scale(_serialization.Model):
    """Container App scaling configurations.

    :ivar min_replicas: Optional. Minimum number of container replicas.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
    :vartype max_replicas: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~azure.mgmt.certificateregistration.models.ScaleRule]
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
        "rules": {"key": "rules", "type": "[ScaleRule]"},
    }

    def __init__(
        self,
        *,
        min_replicas: Optional[int] = None,
        max_replicas: Optional[int] = None,
        rules: Optional[list["_models.ScaleRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Optional. Minimum number of container replicas.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not
         set.
        :paramtype max_replicas: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~azure.mgmt.certificateregistration.models.ScaleRule]
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.rules = rules


class ScaleRule(_serialization.Model):
    """Container App container scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar azure_queue: Azure Queue based scaling.
    :vartype azure_queue: ~azure.mgmt.certificateregistration.models.QueueScaleRule
    :ivar custom: Custom scale rule.
    :vartype custom: ~azure.mgmt.certificateregistration.models.CustomScaleRule
    :ivar http: HTTP requests based scaling.
    :vartype http: ~azure.mgmt.certificateregistration.models.HttpScaleRule
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_queue": {"key": "azureQueue", "type": "QueueScaleRule"},
        "custom": {"key": "custom", "type": "CustomScaleRule"},
        "http": {"key": "http", "type": "HttpScaleRule"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        azure_queue: Optional["_models.QueueScaleRule"] = None,
        custom: Optional["_models.CustomScaleRule"] = None,
        http: Optional["_models.HttpScaleRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword azure_queue: Azure Queue based scaling.
        :paramtype azure_queue: ~azure.mgmt.certificateregistration.models.QueueScaleRule
        :keyword custom: Custom scale rule.
        :paramtype custom: ~azure.mgmt.certificateregistration.models.CustomScaleRule
        :keyword http: HTTP requests based scaling.
        :paramtype http: ~azure.mgmt.certificateregistration.models.HttpScaleRule
        """
        super().__init__(**kwargs)
        self.name = name
        self.azure_queue = azure_queue
        self.custom = custom
        self.http = http


class ScaleRuleAuth(_serialization.Model):
    """Auth Secrets for Container App Scale Rule.

    :ivar secret_ref: Name of the Container App secret from which to pull the auth params.
    :vartype secret_ref: str
    :ivar trigger_parameter: Trigger Parameter that uses the secret.
    :vartype trigger_parameter: str
    """

    _attribute_map = {
        "secret_ref": {"key": "secretRef", "type": "str"},
        "trigger_parameter": {"key": "triggerParameter", "type": "str"},
    }

    def __init__(
        self, *, secret_ref: Optional[str] = None, trigger_parameter: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_ref: Name of the Container App secret from which to pull the auth params.
        :paramtype secret_ref: str
        :keyword trigger_parameter: Trigger Parameter that uses the secret.
        :paramtype trigger_parameter: str
        """
        super().__init__(**kwargs)
        self.secret_ref = secret_ref
        self.trigger_parameter = trigger_parameter


class ServiceSpecification(_serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications:
     list[~azure.mgmt.certificateregistration.models.MetricSpecification]
    :ivar log_specifications:
    :vartype log_specifications: list[~azure.mgmt.certificateregistration.models.LogSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[list["_models.MetricSpecification"]] = None,
        log_specifications: Optional[list["_models.LogSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications:
        :paramtype metric_specifications:
         list[~azure.mgmt.certificateregistration.models.MetricSpecification]
        :keyword log_specifications:
        :paramtype log_specifications:
         list[~azure.mgmt.certificateregistration.models.LogSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications
        self.log_specifications = log_specifications


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource. If the resource is an app, you can refer to
     https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
     for details supported values for kind.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed service identity.
    :vartype identity: ~azure.mgmt.certificateregistration.models.ManagedServiceIdentity
    :ivar extended_location: Extended Location.
    :vartype extended_location: ~azure.mgmt.certificateregistration.models.ExtendedLocation
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Known values are: "Normal" and "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.certificateregistration.models.UsageState
    :ivar enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :vartype enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Known values
     are: "Normal", "Limited", and "DisasterRecoveryMode".
    :vartype availability_state: str or
     ~azure.mgmt.certificateregistration.models.SiteAvailabilityState
    :ivar host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :vartype host_name_ssl_states:
     list[~azure.mgmt.certificateregistration.models.HostNameSslState]
    :ivar server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :vartype server_farm_id: str
    :ivar reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :vartype reserved: bool
    :ivar is_xenon: Obsolete: Hyper-V sandbox.
    :vartype is_xenon: bool
    :ivar hyper_v: Hyper-V sandbox.
    :vartype hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :ivar dns_configuration: Property to configure various DNS related settings for a site.
    :vartype dns_configuration: ~azure.mgmt.certificateregistration.models.SiteDnsConfig
    :ivar outbound_vnet_routing: Property to configure various outbound traffic routing options
     over virtual network for a site.
    :vartype outbound_vnet_routing: ~azure.mgmt.certificateregistration.models.OutboundVnetRouting
    :ivar site_config: Configuration of an App Service app. This property is not returned in
     response to normal create and read requests since it may contain sensitive information.
    :vartype site_config: ~azure.mgmt.certificateregistration.models.SiteConfig
    :ivar function_app_config: Configuration specific of the Azure Function app.
    :vartype function_app_config: ~azure.mgmt.certificateregistration.models.FunctionAppConfig
    :ivar dapr_config: Dapr configuration of the app.
    :vartype dapr_config: ~azure.mgmt.certificateregistration.models.DaprConfig
    :ivar workload_profile_name: Workload profile name for function app to execute on.
    :vartype workload_profile_name: str
    :ivar resource_config: Function app resource requirements.
    :vartype resource_config: ~azure.mgmt.certificateregistration.models.ResourceConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :ivar scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :vartype scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :ivar hosting_environment_profile: App Service Environment to use for the app.
    :vartype hosting_environment_profile:
     ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
    :ivar client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :vartype client_affinity_enabled: bool
    :ivar client_affinity_partitioning_enabled: :code:`<code>true</code>` to enable client affinity
     partitioning using CHIPS cookies, this will add the :code:`<code>partitioned</code>` property
     to the affinity cookies; :code:`<code>false</code>` to stop sending partitioned affinity
     cookies. Default is :code:`<code>false</code>`.
    :vartype client_affinity_partitioning_enabled: bool
    :ivar client_affinity_proxy_enabled: :code:`<code>true</code>` to override client affinity
     cookie domain with X-Forwarded-Host request header. :code:`<code>false</code>` to use default
     domain. Default is :code:`<code>false</code>`.
    :vartype client_affinity_proxy_enabled: bool
    :ivar client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :vartype client_cert_enabled: bool
    :ivar client_cert_mode: This composes with ClientCertEnabled setting.


     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
       accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
    :vartype client_cert_mode: str or ~azure.mgmt.certificateregistration.models.ClientCertMode
    :ivar client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :vartype client_cert_exclusion_paths: str
    :ivar ip_mode: Specifies the IP mode of the app. Known values are: "IPv4", "IPv6", and
     "IPv4AndIPv6".
    :vartype ip_mode: str or ~azure.mgmt.certificateregistration.models.IPMode
    :ivar end_to_end_encryption_enabled: Whether to use end to end encryption between the FrontEnd
     and the Worker.
    :vartype end_to_end_encryption_enabled: bool
    :ivar ssh_enabled: Whether to enable ssh access.
    :vartype ssh_enabled: bool
    :ivar host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :vartype host_names_disabled: bool
    :ivar custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :vartype custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :ivar container_size: Size of the function container.
    :vartype container_size: int
    :ivar daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :vartype daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :ivar cloning_info: If specified during app creation, the app is cloned from a source app.
    :vartype cloning_info: ~azure.mgmt.certificateregistration.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.certificateregistration.models.SlotSwapStatus
    :ivar https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :vartype https_only: bool
    :ivar redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
     "ActiveActive", and "GeoRedundant".
    :vartype redundancy_mode: str or ~azure.mgmt.certificateregistration.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :ivar public_network_access: Property to allow or block all public traffic. Allowed Values:
     'Enabled', 'Disabled' or an empty string.
    :vartype public_network_access: str
    :ivar storage_account_required: Checks if Customer provided storage account is required.
    :vartype storage_account_required: bool
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar auto_generated_domain_name_label_scope: Specifies the scope of uniqueness for the default
     hostname during resource creation. Known values are: "TenantReuse", "SubscriptionReuse",
     "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.certificateregistration.models.AutoGeneratedDomainNameLabelScope
    :ivar virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet to
     be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_subnet_id: str
    :ivar managed_environment_id: Azure Resource Manager ID of the customer's selected Managed
     Environment on which to host this app. This must be of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.
    :vartype managed_environment_id: str
    :ivar sku: Current SKU of application based on associated App Service Plan. Some valid SKU
     values are Free, Shared, Basic, Dynamic, FlexConsumption, Standard, Premium, PremiumV2,
     PremiumV3, Isolated, IsolatedV2.
    :vartype sku: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
        "host_names": {"readonly": True},
        "repository_site_name": {"readonly": True},
        "usage_state": {"readonly": True},
        "enabled_host_names": {"readonly": True},
        "availability_state": {"readonly": True},
        "last_modified_time_utc": {"readonly": True},
        "traffic_manager_host_names": {"readonly": True},
        "target_swap_slot": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "possible_outbound_ip_addresses": {"readonly": True},
        "suspended_till": {"readonly": True},
        "max_number_of_workers": {"readonly": True},
        "resource_group": {"readonly": True},
        "is_default_container": {"readonly": True},
        "default_host_name": {"readonly": True},
        "slot_swap_status": {"readonly": True},
        "in_progress_operation_id": {"readonly": True},
        "sku": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "state": {"key": "properties.state", "type": "str"},
        "host_names": {"key": "properties.hostNames", "type": "[str]"},
        "repository_site_name": {"key": "properties.repositorySiteName", "type": "str"},
        "usage_state": {"key": "properties.usageState", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "enabled_host_names": {"key": "properties.enabledHostNames", "type": "[str]"},
        "availability_state": {"key": "properties.availabilityState", "type": "str"},
        "host_name_ssl_states": {"key": "properties.hostNameSslStates", "type": "[HostNameSslState]"},
        "server_farm_id": {"key": "properties.serverFarmId", "type": "str"},
        "reserved": {"key": "properties.reserved", "type": "bool"},
        "is_xenon": {"key": "properties.isXenon", "type": "bool"},
        "hyper_v": {"key": "properties.hyperV", "type": "bool"},
        "last_modified_time_utc": {"key": "properties.lastModifiedTimeUtc", "type": "iso-8601"},
        "dns_configuration": {"key": "properties.dnsConfiguration", "type": "SiteDnsConfig"},
        "outbound_vnet_routing": {"key": "properties.outboundVnetRouting", "type": "OutboundVnetRouting"},
        "site_config": {"key": "properties.siteConfig", "type": "SiteConfig"},
        "function_app_config": {"key": "properties.functionAppConfig", "type": "FunctionAppConfig"},
        "dapr_config": {"key": "properties.daprConfig", "type": "DaprConfig"},
        "workload_profile_name": {"key": "properties.workloadProfileName", "type": "str"},
        "resource_config": {"key": "properties.resourceConfig", "type": "ResourceConfig"},
        "traffic_manager_host_names": {"key": "properties.trafficManagerHostNames", "type": "[str]"},
        "scm_site_also_stopped": {"key": "properties.scmSiteAlsoStopped", "type": "bool"},
        "target_swap_slot": {"key": "properties.targetSwapSlot", "type": "str"},
        "hosting_environment_profile": {
            "key": "properties.hostingEnvironmentProfile",
            "type": "HostingEnvironmentProfile",
        },
        "client_affinity_enabled": {"key": "properties.clientAffinityEnabled", "type": "bool"},
        "client_affinity_partitioning_enabled": {"key": "properties.clientAffinityPartitioningEnabled", "type": "bool"},
        "client_affinity_proxy_enabled": {"key": "properties.clientAffinityProxyEnabled", "type": "bool"},
        "client_cert_enabled": {"key": "properties.clientCertEnabled", "type": "bool"},
        "client_cert_mode": {"key": "properties.clientCertMode", "type": "str"},
        "client_cert_exclusion_paths": {"key": "properties.clientCertExclusionPaths", "type": "str"},
        "ip_mode": {"key": "properties.ipMode", "type": "str"},
        "end_to_end_encryption_enabled": {"key": "properties.endToEndEncryptionEnabled", "type": "bool"},
        "ssh_enabled": {"key": "properties.sshEnabled", "type": "bool"},
        "host_names_disabled": {"key": "properties.hostNamesDisabled", "type": "bool"},
        "custom_domain_verification_id": {"key": "properties.customDomainVerificationId", "type": "str"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "str"},
        "possible_outbound_ip_addresses": {"key": "properties.possibleOutboundIpAddresses", "type": "str"},
        "container_size": {"key": "properties.containerSize", "type": "int"},
        "daily_memory_time_quota": {"key": "properties.dailyMemoryTimeQuota", "type": "int"},
        "suspended_till": {"key": "properties.suspendedTill", "type": "iso-8601"},
        "max_number_of_workers": {"key": "properties.maxNumberOfWorkers", "type": "int"},
        "cloning_info": {"key": "properties.cloningInfo", "type": "CloningInfo"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "is_default_container": {"key": "properties.isDefaultContainer", "type": "bool"},
        "default_host_name": {"key": "properties.defaultHostName", "type": "str"},
        "slot_swap_status": {"key": "properties.slotSwapStatus", "type": "SlotSwapStatus"},
        "https_only": {"key": "properties.httpsOnly", "type": "bool"},
        "redundancy_mode": {"key": "properties.redundancyMode", "type": "str"},
        "in_progress_operation_id": {"key": "properties.inProgressOperationId", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "storage_account_required": {"key": "properties.storageAccountRequired", "type": "bool"},
        "key_vault_reference_identity": {"key": "properties.keyVaultReferenceIdentity", "type": "str"},
        "auto_generated_domain_name_label_scope": {
            "key": "properties.autoGeneratedDomainNameLabelScope",
            "type": "str",
        },
        "virtual_network_subnet_id": {"key": "properties.virtualNetworkSubnetId", "type": "str"},
        "managed_environment_id": {"key": "properties.managedEnvironmentId", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        enabled: Optional[bool] = None,
        host_name_ssl_states: Optional[list["_models.HostNameSslState"]] = None,
        server_farm_id: Optional[str] = None,
        reserved: bool = False,
        is_xenon: bool = False,
        hyper_v: bool = False,
        dns_configuration: Optional["_models.SiteDnsConfig"] = None,
        outbound_vnet_routing: Optional["_models.OutboundVnetRouting"] = None,
        site_config: Optional["_models.SiteConfig"] = None,
        function_app_config: Optional["_models.FunctionAppConfig"] = None,
        dapr_config: Optional["_models.DaprConfig"] = None,
        workload_profile_name: Optional[str] = None,
        resource_config: Optional["_models.ResourceConfig"] = None,
        scm_site_also_stopped: bool = False,
        hosting_environment_profile: Optional["_models.HostingEnvironmentProfile"] = None,
        client_affinity_enabled: Optional[bool] = None,
        client_affinity_partitioning_enabled: Optional[bool] = None,
        client_affinity_proxy_enabled: Optional[bool] = None,
        client_cert_enabled: Optional[bool] = None,
        client_cert_mode: Optional[Union[str, "_models.ClientCertMode"]] = None,
        client_cert_exclusion_paths: Optional[str] = None,
        ip_mode: Optional[Union[str, "_models.IPMode"]] = None,
        end_to_end_encryption_enabled: Optional[bool] = None,
        ssh_enabled: Optional[bool] = None,
        host_names_disabled: Optional[bool] = None,
        custom_domain_verification_id: Optional[str] = None,
        container_size: Optional[int] = None,
        daily_memory_time_quota: Optional[int] = None,
        cloning_info: Optional["_models.CloningInfo"] = None,
        https_only: Optional[bool] = None,
        redundancy_mode: Optional[Union[str, "_models.RedundancyMode"]] = None,
        public_network_access: Optional[str] = None,
        storage_account_required: Optional[bool] = None,
        key_vault_reference_identity: Optional[str] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        virtual_network_subnet_id: Optional[str] = None,
        managed_environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource. If the resource is an app, you can refer to
         https://github.com/Azure/app-service-linux-docs/blob/master/Things_You_Should_Know/kind_property.md#app-service-resource-kind-reference
         for details supported values for kind.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed service identity.
        :paramtype identity: ~azure.mgmt.certificateregistration.models.ManagedServiceIdentity
        :keyword extended_location: Extended Location.
        :paramtype extended_location: ~azure.mgmt.certificateregistration.models.ExtendedLocation
        :keyword enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
         :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
         offline).
        :paramtype enabled: bool
        :keyword host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for
         app's hostnames.
        :paramtype host_name_ssl_states:
         list[~azure.mgmt.certificateregistration.models.HostNameSslState]
        :keyword server_farm_id: Resource ID of the associated App Service plan, formatted as:
         "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
        :paramtype server_farm_id: str
        :keyword reserved: :code:`<code>true</code>` if reserved; otherwise,
         :code:`<code>false</code>`.
        :paramtype reserved: bool
        :keyword is_xenon: Obsolete: Hyper-V sandbox.
        :paramtype is_xenon: bool
        :keyword hyper_v: Hyper-V sandbox.
        :paramtype hyper_v: bool
        :keyword dns_configuration: Property to configure various DNS related settings for a site.
        :paramtype dns_configuration: ~azure.mgmt.certificateregistration.models.SiteDnsConfig
        :keyword outbound_vnet_routing: Property to configure various outbound traffic routing options
         over virtual network for a site.
        :paramtype outbound_vnet_routing:
         ~azure.mgmt.certificateregistration.models.OutboundVnetRouting
        :keyword site_config: Configuration of an App Service app. This property is not returned in
         response to normal create and read requests since it may contain sensitive information.
        :paramtype site_config: ~azure.mgmt.certificateregistration.models.SiteConfig
        :keyword function_app_config: Configuration specific of the Azure Function app.
        :paramtype function_app_config: ~azure.mgmt.certificateregistration.models.FunctionAppConfig
        :keyword dapr_config: Dapr configuration of the app.
        :paramtype dapr_config: ~azure.mgmt.certificateregistration.models.DaprConfig
        :keyword workload_profile_name: Workload profile name for function app to execute on.
        :paramtype workload_profile_name: str
        :keyword resource_config: Function app resource requirements.
        :paramtype resource_config: ~azure.mgmt.certificateregistration.models.ResourceConfig
        :keyword scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app
         is stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
        :paramtype scm_site_also_stopped: bool
        :keyword hosting_environment_profile: App Service Environment to use for the app.
        :paramtype hosting_environment_profile:
         ~azure.mgmt.certificateregistration.models.HostingEnvironmentProfile
        :keyword client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
         :code:`<code>false</code>` to stop sending session affinity cookies, which route client
         requests in the same session to the same instance. Default is :code:`<code>true</code>`.
        :paramtype client_affinity_enabled: bool
        :keyword client_affinity_partitioning_enabled: :code:`<code>true</code>` to enable client
         affinity partitioning using CHIPS cookies, this will add the :code:`<code>partitioned</code>`
         property to the affinity cookies; :code:`<code>false</code>` to stop sending partitioned
         affinity cookies. Default is :code:`<code>false</code>`.
        :paramtype client_affinity_partitioning_enabled: bool
        :keyword client_affinity_proxy_enabled: :code:`<code>true</code>` to override client affinity
         cookie domain with X-Forwarded-Host request header. :code:`<code>false</code>` to use default
         domain. Default is :code:`<code>false</code>`.
        :paramtype client_affinity_proxy_enabled: bool
        :keyword client_cert_enabled: :code:`<code>true</code>` to enable client certificate
         authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
         :code:`<code>false</code>`.
        :paramtype client_cert_enabled: bool
        :keyword client_cert_mode: This composes with ClientCertEnabled setting.


          * ClientCertEnabled: false means ClientCert is ignored.
          * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
          * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
            accepted. Known values are: "Required", "Optional", and "OptionalInteractiveUser".
        :paramtype client_cert_mode: str or ~azure.mgmt.certificateregistration.models.ClientCertMode
        :keyword client_cert_exclusion_paths: client certificate authentication comma-separated
         exclusion paths.
        :paramtype client_cert_exclusion_paths: str
        :keyword ip_mode: Specifies the IP mode of the app. Known values are: "IPv4", "IPv6", and
         "IPv4AndIPv6".
        :paramtype ip_mode: str or ~azure.mgmt.certificateregistration.models.IPMode
        :keyword end_to_end_encryption_enabled: Whether to use end to end encryption between the
         FrontEnd and the Worker.
        :paramtype end_to_end_encryption_enabled: bool
        :keyword ssh_enabled: Whether to enable ssh access.
        :paramtype ssh_enabled: bool
        :keyword host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
         app; otherwise, :code:`<code>false</code>`.
          If :code:`<code>true</code>`, the app is only accessible via API management process.
        :paramtype host_names_disabled: bool
        :keyword custom_domain_verification_id: Unique identifier that verifies the custom domains
         assigned to the app. Customer will add this id to a txt record for verification.
        :paramtype custom_domain_verification_id: str
        :keyword container_size: Size of the function container.
        :paramtype container_size: int
        :keyword daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on
         dynamic apps only).
        :paramtype daily_memory_time_quota: int
        :keyword cloning_info: If specified during app creation, the app is cloned from a source app.
        :paramtype cloning_info: ~azure.mgmt.certificateregistration.models.CloningInfo
        :keyword https_only: HttpsOnly: configures a web site to accept only https requests. Issues
         redirect for
         http requests.
        :paramtype https_only: bool
        :keyword redundancy_mode: Site redundancy mode. Known values are: "None", "Manual", "Failover",
         "ActiveActive", and "GeoRedundant".
        :paramtype redundancy_mode: str or ~azure.mgmt.certificateregistration.models.RedundancyMode
        :keyword public_network_access: Property to allow or block all public traffic. Allowed Values:
         'Enabled', 'Disabled' or an empty string.
        :paramtype public_network_access: str
        :keyword storage_account_required: Checks if Customer provided storage account is required.
        :paramtype storage_account_required: bool
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword auto_generated_domain_name_label_scope: Specifies the scope of uniqueness for the
         default hostname during resource creation. Known values are: "TenantReuse",
         "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.certificateregistration.models.AutoGeneratedDomainNameLabelScope
        :keyword virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
         to be joined by Regional VNET Integration.
         This must be of the form
         /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_subnet_id: str
        :keyword managed_environment_id: Azure Resource Manager ID of the customer's selected Managed
         Environment on which to host this app. This must be of the form
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.App/managedEnvironments/{managedEnvironmentName}.
        :paramtype managed_environment_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.identity = identity
        self.extended_location = extended_location
        self.state: Optional[str] = None
        self.host_names: Optional[list[str]] = None
        self.repository_site_name: Optional[str] = None
        self.usage_state: Optional[Union[str, "_models.UsageState"]] = None
        self.enabled = enabled
        self.enabled_host_names: Optional[list[str]] = None
        self.availability_state: Optional[Union[str, "_models.SiteAvailabilityState"]] = None
        self.host_name_ssl_states = host_name_ssl_states
        self.server_farm_id = server_farm_id
        self.reserved = reserved
        self.is_xenon = is_xenon
        self.hyper_v = hyper_v
        self.last_modified_time_utc: Optional[datetime.datetime] = None
        self.dns_configuration = dns_configuration
        self.outbound_vnet_routing = outbound_vnet_routing
        self.site_config = site_config
        self.function_app_config = function_app_config
        self.dapr_config = dapr_config
        self.workload_profile_name = workload_profile_name
        self.resource_config = resource_config
        self.traffic_manager_host_names: Optional[list[str]] = None
        self.scm_site_also_stopped = scm_site_also_stopped
        self.target_swap_slot: Optional[str] = None
        self.hosting_environment_profile = hosting_environment_profile
        self.client_affinity_enabled = client_affinity_enabled
        self.client_affinity_partitioning_enabled = client_affinity_partitioning_enabled
        self.client_affinity_proxy_enabled = client_affinity_proxy_enabled
        self.client_cert_enabled = client_cert_enabled
        self.client_cert_mode = client_cert_mode
        self.client_cert_exclusion_paths = client_cert_exclusion_paths
        self.ip_mode = ip_mode
        self.end_to_end_encryption_enabled = end_to_end_encryption_enabled
        self.ssh_enabled = ssh_enabled
        self.host_names_disabled = host_names_disabled
        self.custom_domain_verification_id = custom_domain_verification_id
        self.outbound_ip_addresses: Optional[str] = None
        self.possible_outbound_ip_addresses: Optional[str] = None
        self.container_size = container_size
        self.daily_memory_time_quota = daily_memory_time_quota
        self.suspended_till: Optional[datetime.datetime] = None
        self.max_number_of_workers: Optional[int] = None
        self.cloning_info = cloning_info
        self.resource_group: Optional[str] = None
        self.is_default_container: Optional[bool] = None
        self.default_host_name: Optional[str] = None
        self.slot_swap_status: Optional["_models.SlotSwapStatus"] = None
        self.https_only = https_only
        self.redundancy_mode = redundancy_mode
        self.in_progress_operation_id: Optional[str] = None
        self.public_network_access = public_network_access
        self.storage_account_required = storage_account_required
        self.key_vault_reference_identity = key_vault_reference_identity
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.managed_environment_id = managed_environment_id
        self.sku: Optional[str] = None


class SiteConfig(_serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar number_of_workers: Number of workers.
    :vartype number_of_workers: int
    :ivar default_documents: Default documents.
    :vartype default_documents: list[str]
    :ivar net_framework_version: .NET Framework version.
    :vartype net_framework_version: str
    :ivar php_version: Version of PHP.
    :vartype php_version: str
    :ivar python_version: Version of Python.
    :vartype python_version: str
    :ivar node_version: Version of Node.js.
    :vartype node_version: str
    :ivar power_shell_version: Version of PowerShell.
    :vartype power_shell_version: str
    :ivar linux_fx_version: Linux App Framework and version.
    :vartype linux_fx_version: str
    :ivar windows_fx_version: Xenon App Framework and version.
    :vartype windows_fx_version: str
    :ivar request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype request_tracing_enabled: bool
    :ivar request_tracing_expiration_time: Request tracing expiration time.
    :vartype request_tracing_expiration_time: ~datetime.datetime
    :ivar remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_enabled: bool
    :ivar remote_debugging_version: Remote debugging version.
    :vartype remote_debugging_version: str
    :ivar http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype http_logging_enabled: bool
    :ivar acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :vartype acr_use_managed_identity_creds: bool
    :ivar acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :vartype acr_user_managed_identity_id: str
    :ivar logs_directory_size_limit: HTTP logs directory size limit.
    :vartype logs_directory_size_limit: int
    :ivar detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :vartype detailed_error_logging_enabled: bool
    :ivar publishing_username: Publishing user name.
    :vartype publishing_username: str
    :ivar app_settings: Application settings. This property is not returned in response to normal
     create and read requests since it may contain sensitive information.
    :vartype app_settings: list[~azure.mgmt.certificateregistration.models.NameValuePair]
    :ivar metadata: Application metadata. This property cannot be retrieved, since it may contain
     secrets.
    :vartype metadata: list[~azure.mgmt.certificateregistration.models.NameValuePair]
    :ivar connection_strings: Connection strings. This property is not returned in response to
     normal create and read requests since it may contain sensitive information.
    :vartype connection_strings: list[~azure.mgmt.certificateregistration.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.certificateregistration.models.SiteMachineKey
    :ivar handler_mappings: Handler mappings.
    :vartype handler_mappings: list[~azure.mgmt.certificateregistration.models.HandlerMapping]
    :ivar document_root: Document root.
    :vartype document_root: str
    :ivar scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
     "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
     "OneDrive", "VSO", and "VSTSRM".
    :vartype scm_type: str or ~azure.mgmt.certificateregistration.models.ScmType
    :ivar use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype web_sockets_enabled: bool
    :ivar always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype always_on: bool
    :ivar java_version: Java version.
    :vartype java_version: str
    :ivar java_container: Java container.
    :vartype java_container: str
    :ivar java_container_version: Java container version.
    :vartype java_container_version: str
    :ivar app_command_line: App command line to launch.
    :vartype app_command_line: str
    :ivar managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
     "Classic".
    :vartype managed_pipeline_mode: str or
     ~azure.mgmt.certificateregistration.models.ManagedPipelineMode
    :ivar virtual_applications: Virtual applications.
    :vartype virtual_applications:
     list[~azure.mgmt.certificateregistration.models.VirtualApplication]
    :ivar load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
     "PerSiteRoundRobin", and "LeastRequestsWithTieBreaker".
    :vartype load_balancing: str or ~azure.mgmt.certificateregistration.models.SiteLoadBalancing
    :ivar experiments: This is work around for polymorphic types.
    :vartype experiments: ~azure.mgmt.certificateregistration.models.Experiments
    :ivar limits: Site limits.
    :vartype limits: ~azure.mgmt.certificateregistration.models.SiteLimits
    :ivar auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype auto_heal_enabled: bool
    :ivar auto_heal_rules: Auto Heal rules.
    :vartype auto_heal_rules: ~azure.mgmt.certificateregistration.models.AutoHealRules
    :ivar tracing_options: Tracing options.
    :vartype tracing_options: str
    :ivar vnet_name: Virtual Network name.
    :vartype vnet_name: str
    :ivar vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :vartype vnet_route_all_enabled: bool
    :ivar vnet_private_ports_count: The number of private ports assigned to this app. These will be
     assigned dynamically on runtime.
    :vartype vnet_private_ports_count: int
    :ivar cors: Cross-Origin Resource Sharing (CORS) settings.
    :vartype cors: ~azure.mgmt.certificateregistration.models.CorsSettings
    :ivar push: Push endpoint settings.
    :vartype push: ~azure.mgmt.certificateregistration.models.PushSettings
    :ivar api_definition: Information about the formal API definition for the app.
    :vartype api_definition: ~azure.mgmt.certificateregistration.models.ApiDefinitionInfo
    :ivar api_management_config: Azure API management settings linked to the app.
    :vartype api_management_config: ~azure.mgmt.certificateregistration.models.ApiManagementConfig
    :ivar auto_swap_slot_name: Auto-swap slot name.
    :vartype auto_swap_slot_name: str
    :ivar local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :vartype local_my_sql_enabled: bool
    :ivar managed_service_identity_id: Managed Service Identity Id.
    :vartype managed_service_identity_id: int
    :ivar x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :vartype x_managed_service_identity_id: int
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar ip_security_restrictions: IP security restrictions for main.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.certificateregistration.models.IpSecurityRestriction]
    :ivar ip_security_restrictions_default_action: Default action for main access restriction if no
     rules are matched. Known values are: "Allow" and "Deny".
    :vartype ip_security_restrictions_default_action: str or
     ~azure.mgmt.certificateregistration.models.DefaultAction
    :ivar scm_ip_security_restrictions: IP security restrictions for scm.
    :vartype scm_ip_security_restrictions:
     list[~azure.mgmt.certificateregistration.models.IpSecurityRestriction]
    :ivar scm_ip_security_restrictions_default_action: Default action for scm access restriction if
     no rules are matched. Known values are: "Allow" and "Deny".
    :vartype scm_ip_security_restrictions_default_action: str or
     ~azure.mgmt.certificateregistration.models.DefaultAction
    :ivar scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :vartype scm_ip_security_restrictions_use_main: bool
    :ivar http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :vartype http20_enabled: bool
    :ivar http20_proxy_flag: Http20ProxyFlag: Configures a website to allow http2.0 to pass be
     proxied all the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass
     through gRPC only.
    :vartype http20_proxy_flag: int
    :ivar min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Known values are: "1.0", "1.1", "1.2", and "1.3".
    :vartype min_tls_version: str or
     ~azure.mgmt.certificateregistration.models.SupportedTlsVersions
    :ivar min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an application.
     Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
     "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
     "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
     "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
     "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
     "TLS_RSA_WITH_AES_128_CBC_SHA".
    :vartype min_tls_cipher_suite: str or
     ~azure.mgmt.certificateregistration.models.TlsCipherSuites
    :ivar scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required for
     SSL requests for SCM site. Known values are: "1.0", "1.1", "1.2", and "1.3".
    :vartype scm_min_tls_version: str or
     ~azure.mgmt.certificateregistration.models.SupportedTlsVersions
    :ivar ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly", and
     "Disabled".
    :vartype ftps_state: str or ~azure.mgmt.certificateregistration.models.FtpsState
    :ivar pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :vartype pre_warmed_instance_count: int
    :ivar function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :vartype function_app_scale_limit: int
    :ivar elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to apps in plans where ElasticScaleEnabled is
     :code:`<code>true</code>`.
    :vartype elastic_web_app_scale_limit: int
    :ivar health_check_path: Health check path.
    :vartype health_check_path: str
    :ivar functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :vartype functions_runtime_scale_monitoring_enabled: bool
    :ivar website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
     NT\\CurrentVersion\\Time Zones.
    :vartype website_time_zone: str
    :ivar minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :vartype minimum_elastic_instance_count: int
    :ivar azure_storage_accounts: List of Azure Storage Accounts.
    :vartype azure_storage_accounts: dict[str,
     ~azure.mgmt.certificateregistration.models.AzureStorageInfoValue]
    :ivar public_network_access: Property to allow or block all public traffic.
    :vartype public_network_access: str
    """

    _validation = {
        "machine_key": {"readonly": True},
        "pre_warmed_instance_count": {"maximum": 10, "minimum": 0},
        "function_app_scale_limit": {"minimum": 0},
        "elastic_web_app_scale_limit": {"minimum": 0},
        "minimum_elastic_instance_count": {"maximum": 20, "minimum": 0},
    }

    _attribute_map = {
        "number_of_workers": {"key": "numberOfWorkers", "type": "int"},
        "default_documents": {"key": "defaultDocuments", "type": "[str]"},
        "net_framework_version": {"key": "netFrameworkVersion", "type": "str"},
        "php_version": {"key": "phpVersion", "type": "str"},
        "python_version": {"key": "pythonVersion", "type": "str"},
        "node_version": {"key": "nodeVersion", "type": "str"},
        "power_shell_version": {"key": "powerShellVersion", "type": "str"},
        "linux_fx_version": {"key": "linuxFxVersion", "type": "str"},
        "windows_fx_version": {"key": "windowsFxVersion", "type": "str"},
        "request_tracing_enabled": {"key": "requestTracingEnabled", "type": "bool"},
        "request_tracing_expiration_time": {"key": "requestTracingExpirationTime", "type": "iso-8601"},
        "remote_debugging_enabled": {"key": "remoteDebuggingEnabled", "type": "bool"},
        "remote_debugging_version": {"key": "remoteDebuggingVersion", "type": "str"},
        "http_logging_enabled": {"key": "httpLoggingEnabled", "type": "bool"},
        "acr_use_managed_identity_creds": {"key": "acrUseManagedIdentityCreds", "type": "bool"},
        "acr_user_managed_identity_id": {"key": "acrUserManagedIdentityID", "type": "str"},
        "logs_directory_size_limit": {"key": "logsDirectorySizeLimit", "type": "int"},
        "detailed_error_logging_enabled": {"key": "detailedErrorLoggingEnabled", "type": "bool"},
        "publishing_username": {"key": "publishingUsername", "type": "str"},
        "app_settings": {"key": "appSettings", "type": "[NameValuePair]"},
        "metadata": {"key": "metadata", "type": "[NameValuePair]"},
        "connection_strings": {"key": "connectionStrings", "type": "[ConnStringInfo]"},
        "machine_key": {"key": "machineKey", "type": "SiteMachineKey"},
        "handler_mappings": {"key": "handlerMappings", "type": "[HandlerMapping]"},
        "document_root": {"key": "documentRoot", "type": "str"},
        "scm_type": {"key": "scmType", "type": "str"},
        "use32_bit_worker_process": {"key": "use32BitWorkerProcess", "type": "bool"},
        "web_sockets_enabled": {"key": "webSocketsEnabled", "type": "bool"},
        "always_on": {"key": "alwaysOn", "type": "bool"},
        "java_version": {"key": "javaVersion", "type": "str"},
        "java_container": {"key": "javaContainer", "type": "str"},
        "java_container_version": {"key": "javaContainerVersion", "type": "str"},
        "app_command_line": {"key": "appCommandLine", "type": "str"},
        "managed_pipeline_mode": {"key": "managedPipelineMode", "type": "str"},
        "virtual_applications": {"key": "virtualApplications", "type": "[VirtualApplication]"},
        "load_balancing": {"key": "loadBalancing", "type": "str"},
        "experiments": {"key": "experiments", "type": "Experiments"},
        "limits": {"key": "limits", "type": "SiteLimits"},
        "auto_heal_enabled": {"key": "autoHealEnabled", "type": "bool"},
        "auto_heal_rules": {"key": "autoHealRules", "type": "AutoHealRules"},
        "tracing_options": {"key": "tracingOptions", "type": "str"},
        "vnet_name": {"key": "vnetName", "type": "str"},
        "vnet_route_all_enabled": {"key": "vnetRouteAllEnabled", "type": "bool"},
        "vnet_private_ports_count": {"key": "vnetPrivatePortsCount", "type": "int"},
        "cors": {"key": "cors", "type": "CorsSettings"},
        "push": {"key": "push", "type": "PushSettings"},
        "api_definition": {"key": "apiDefinition", "type": "ApiDefinitionInfo"},
        "api_management_config": {"key": "apiManagementConfig", "type": "ApiManagementConfig"},
        "auto_swap_slot_name": {"key": "autoSwapSlotName", "type": "str"},
        "local_my_sql_enabled": {"key": "localMySqlEnabled", "type": "bool"},
        "managed_service_identity_id": {"key": "managedServiceIdentityId", "type": "int"},
        "x_managed_service_identity_id": {"key": "xManagedServiceIdentityId", "type": "int"},
        "key_vault_reference_identity": {"key": "keyVaultReferenceIdentity", "type": "str"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "ip_security_restrictions_default_action": {"key": "ipSecurityRestrictionsDefaultAction", "type": "str"},
        "scm_ip_security_restrictions": {"key": "scmIpSecurityRestrictions", "type": "[IpSecurityRestriction]"},
        "scm_ip_security_restrictions_default_action": {"key": "scmIpSecurityRestrictionsDefaultAction", "type": "str"},
        "scm_ip_security_restrictions_use_main": {"key": "scmIpSecurityRestrictionsUseMain", "type": "bool"},
        "http20_enabled": {"key": "http20Enabled", "type": "bool"},
        "http20_proxy_flag": {"key": "http20ProxyFlag", "type": "int"},
        "min_tls_version": {"key": "minTlsVersion", "type": "str"},
        "min_tls_cipher_suite": {"key": "minTlsCipherSuite", "type": "str"},
        "scm_min_tls_version": {"key": "scmMinTlsVersion", "type": "str"},
        "ftps_state": {"key": "ftpsState", "type": "str"},
        "pre_warmed_instance_count": {"key": "preWarmedInstanceCount", "type": "int"},
        "function_app_scale_limit": {"key": "functionAppScaleLimit", "type": "int"},
        "elastic_web_app_scale_limit": {"key": "elasticWebAppScaleLimit", "type": "int"},
        "health_check_path": {"key": "healthCheckPath", "type": "str"},
        "functions_runtime_scale_monitoring_enabled": {"key": "functionsRuntimeScaleMonitoringEnabled", "type": "bool"},
        "website_time_zone": {"key": "websiteTimeZone", "type": "str"},
        "minimum_elastic_instance_count": {"key": "minimumElasticInstanceCount", "type": "int"},
        "azure_storage_accounts": {"key": "azureStorageAccounts", "type": "{AzureStorageInfoValue}"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        number_of_workers: Optional[int] = None,
        default_documents: Optional[list[str]] = None,
        net_framework_version: str = "v4.6",
        php_version: Optional[str] = None,
        python_version: Optional[str] = None,
        node_version: Optional[str] = None,
        power_shell_version: Optional[str] = None,
        linux_fx_version: Optional[str] = None,
        windows_fx_version: Optional[str] = None,
        request_tracing_enabled: Optional[bool] = None,
        request_tracing_expiration_time: Optional[datetime.datetime] = None,
        remote_debugging_enabled: Optional[bool] = None,
        remote_debugging_version: Optional[str] = None,
        http_logging_enabled: Optional[bool] = None,
        acr_use_managed_identity_creds: Optional[bool] = None,
        acr_user_managed_identity_id: Optional[str] = None,
        logs_directory_size_limit: Optional[int] = None,
        detailed_error_logging_enabled: Optional[bool] = None,
        publishing_username: Optional[str] = None,
        app_settings: Optional[list["_models.NameValuePair"]] = None,
        metadata: Optional[list["_models.NameValuePair"]] = None,
        connection_strings: Optional[list["_models.ConnStringInfo"]] = None,
        handler_mappings: Optional[list["_models.HandlerMapping"]] = None,
        document_root: Optional[str] = None,
        scm_type: Optional[Union[str, "_models.ScmType"]] = None,
        use32_bit_worker_process: Optional[bool] = None,
        web_sockets_enabled: Optional[bool] = None,
        always_on: Optional[bool] = None,
        java_version: Optional[str] = None,
        java_container: Optional[str] = None,
        java_container_version: Optional[str] = None,
        app_command_line: Optional[str] = None,
        managed_pipeline_mode: Optional[Union[str, "_models.ManagedPipelineMode"]] = None,
        virtual_applications: Optional[list["_models.VirtualApplication"]] = None,
        load_balancing: Optional[Union[str, "_models.SiteLoadBalancing"]] = None,
        experiments: Optional["_models.Experiments"] = None,
        limits: Optional["_models.SiteLimits"] = None,
        auto_heal_enabled: Optional[bool] = None,
        auto_heal_rules: Optional["_models.AutoHealRules"] = None,
        tracing_options: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vnet_route_all_enabled: Optional[bool] = None,
        vnet_private_ports_count: Optional[int] = None,
        cors: Optional["_models.CorsSettings"] = None,
        push: Optional["_models.PushSettings"] = None,
        api_definition: Optional["_models.ApiDefinitionInfo"] = None,
        api_management_config: Optional["_models.ApiManagementConfig"] = None,
        auto_swap_slot_name: Optional[str] = None,
        local_my_sql_enabled: bool = False,
        managed_service_identity_id: Optional[int] = None,
        x_managed_service_identity_id: Optional[int] = None,
        key_vault_reference_identity: Optional[str] = None,
        ip_security_restrictions: Optional[list["_models.IpSecurityRestriction"]] = None,
        ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions: Optional[list["_models.IpSecurityRestriction"]] = None,
        scm_ip_security_restrictions_default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        scm_ip_security_restrictions_use_main: Optional[bool] = None,
        http20_enabled: bool = True,
        http20_proxy_flag: int = 0,
        min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        min_tls_cipher_suite: Optional[Union[str, "_models.TlsCipherSuites"]] = None,
        scm_min_tls_version: Optional[Union[str, "_models.SupportedTlsVersions"]] = None,
        ftps_state: Optional[Union[str, "_models.FtpsState"]] = None,
        pre_warmed_instance_count: Optional[int] = None,
        function_app_scale_limit: Optional[int] = None,
        elastic_web_app_scale_limit: Optional[int] = None,
        health_check_path: Optional[str] = None,
        functions_runtime_scale_monitoring_enabled: Optional[bool] = None,
        website_time_zone: Optional[str] = None,
        minimum_elastic_instance_count: Optional[int] = None,
        azure_storage_accounts: Optional[dict[str, "_models.AzureStorageInfoValue"]] = None,
        public_network_access: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_workers: Number of workers.
        :paramtype number_of_workers: int
        :keyword default_documents: Default documents.
        :paramtype default_documents: list[str]
        :keyword net_framework_version: .NET Framework version.
        :paramtype net_framework_version: str
        :keyword php_version: Version of PHP.
        :paramtype php_version: str
        :keyword python_version: Version of Python.
        :paramtype python_version: str
        :keyword node_version: Version of Node.js.
        :paramtype node_version: str
        :keyword power_shell_version: Version of PowerShell.
        :paramtype power_shell_version: str
        :keyword linux_fx_version: Linux App Framework and version.
        :paramtype linux_fx_version: str
        :keyword windows_fx_version: Xenon App Framework and version.
        :paramtype windows_fx_version: str
        :keyword request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype request_tracing_enabled: bool
        :keyword request_tracing_expiration_time: Request tracing expiration time.
        :paramtype request_tracing_expiration_time: ~datetime.datetime
        :keyword remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
         otherwise, :code:`<code>false</code>`.
        :paramtype remote_debugging_enabled: bool
        :keyword remote_debugging_version: Remote debugging version.
        :paramtype remote_debugging_version: str
        :keyword http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype http_logging_enabled: bool
        :keyword acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
        :paramtype acr_use_managed_identity_creds: bool
        :keyword acr_user_managed_identity_id: If using user managed identity, the user managed
         identity ClientId.
        :paramtype acr_user_managed_identity_id: str
        :keyword logs_directory_size_limit: HTTP logs directory size limit.
        :paramtype logs_directory_size_limit: int
        :keyword detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
         enabled; otherwise, :code:`<code>false</code>`.
        :paramtype detailed_error_logging_enabled: bool
        :keyword publishing_username: Publishing user name.
        :paramtype publishing_username: str
        :keyword app_settings: Application settings. This property is not returned in response to
         normal create and read requests since it may contain sensitive information.
        :paramtype app_settings: list[~azure.mgmt.certificateregistration.models.NameValuePair]
        :keyword metadata: Application metadata. This property cannot be retrieved, since it may
         contain secrets.
        :paramtype metadata: list[~azure.mgmt.certificateregistration.models.NameValuePair]
        :keyword connection_strings: Connection strings. This property is not returned in response to
         normal create and read requests since it may contain sensitive information.
        :paramtype connection_strings: list[~azure.mgmt.certificateregistration.models.ConnStringInfo]
        :keyword handler_mappings: Handler mappings.
        :paramtype handler_mappings: list[~azure.mgmt.certificateregistration.models.HandlerMapping]
        :keyword document_root: Document root.
        :paramtype document_root: str
        :keyword scm_type: SCM type. Known values are: "None", "Dropbox", "Tfs", "LocalGit", "GitHub",
         "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit", "ExternalHg",
         "OneDrive", "VSO", and "VSTSRM".
        :paramtype scm_type: str or ~azure.mgmt.certificateregistration.models.ScmType
        :keyword use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
         otherwise, :code:`<code>false</code>`.
        :paramtype use32_bit_worker_process: bool
        :keyword web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype web_sockets_enabled: bool
        :keyword always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype always_on: bool
        :keyword java_version: Java version.
        :paramtype java_version: str
        :keyword java_container: Java container.
        :paramtype java_container: str
        :keyword java_container_version: Java container version.
        :paramtype java_container_version: str
        :keyword app_command_line: App command line to launch.
        :paramtype app_command_line: str
        :keyword managed_pipeline_mode: Managed pipeline mode. Known values are: "Integrated" and
         "Classic".
        :paramtype managed_pipeline_mode: str or
         ~azure.mgmt.certificateregistration.models.ManagedPipelineMode
        :keyword virtual_applications: Virtual applications.
        :paramtype virtual_applications:
         list[~azure.mgmt.certificateregistration.models.VirtualApplication]
        :keyword load_balancing: Site load balancing. Known values are: "WeightedRoundRobin",
         "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
         "PerSiteRoundRobin", and "LeastRequestsWithTieBreaker".
        :paramtype load_balancing: str or ~azure.mgmt.certificateregistration.models.SiteLoadBalancing
        :keyword experiments: This is work around for polymorphic types.
        :paramtype experiments: ~azure.mgmt.certificateregistration.models.Experiments
        :keyword limits: Site limits.
        :paramtype limits: ~azure.mgmt.certificateregistration.models.SiteLimits
        :keyword auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype auto_heal_enabled: bool
        :keyword auto_heal_rules: Auto Heal rules.
        :paramtype auto_heal_rules: ~azure.mgmt.certificateregistration.models.AutoHealRules
        :keyword tracing_options: Tracing options.
        :paramtype tracing_options: str
        :keyword vnet_name: Virtual Network name.
        :paramtype vnet_name: str
        :keyword vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
         traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :paramtype vnet_route_all_enabled: bool
        :keyword vnet_private_ports_count: The number of private ports assigned to this app. These will
         be assigned dynamically on runtime.
        :paramtype vnet_private_ports_count: int
        :keyword cors: Cross-Origin Resource Sharing (CORS) settings.
        :paramtype cors: ~azure.mgmt.certificateregistration.models.CorsSettings
        :keyword push: Push endpoint settings.
        :paramtype push: ~azure.mgmt.certificateregistration.models.PushSettings
        :keyword api_definition: Information about the formal API definition for the app.
        :paramtype api_definition: ~azure.mgmt.certificateregistration.models.ApiDefinitionInfo
        :keyword api_management_config: Azure API management settings linked to the app.
        :paramtype api_management_config:
         ~azure.mgmt.certificateregistration.models.ApiManagementConfig
        :keyword auto_swap_slot_name: Auto-swap slot name.
        :paramtype auto_swap_slot_name: str
        :keyword local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
         :code:`<code>false</code>`.
        :paramtype local_my_sql_enabled: bool
        :keyword managed_service_identity_id: Managed Service Identity Id.
        :paramtype managed_service_identity_id: int
        :keyword x_managed_service_identity_id: Explicit Managed Service Identity Id.
        :paramtype x_managed_service_identity_id: int
        :keyword key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
        :paramtype key_vault_reference_identity: str
        :keyword ip_security_restrictions: IP security restrictions for main.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.certificateregistration.models.IpSecurityRestriction]
        :keyword ip_security_restrictions_default_action: Default action for main access restriction if
         no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype ip_security_restrictions_default_action: str or
         ~azure.mgmt.certificateregistration.models.DefaultAction
        :keyword scm_ip_security_restrictions: IP security restrictions for scm.
        :paramtype scm_ip_security_restrictions:
         list[~azure.mgmt.certificateregistration.models.IpSecurityRestriction]
        :keyword scm_ip_security_restrictions_default_action: Default action for scm access restriction
         if no rules are matched. Known values are: "Allow" and "Deny".
        :paramtype scm_ip_security_restrictions_default_action: str or
         ~azure.mgmt.certificateregistration.models.DefaultAction
        :keyword scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
        :paramtype scm_ip_security_restrictions_use_main: bool
        :keyword http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
         http2.0.
        :paramtype http20_enabled: bool
        :keyword http20_proxy_flag: Http20ProxyFlag: Configures a website to allow http2.0 to pass be
         proxied all the way to the app. 0 = disabled, 1 = pass through all http2 traffic, 2 = pass
         through gRPC only.
        :paramtype http20_proxy_flag: int
        :keyword min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
         requests. Known values are: "1.0", "1.1", "1.2", and "1.3".
        :paramtype min_tls_version: str or
         ~azure.mgmt.certificateregistration.models.SupportedTlsVersions
        :keyword min_tls_cipher_suite: The minimum strength TLS cipher suite allowed for an
         application. Known values are: "TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
         "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
         "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384",
         "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256",
         "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", and
         "TLS_RSA_WITH_AES_128_CBC_SHA".
        :paramtype min_tls_cipher_suite: str or
         ~azure.mgmt.certificateregistration.models.TlsCipherSuites
        :keyword scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
         for SSL requests for SCM site. Known values are: "1.0", "1.1", "1.2", and "1.3".
        :paramtype scm_min_tls_version: str or
         ~azure.mgmt.certificateregistration.models.SupportedTlsVersions
        :keyword ftps_state: State of FTP / FTPS service. Known values are: "AllAllowed", "FtpsOnly",
         and "Disabled".
        :paramtype ftps_state: str or ~azure.mgmt.certificateregistration.models.FtpsState
        :keyword pre_warmed_instance_count: Number of preWarmed instances.
         This setting only applies to the Consumption and Elastic Plans.
        :paramtype pre_warmed_instance_count: int
        :keyword function_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to the Consumption and Elastic Premium Plans.
        :paramtype function_app_scale_limit: int
        :keyword elastic_web_app_scale_limit: Maximum number of workers that a site can scale out to.
         This setting only applies to apps in plans where ElasticScaleEnabled is
         :code:`<code>true</code>`.
        :paramtype elastic_web_app_scale_limit: int
        :keyword health_check_path: Health check path.
        :paramtype health_check_path: str
        :keyword functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
         functions runtime scale monitoring is enabled. When enabled,
         the ScaleController will not monitor event sources directly, but will instead call to the
         runtime to get scale status.
        :paramtype functions_runtime_scale_monitoring_enabled: bool
        :keyword website_time_zone: Sets the time zone a site uses for generating timestamps.
         Compatible with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes
         precedence over this config. For Linux, expects tz database values
         https://www.iana.org/time-zones (for a quick reference see
         https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows, expects one of the
         time zones listed under HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows
         NT\\CurrentVersion\\Time Zones.
        :paramtype website_time_zone: str
        :keyword minimum_elastic_instance_count: Number of minimum instance count for a site
         This setting only applies to the Elastic Plans.
        :paramtype minimum_elastic_instance_count: int
        :keyword azure_storage_accounts: List of Azure Storage Accounts.
        :paramtype azure_storage_accounts: dict[str,
         ~azure.mgmt.certificateregistration.models.AzureStorageInfoValue]
        :keyword public_network_access: Property to allow or block all public traffic.
        :paramtype public_network_access: str
        """
        super().__init__(**kwargs)
        self.number_of_workers = number_of_workers
        self.default_documents = default_documents
        self.net_framework_version = net_framework_version
        self.php_version = php_version
        self.python_version = python_version
        self.node_version = node_version
        self.power_shell_version = power_shell_version
        self.linux_fx_version = linux_fx_version
        self.windows_fx_version = windows_fx_version
        self.request_tracing_enabled = request_tracing_enabled
        self.request_tracing_expiration_time = request_tracing_expiration_time
        self.remote_debugging_enabled = remote_debugging_enabled
        self.remote_debugging_version = remote_debugging_version
        self.http_logging_enabled = http_logging_enabled
        self.acr_use_managed_identity_creds = acr_use_managed_identity_creds
        self.acr_user_managed_identity_id = acr_user_managed_identity_id
        self.logs_directory_size_limit = logs_directory_size_limit
        self.detailed_error_logging_enabled = detailed_error_logging_enabled
        self.publishing_username = publishing_username
        self.app_settings = app_settings
        self.metadata = metadata
        self.connection_strings = connection_strings
        self.machine_key: Optional["_models.SiteMachineKey"] = None
        self.handler_mappings = handler_mappings
        self.document_root = document_root
        self.scm_type = scm_type
        self.use32_bit_worker_process = use32_bit_worker_process
        self.web_sockets_enabled = web_sockets_enabled
        self.always_on = always_on
        self.java_version = java_version
        self.java_container = java_container
        self.java_container_version = java_container_version
        self.app_command_line = app_command_line
        self.managed_pipeline_mode = managed_pipeline_mode
        self.virtual_applications = virtual_applications
        self.load_balancing = load_balancing
        self.experiments = experiments
        self.limits = limits
        self.auto_heal_enabled = auto_heal_enabled
        self.auto_heal_rules = auto_heal_rules
        self.tracing_options = tracing_options
        self.vnet_name = vnet_name
        self.vnet_route_all_enabled = vnet_route_all_enabled
        self.vnet_private_ports_count = vnet_private_ports_count
        self.cors = cors
        self.push = push
        self.api_definition = api_definition
        self.api_management_config = api_management_config
        self.auto_swap_slot_name = auto_swap_slot_name
        self.local_my_sql_enabled = local_my_sql_enabled
        self.managed_service_identity_id = managed_service_identity_id
        self.x_managed_service_identity_id = x_managed_service_identity_id
        self.key_vault_reference_identity = key_vault_reference_identity
        self.ip_security_restrictions = ip_security_restrictions
        self.ip_security_restrictions_default_action = ip_security_restrictions_default_action
        self.scm_ip_security_restrictions = scm_ip_security_restrictions
        self.scm_ip_security_restrictions_default_action = scm_ip_security_restrictions_default_action
        self.scm_ip_security_restrictions_use_main = scm_ip_security_restrictions_use_main
        self.http20_enabled = http20_enabled
        self.http20_proxy_flag = http20_proxy_flag
        self.min_tls_version = min_tls_version
        self.min_tls_cipher_suite = min_tls_cipher_suite
        self.scm_min_tls_version = scm_min_tls_version
        self.ftps_state = ftps_state
        self.pre_warmed_instance_count = pre_warmed_instance_count
        self.function_app_scale_limit = function_app_scale_limit
        self.elastic_web_app_scale_limit = elastic_web_app_scale_limit
        self.health_check_path = health_check_path
        self.functions_runtime_scale_monitoring_enabled = functions_runtime_scale_monitoring_enabled
        self.website_time_zone = website_time_zone
        self.minimum_elastic_instance_count = minimum_elastic_instance_count
        self.azure_storage_accounts = azure_storage_accounts
        self.public_network_access = public_network_access


class SiteDnsConfig(_serialization.Model):
    """SiteDnsConfig.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dns_servers: List of custom DNS servers to be used by an app for lookups. Maximum 5 dns
     servers can be set.
    :vartype dns_servers: list[str]
    :ivar dns_alt_server: Alternate DNS server to be used by apps. This property replicates the
     WEBSITE_DNS_ALT_SERVER app setting.
    :vartype dns_alt_server: str
    :ivar dns_retry_attempt_timeout: Timeout for a single dns lookup in seconds. Allowed range:
     1-30. Default is 3.
    :vartype dns_retry_attempt_timeout: int
    :ivar dns_retry_attempt_count: Total number of retries for dns lookup. Allowed range: 1-5.
     Default is 3.
    :vartype dns_retry_attempt_count: int
    :ivar dns_max_cache_timeout: Custom time for DNS to be cached in seconds. Allowed range: 0-60.
     Default is 30 seconds. 0 means caching disabled.
    :vartype dns_max_cache_timeout: int
    :ivar dns_legacy_sort_order: Indicates that sites using Virtual network custom DNS servers are
     still sorting the list of DNS servers. Read-Only.
    :vartype dns_legacy_sort_order: bool
    """

    _validation = {
        "dns_legacy_sort_order": {"readonly": True},
    }

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "dns_alt_server": {"key": "dnsAltServer", "type": "str"},
        "dns_retry_attempt_timeout": {"key": "dnsRetryAttemptTimeout", "type": "int"},
        "dns_retry_attempt_count": {"key": "dnsRetryAttemptCount", "type": "int"},
        "dns_max_cache_timeout": {"key": "dnsMaxCacheTimeout", "type": "int"},
        "dns_legacy_sort_order": {"key": "dnsLegacySortOrder", "type": "bool"},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[list[str]] = None,
        dns_alt_server: Optional[str] = None,
        dns_retry_attempt_timeout: Optional[int] = None,
        dns_retry_attempt_count: Optional[int] = None,
        dns_max_cache_timeout: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dns_servers: List of custom DNS servers to be used by an app for lookups. Maximum 5
         dns servers can be set.
        :paramtype dns_servers: list[str]
        :keyword dns_alt_server: Alternate DNS server to be used by apps. This property replicates the
         WEBSITE_DNS_ALT_SERVER app setting.
        :paramtype dns_alt_server: str
        :keyword dns_retry_attempt_timeout: Timeout for a single dns lookup in seconds. Allowed range:
         1-30. Default is 3.
        :paramtype dns_retry_attempt_timeout: int
        :keyword dns_retry_attempt_count: Total number of retries for dns lookup. Allowed range: 1-5.
         Default is 3.
        :paramtype dns_retry_attempt_count: int
        :keyword dns_max_cache_timeout: Custom time for DNS to be cached in seconds. Allowed range:
         0-60. Default is 30 seconds. 0 means caching disabled.
        :paramtype dns_max_cache_timeout: int
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers
        self.dns_alt_server = dns_alt_server
        self.dns_retry_attempt_timeout = dns_retry_attempt_timeout
        self.dns_retry_attempt_count = dns_retry_attempt_count
        self.dns_max_cache_timeout = dns_max_cache_timeout
        self.dns_legacy_sort_order: Optional[bool] = None


class SiteLimits(_serialization.Model):
    """Metric limits set on an app.

    :ivar max_percentage_cpu: Maximum allowed CPU usage percentage.
    :vartype max_percentage_cpu: float
    :ivar max_memory_in_mb: Maximum allowed memory usage in MB.
    :vartype max_memory_in_mb: int
    :ivar max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :vartype max_disk_size_in_mb: int
    """

    _attribute_map = {
        "max_percentage_cpu": {"key": "maxPercentageCpu", "type": "float"},
        "max_memory_in_mb": {"key": "maxMemoryInMb", "type": "int"},
        "max_disk_size_in_mb": {"key": "maxDiskSizeInMb", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_percentage_cpu: Optional[float] = None,
        max_memory_in_mb: Optional[int] = None,
        max_disk_size_in_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_percentage_cpu: Maximum allowed CPU usage percentage.
        :paramtype max_percentage_cpu: float
        :keyword max_memory_in_mb: Maximum allowed memory usage in MB.
        :paramtype max_memory_in_mb: int
        :keyword max_disk_size_in_mb: Maximum allowed disk size usage in MB.
        :paramtype max_disk_size_in_mb: int
        """
        super().__init__(**kwargs)
        self.max_percentage_cpu = max_percentage_cpu
        self.max_memory_in_mb = max_memory_in_mb
        self.max_disk_size_in_mb = max_disk_size_in_mb


class SiteMachineKey(_serialization.Model):
    """MachineKey of an app.

    :ivar validation: MachineKey validation.
    :vartype validation: str
    :ivar validation_key: Validation key.
    :vartype validation_key: str
    :ivar decryption: Algorithm used for decryption.
    :vartype decryption: str
    :ivar decryption_key: Decryption key.
    :vartype decryption_key: str
    """

    _attribute_map = {
        "validation": {"key": "validation", "type": "str"},
        "validation_key": {"key": "validationKey", "type": "str"},
        "decryption": {"key": "decryption", "type": "str"},
        "decryption_key": {"key": "decryptionKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        validation: Optional[str] = None,
        validation_key: Optional[str] = None,
        decryption: Optional[str] = None,
        decryption_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword validation: MachineKey validation.
        :paramtype validation: str
        :keyword validation_key: Validation key.
        :paramtype validation_key: str
        :keyword decryption: Algorithm used for decryption.
        :paramtype decryption: str
        :keyword decryption_key: Decryption key.
        :paramtype decryption_key: str
        """
        super().__init__(**kwargs)
        self.validation = validation
        self.validation_key = validation_key
        self.decryption = decryption
        self.decryption_key = decryption_key


class SiteSeal(_serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to server.

    :ivar html: HTML snippet. Required.
    :vartype html: str
    """

    _validation = {
        "html": {"required": True},
    }

    _attribute_map = {
        "html": {"key": "html", "type": "str"},
    }

    def __init__(self, *, html: str, **kwargs: Any) -> None:
        """
        :keyword html: HTML snippet. Required.
        :paramtype html: str
        """
        super().__init__(**kwargs)
        self.html = html


class SiteSealRequest(_serialization.Model):
    """Site seal request.

    :ivar light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :vartype light_theme: bool
    :ivar locale: Locale of site seal.
    :vartype locale: str
    """

    _attribute_map = {
        "light_theme": {"key": "lightTheme", "type": "bool"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(self, *, light_theme: Optional[bool] = None, locale: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
         otherwise, use the default color theme.
        :paramtype light_theme: bool
        :keyword locale: Locale of site seal.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale


class SkuCapacity(_serialization.Model):
    """Description of the App Service plan scale options.

    :ivar minimum: Minimum number of workers for this App Service plan SKU.
    :vartype minimum: int
    :ivar maximum: Maximum number of workers for this App Service plan SKU.
    :vartype maximum: int
    :ivar elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
    :vartype elastic_maximum: int
    :ivar default: Default number of workers for this App Service plan SKU.
    :vartype default: int
    :ivar scale_type: Available scale configurations for an App Service plan.
    :vartype scale_type: str
    """

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "elastic_maximum": {"key": "elasticMaximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: Optional[int] = None,
        maximum: Optional[int] = None,
        elastic_maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Minimum number of workers for this App Service plan SKU.
        :paramtype minimum: int
        :keyword maximum: Maximum number of workers for this App Service plan SKU.
        :paramtype maximum: int
        :keyword elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
        :paramtype elastic_maximum: int
        :keyword default: Default number of workers for this App Service plan SKU.
        :paramtype default: int
        :keyword scale_type: Available scale configurations for an App Service plan.
        :paramtype scale_type: str
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.elastic_maximum = elastic_maximum
        self.default = default
        self.scale_type = scale_type


class SkuDescription(_serialization.Model):
    """Description of a SKU for a scalable resource.

    :ivar name: Name of the resource SKU.
    :vartype name: str
    :ivar tier: Service tier of the resource SKU.
    :vartype tier: str
    :ivar size: Size specifier of the resource SKU.
    :vartype size: str
    :ivar family: Family code of the resource SKU.
    :vartype family: str
    :ivar capacity: Current number of instances assigned to the resource.
    :vartype capacity: int
    :ivar sku_capacity: Min, max, and default scale values of the SKU.
    :vartype sku_capacity: ~azure.mgmt.certificateregistration.models.SkuCapacity
    :ivar locations: Locations of the SKU.
    :vartype locations: list[str]
    :ivar capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :vartype capabilities: list[~azure.mgmt.certificateregistration.models.Capability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
        "sku_capacity": {"key": "skuCapacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[Capability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        sku_capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[list[str]] = None,
        capabilities: Optional[list["_models.Capability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the resource SKU.
        :paramtype name: str
        :keyword tier: Service tier of the resource SKU.
        :paramtype tier: str
        :keyword size: Size specifier of the resource SKU.
        :paramtype size: str
        :keyword family: Family code of the resource SKU.
        :paramtype family: str
        :keyword capacity: Current number of instances assigned to the resource.
        :paramtype capacity: int
        :keyword sku_capacity: Min, max, and default scale values of the SKU.
        :paramtype sku_capacity: ~azure.mgmt.certificateregistration.models.SkuCapacity
        :keyword locations: Locations of the SKU.
        :paramtype locations: list[str]
        :keyword capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
        :paramtype capabilities: list[~azure.mgmt.certificateregistration.models.Capability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity
        self.sku_capacity = sku_capacity
        self.locations = locations
        self.capabilities = capabilities


class SlotSwapStatus(_serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        "timestamp_utc": {"readonly": True},
        "source_slot_name": {"readonly": True},
        "destination_slot_name": {"readonly": True},
    }

    _attribute_map = {
        "timestamp_utc": {"key": "timestampUtc", "type": "iso-8601"},
        "source_slot_name": {"key": "sourceSlotName", "type": "str"},
        "destination_slot_name": {"key": "destinationSlotName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp_utc: Optional[datetime.datetime] = None
        self.source_slot_name: Optional[str] = None
        self.destination_slot_name: Optional[str] = None


class SlowRequestsBasedTrigger(_serialization.Model):
    """Trigger based on request execution time.

    :ivar time_taken: Time taken.
    :vartype time_taken: str
    :ivar path: Request Path.
    :vartype path: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "time_taken": {"key": "timeTaken", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        time_taken: Optional[str] = None,
        path: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_taken: Time taken.
        :paramtype time_taken: str
        :keyword path: Request Path.
        :paramtype path: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.time_taken = time_taken
        self.path = path
        self.count = count
        self.time_interval = time_interval


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time": {"key": "properties.time", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(kind=kind, **kwargs)
        self.time: Optional[str] = None


class Status(_serialization.Model):
    """Identify the status of the most severe insight generated by the detector.

    :ivar message: Descriptive message.
    :vartype message: str
    :ivar status_id: Level of the most severe insight generated by the detector. Known values are:
     "Critical", "Warning", "Info", "Success", and "None".
    :vartype status_id: str or ~azure.mgmt.certificateregistration.models.InsightStatus
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "status_id": {"key": "statusId", "type": "str"},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        status_id: Optional[Union[str, "_models.InsightStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword message: Descriptive message.
        :paramtype message: str
        :keyword status_id: Level of the most severe insight generated by the detector. Known values
         are: "Critical", "Warning", "Info", "Success", and "None".
        :paramtype status_id: str or ~azure.mgmt.certificateregistration.models.InsightStatus
        """
        super().__init__(**kwargs)
        self.message = message
        self.status_id = status_id


class StatusCodesBasedTrigger(_serialization.Model):
    """Trigger based on status code.

    :ivar status: HTTP status code.
    :vartype status: int
    :ivar sub_status: Request Sub Status.
    :vartype sub_status: int
    :ivar win32_status: Win32 error code.
    :vartype win32_status: int
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    :ivar path: Request Path.
    :vartype path: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "int"},
        "sub_status": {"key": "subStatus", "type": "int"},
        "win32_status": {"key": "win32Status", "type": "int"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[int] = None,
        sub_status: Optional[int] = None,
        win32_status: Optional[int] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: HTTP status code.
        :paramtype status: int
        :keyword sub_status: Request Sub Status.
        :paramtype sub_status: int
        :keyword win32_status: Win32 error code.
        :paramtype win32_status: int
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        :keyword path: Request Path.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.sub_status = sub_status
        self.win32_status = win32_status
        self.count = count
        self.time_interval = time_interval
        self.path = path


class StatusCodesRangeBasedTrigger(_serialization.Model):
    """Trigger based on range of status codes.

    :ivar status_codes: HTTP status code.
    :vartype status_codes: str
    :ivar path:
    :vartype path: str
    :ivar count: Request Count.
    :vartype count: int
    :ivar time_interval: Time interval.
    :vartype time_interval: str
    """

    _attribute_map = {
        "status_codes": {"key": "statusCodes", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "time_interval": {"key": "timeInterval", "type": "str"},
    }

    def __init__(
        self,
        *,
        status_codes: Optional[str] = None,
        path: Optional[str] = None,
        count: Optional[int] = None,
        time_interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_codes: HTTP status code.
        :paramtype status_codes: str
        :keyword path:
        :paramtype path: str
        :keyword count: Request Count.
        :paramtype count: int
        :keyword time_interval: Time interval.
        :paramtype time_interval: str
        """
        super().__init__(**kwargs)
        self.status_codes = status_codes
        self.path = path
        self.count = count
        self.time_interval = time_interval


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Settings.
    :vartype properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self, *, kind: Optional[str] = None, properties: Optional[dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword properties: Settings.
        :paramtype properties: dict[str, str]
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class SupportTopic(_serialization.Model):
    """Defines a unique Support Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Support Topic Id.
    :vartype id: str
    :ivar pes_id: Unique resource Id.
    :vartype pes_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "pes_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "pes_id": {"key": "pesId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.pes_id: Optional[str] = None


class Template(_serialization.Model):
    """Container App versioned application definition.
    Defines the desired state of an immutable revision.
    Any changes to this section Will result in a new revision being created.

    :ivar revision_suffix: User friendly suffix that is appended to the revision name.
    :vartype revision_suffix: str
    :ivar containers: List of container definitions for the Container App.
    :vartype containers: list[~azure.mgmt.certificateregistration.models.Container]
    :ivar scale: Scaling properties for the Container App.
    :vartype scale: ~azure.mgmt.certificateregistration.models.Scale
    :ivar dapr: Dapr configuration for the Container App.
    :vartype dapr: ~azure.mgmt.certificateregistration.models.Dapr
    """

    _attribute_map = {
        "revision_suffix": {"key": "revisionSuffix", "type": "str"},
        "containers": {"key": "containers", "type": "[Container]"},
        "scale": {"key": "scale", "type": "Scale"},
        "dapr": {"key": "dapr", "type": "Dapr"},
    }

    def __init__(
        self,
        *,
        revision_suffix: Optional[str] = None,
        containers: Optional[list["_models.Container"]] = None,
        scale: Optional["_models.Scale"] = None,
        dapr: Optional["_models.Dapr"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword revision_suffix: User friendly suffix that is appended to the revision name.
        :paramtype revision_suffix: str
        :keyword containers: List of container definitions for the Container App.
        :paramtype containers: list[~azure.mgmt.certificateregistration.models.Container]
        :keyword scale: Scaling properties for the Container App.
        :paramtype scale: ~azure.mgmt.certificateregistration.models.Scale
        :keyword dapr: Dapr configuration for the Container App.
        :paramtype dapr: ~azure.mgmt.certificateregistration.models.Dapr
        """
        super().__init__(**kwargs)
        self.revision_suffix = revision_suffix
        self.containers = containers
        self.scale = scale
        self.dapr = dapr


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar publishing_user_name: Username used for publishing.
    :vartype publishing_user_name: str
    :ivar publishing_password: Password used for publishing.
    :vartype publishing_password: str
    :ivar publishing_password_hash: Password hash used for publishing.
    :vartype publishing_password_hash: str
    :ivar publishing_password_hash_salt: Password hash salt used for publishing.
    :vartype publishing_password_hash_salt: str
    :ivar scm_uri: Url of SCM site.
    :vartype scm_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "publishing_user_name": {"key": "properties.publishingUserName", "type": "str"},
        "publishing_password": {"key": "properties.publishingPassword", "type": "str"},
        "publishing_password_hash": {"key": "properties.publishingPasswordHash", "type": "str"},
        "publishing_password_hash_salt": {"key": "properties.publishingPasswordHashSalt", "type": "str"},
        "scm_uri": {"key": "properties.scmUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        publishing_user_name: Optional[str] = None,
        publishing_password: Optional[str] = None,
        publishing_password_hash: Optional[str] = None,
        publishing_password_hash_salt: Optional[str] = None,
        scm_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword publishing_user_name: Username used for publishing.
        :paramtype publishing_user_name: str
        :keyword publishing_password: Password used for publishing.
        :paramtype publishing_password: str
        :keyword publishing_password_hash: Password hash used for publishing.
        :paramtype publishing_password_hash: str
        :keyword publishing_password_hash_salt: Password hash salt used for publishing.
        :paramtype publishing_password_hash_salt: str
        :keyword scm_uri: Url of SCM site.
        :paramtype scm_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.publishing_user_name = publishing_user_name
        self.publishing_password = publishing_password
        self.publishing_password_hash = publishing_password_hash
        self.publishing_password_hash_salt = publishing_password_hash_salt
        self.scm_uri = scm_uri


class UserAssignedIdentity(_serialization.Model):
    """User Assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class VirtualApplication(_serialization.Model):
    """Virtual application in an app.

    :ivar virtual_path: Virtual path.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    :ivar preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :vartype preload_enabled: bool
    :ivar virtual_directories: Virtual directories for virtual application.
    :vartype virtual_directories: list[~azure.mgmt.certificateregistration.models.VirtualDirectory]
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
        "preload_enabled": {"key": "preloadEnabled", "type": "bool"},
        "virtual_directories": {"key": "virtualDirectories", "type": "[VirtualDirectory]"},
    }

    def __init__(
        self,
        *,
        virtual_path: Optional[str] = None,
        physical_path: Optional[str] = None,
        preload_enabled: Optional[bool] = None,
        virtual_directories: Optional[list["_models.VirtualDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Virtual path.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        :keyword preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
         :code:`<code>false</code>`.
        :paramtype preload_enabled: bool
        :keyword virtual_directories: Virtual directories for virtual application.
        :paramtype virtual_directories:
         list[~azure.mgmt.certificateregistration.models.VirtualDirectory]
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path
        self.preload_enabled = preload_enabled
        self.virtual_directories = virtual_directories


class VirtualDirectory(_serialization.Model):
    """Directory for virtual application.

    :ivar virtual_path: Path to virtual application.
    :vartype virtual_path: str
    :ivar physical_path: Physical path.
    :vartype physical_path: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "physical_path": {"key": "physicalPath", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, physical_path: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: Path to virtual application.
        :paramtype virtual_path: str
        :keyword physical_path: Physical path.
        :paramtype physical_path: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.physical_path = physical_path


class VirtualNetworkProfile(_serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource id of the Virtual Network. Required.
    :vartype id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :ivar subnet: Subnet within the Virtual Network.
    :vartype subnet: str
    """

    _validation = {
        "id": {"required": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
    }

    def __init__(
        self, *, id: str, subnet: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Resource id of the Virtual Network. Required.
        :paramtype id: str
        :keyword subnet: Subnet within the Virtual Network.
        :paramtype subnet: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.subnet = subnet


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access
    to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_name: The Virtual Network name.
    :vartype vnet_name: str
    :ivar vpn_package_uri: The URI where the VPN package can be downloaded.
    :vartype vpn_package_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_name": {"key": "properties.vnetName", "type": "str"},
        "vpn_package_uri": {"key": "properties.vpnPackageUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_name: Optional[str] = None,
        vpn_package_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_name: The Virtual Network name.
        :paramtype vnet_name: str
        :keyword vpn_package_uri: The URI where the VPN package can be downloaded.
        :paramtype vpn_package_uri: str
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_name = vnet_name
        self.vpn_package_uri = vpn_package_uri


class VnetInfoResource(ProxyOnlyResource):
    """Virtual Network information ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar vnet_resource_id: The Virtual Network's resource ID.
    :vartype vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :ivar cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :vartype cert_blob: str
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.certificateregistration.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :ivar dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :vartype dns_servers: str
    :ivar is_swift: Flag that is used to denote if this is VNET injection.
    :vartype is_swift: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "cert_thumbprint": {"readonly": True},
        "routes": {"readonly": True},
        "resync_required": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "vnet_resource_id": {"key": "properties.vnetResourceId", "type": "str"},
        "cert_thumbprint": {"key": "properties.certThumbprint", "type": "str"},
        "cert_blob": {"key": "properties.certBlob", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[VnetRoute]"},
        "resync_required": {"key": "properties.resyncRequired", "type": "bool"},
        "dns_servers": {"key": "properties.dnsServers", "type": "str"},
        "is_swift": {"key": "properties.isSwift", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        vnet_resource_id: Optional[str] = None,
        cert_blob: Optional[str] = None,
        dns_servers: Optional[str] = None,
        is_swift: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword vnet_resource_id: The Virtual Network's resource ID.
        :paramtype vnet_resource_id: str
        :keyword cert_blob: A certificate file (.cer) blob containing the public key of the private key
         used to authenticate a
         Point-To-Site VPN connection.
        :paramtype cert_blob: str
        :keyword dns_servers: DNS servers to be used by this Virtual Network. This should be a
         comma-separated list of IP addresses.
        :paramtype dns_servers: str
        :keyword is_swift: Flag that is used to denote if this is VNET injection.
        :paramtype is_swift: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint: Optional[str] = None
        self.cert_blob = cert_blob
        self.routes: Optional[list["_models.VnetRoute"]] = None
        self.resync_required: Optional[bool] = None
        self.dns_servers = dns_servers
        self.is_swift = is_swift


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :vartype start_address: str
    :ivar end_address: The ending address for this route. If the start address is specified in CIDR
     notation, this must be omitted.
    :vartype end_address: str
    :ivar route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only

     These values will be used for syncing an app's routes with those from a Virtual Network. Known
     values are: "DEFAULT", "INHERITED", and "STATIC".
    :vartype route_type: str or ~azure.mgmt.certificateregistration.models.RouteType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_address": {"key": "properties.startAddress", "type": "str"},
        "end_address": {"key": "properties.endAddress", "type": "str"},
        "route_type": {"key": "properties.routeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        start_address: Optional[str] = None,
        end_address: Optional[str] = None,
        route_type: Optional[Union[str, "_models.RouteType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword start_address: The starting address for this route. This may also include a CIDR
         notation, in which case the end address must not be specified.
        :paramtype start_address: str
        :keyword end_address: The ending address for this route. If the start address is specified in
         CIDR notation, this must be omitted.
        :paramtype end_address: str
        :keyword route_type: The type of route this is:
         DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
         INHERITED - Routes inherited from the real Virtual Network routes
         STATIC - Static route set on the app only

         These values will be used for syncing an app's routes with those from a Virtual Network. Known
         values are: "DEFAULT", "INHERITED", and "STATIC".
        :paramtype route_type: str or ~azure.mgmt.certificateregistration.models.RouteType
        """
        super().__init__(kind=kind, **kwargs)
        self.start_address = start_address
        self.end_address = end_address
        self.route_type = route_type


class WebAppCollection(_serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.certificateregistration.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Site]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: list["_models.Site"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.certificateregistration.models.Site]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None
