# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ColumnDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data type of a column in a table."""

    STRING = "string"
    INTEGER = "integer"
    NUMBER = "number"
    BOOLEAN = "boolean"
    OBJECT = "object"


class FacetSortOrder(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sorting order by the selected column (count by default)."""

    ASC = "asc"
    DESC = "desc"


class ResultFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines in which format query result returned."""

    TABLE = "table"
    OBJECT_ARRAY = "objectArray"


class ResultKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum indicating a type of graph query."""

    BASIC = "basic"


class ResultTruncated(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the query results are truncated."""

    TRUE = "true"
    FALSE = "false"
