# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.8, generator: @autorest/python@6.42.1)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class KnowledgeBaseMessageContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of message content."""

    TEXT = "text"
    """Text message content kind."""
    IMAGE = "image"
    """Image message content kind."""


class KnowledgeRetrievalIntentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of knowledge base configuration to use."""

    SEMANTIC = "semantic"
    """A natural language semantic query intent."""


class KnowledgeRetrievalOutputMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The output configuration for this retrieval."""

    EXTRACTIVE_DATA = "extractiveData"
    """Return data from the knowledge sources directly without generative alteration."""
    ANSWER_SYNTHESIS = "answerSynthesis"
    """Synthesize an answer for the response payload."""


class KnowledgeRetrievalReasoningEffortKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The amount of effort to use during retrieval."""

    MINIMAL = "minimal"
    """Does not perform any source selections, query planning, or iterative search."""
    LOW = "low"
    """Use low reasoning during retrieval."""
    MEDIUM = "medium"
    """Use a moderate amount of reasoning during retrieval."""


class KnowledgeSourceKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the knowledge source."""

    SEARCH_INDEX = "searchIndex"
    """A knowledge source that retrieves data from a Search Index."""
    AZURE_BLOB = "azureBlob"
    """A knowledge source that retrieves and ingests data from Azure Blob Storage to a Search Index."""
    WEB = "web"
    """A knowledge source that retrieves data from the web."""
    REMOTE_SHARE_POINT = "remoteSharePoint"
    """A knowledge source that retrieves data from a remote SharePoint endpoint."""
    INDEXED_SHARE_POINT = "indexedSharePoint"
    """A knowledge source that retrieves and ingests data from SharePoint to a Search Index."""
    INDEXED_ONE_LAKE = "indexedOneLake"
    """A knowledge source that retrieves and ingests data from OneLake to a Search Index."""
