% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{keep_with_next}
\alias{keep_with_next}
\title{Set Word 'Keep with next' instructions}
\usage{
keep_with_next(x, i = NULL, value = TRUE, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{value}{TRUE or FALSE. When applied to a group, all rows
except the last one should be flagged with the 'Keep with next' attribute.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
The 'Keep with next' functionality in 'Word', applied
to the rows of a table, ensures that rows with that attribute
stay together and do not break across multiple pages.

This function provides better control of page breaks than
the global \code{keep_with_next} parameter.
}
\examples{
library(flextable)
dat <- iris[c(1:25, 51:75, 101:125), ]
ft <- qflextable(dat)
ft <- keep_with_next(
  x = ft,
  i = c(1:24, 26:49, 51:74),
  value = TRUE
)

save_as_docx(ft, path = tempfile(fileext = ".docx"))
}
\seealso{
\code{\link[=paginate]{paginate()}}

Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{line_spacing}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
