<head>
  <meta charset="UTF-8">
  <meta name="description" content="ROCm API libraries & tools">
  <meta name="keywords" content="ROCm, API, libraries, tools, AI, artificial intelligence, development,
  Communications, C++ primitives, Fast Fourier transforms, FFTs, random number generators, linear
  algebra, AMD">
</head>

# ROCm tools, compilers, and runtimes

::::{grid} 1 2 2 2
:gutter: 3
:class-container: rocm-doc-grid

:::{grid-item-card} System Management
:class-body: rocm-card-banner rocm-hue-1

(system-tools)=

* {doc}`AMD SMI <amdsmi:index>`
* {doc}`ROCm Data Center Tool <rdc:index>`
* {doc}`rocminfo <rocminfo:index>`
* {doc}`ROCm SMI <rocm_smi_lib:index>`
* {doc}`ROCm Validation Suite <rocmvalidationsuite:index>`
:::

:::{grid-item-card} Performance
:class-body: rocm-card-banner rocm-hue-6

(performance-tools)=

* {doc}`ROCm Bandwidth Test <rocm_bandwidth_test:index>`
* {doc}`ROCm Compute Profiler <rocprofiler-compute:index>`
* {doc}`ROCm Systems Profiler <rocprofiler-systems:index>`
* {doc}`ROCProfiler <rocprofiler:index>`
* {doc}`ROCprofiler-SDK <rocprofiler-sdk:index>`
* {doc}`ROCTracer <roctracer:index>`
:::

:::{grid-item-card} Development
:class-body: rocm-card-banner rocm-hue-1

(development-tools)=

* {doc}`ROCm CMake <rocmcmakebuildtools:index>`
* {doc}`HIPIFY <hipify:index>`
* {doc}`ROCdbgapi <rocdbgapi:index>`
* {doc}`ROCm Debugger (ROCgdb) <rocgdb:index>`
* {doc}`ROCr Debug Agent <rocr_debug_agent:index>`
:::

:::{grid-item-card} Compilers
:class-body: rocm-card-banner rocm-hue-8

(compilers)=

* {doc}`ROCm Compilers <llvm-project:index>`
* {doc}`HIPCC <hipcc:index>`
* [FLANG](https://github.com/ROCm/flang/)
:::

:::{grid-item-card} Runtimes
:class-body: rocm-card-banner rocm-hue-12

(runtimes)=

* {doc}`AMD Compute Language Runtime (CLR) <hip:understand/amd_clr>`
* {doc}`HIP <hip:index>`
* {doc}`ROCR-Runtime <rocr-runtime:index>`
:::

::::
