An attribute was given an invalid number of arguments

Erroneous code example:

```compile_fail,E0805
#[inline()] // error! should either have a single argument, or no parentheses
fn foo() {}

#[inline(always, never)] // error! should have only one argument, not two
fn bar() {}
```

To fix this, either give the right number of arguments the attribute needs.
In the case of inline, this could be none at all:

```
#[inline]
fn foo() {}
```

or only one:

```
#[inline(always)]
fn foo() {}
```
