import re

baseChar: str
ideographic: str
combiningCharacter: str
digit: str
extender: str
letter: str
name: str
nameFirst: str
reChar: re.Pattern[str]
reCharRange: re.Pattern[str]

def charStringToList(chars: str) -> list[list[int]]: ...
def normaliseCharList(charList: list[list[int]]) -> list[list[int]]: ...

max_unicode: int

def missingRanges(charList: list[list[int]]) -> list[list[int]]: ...
def listToRegexpStr(charList: list[list[int]]) -> str: ...
def hexToInt(hex_str: str | bytes | bytearray) -> int: ...
def escapeRegexp(string: str) -> str: ...

nonXmlNameBMPRegexp: re.Pattern[str]
nonXmlNameFirstBMPRegexp: re.Pattern[str]
nonPubidCharRegexp: re.Pattern[str]

class InfosetFilter:
    replacementRegexp: re.Pattern[str]
    dropXmlnsLocalName: bool
    dropXmlnsAttrNs: bool
    preventDoubleDashComments: bool
    preventDashAtCommentEnd: bool
    replaceFormFeedCharacters: bool
    preventSingleQuotePubid: bool
    replaceCache: dict[str, str]
    def __init__(
        self,
        dropXmlnsLocalName: bool = False,
        dropXmlnsAttrNs: bool = False,
        preventDoubleDashComments: bool = False,
        preventDashAtCommentEnd: bool = False,
        replaceFormFeedCharacters: bool = True,
        preventSingleQuotePubid: bool = False,
    ) -> None: ...
    def coerceAttribute(self, name: str, namespace: str | None = None) -> str | None: ...
    def coerceElement(self, name: str) -> str: ...
    def coerceComment(self, data: str) -> str: ...
    def coerceCharacters(self, data: str) -> str: ...
    def coercePubid(self, data: str) -> str: ...
    def toXmlName(self, name: str) -> str: ...
    def getReplacementCharacter(self, char: str) -> str: ...
    def fromXmlName(self, name: str) -> str: ...
    def escapeChar(self, char: str) -> str: ...
    def unescapeChar(self, charcode: str | bytes | bytearray) -> str: ...
