
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsepart.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsepart.h>
#include        <bse/bsesong.h>


#line 26 "bsepart.proc"


/* --- insert-note --- */
static GType type_id_insert_note = 0;
static void
insert_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsepart.proc"
 {
#line 30 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
}
#line 29 "bsepart.proc"
  proc->help = "Insert a new note into a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 45 "bsepart.proc"
 }
static BseErrorType
#line 45 "bsepart.proc"
insert_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 48 "bsepart.proc"
{
#line 49 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  guint id;
  
#line 58 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 62 "bsepart.proc"
  
  id = bse_part_insert_note (self, tick, duration, note, fine_tune, velocity);
  
#line 65 "bsepart.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- change-note --- */
static GType type_id_change_note = 0;
static void
change_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 71 "bsepart.proc"
 {
#line 73 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++) = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_DEFAULT SFI_PARAM_HINT_SCALE);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 72 "bsepart.proc"
  proc->help = "Change an existing note within a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 91 "bsepart.proc"
 }
static BseErrorType
#line 91 "bsepart.proc"
change_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 94 "bsepart.proc"
{
#line 95 "bsepart.proc"
  
  BsePart *self      = bse_value_get_object (in_values++);
  guint    id	     = sfi_value_get_int (in_values++);
  guint    tick	     = sfi_value_get_int (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note	     = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  gboolean success;
  
#line 105 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 109 "bsepart.proc"
  
  success = bse_part_change_note (self, id, tick, duration, note, fine_tune, velocity);
  
#line 112 "bsepart.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- delete-event --- */
static GType type_id_delete_event = 0;
static void
delete_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 118 "bsepart.proc"
 {
#line 120 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_DEFAULT);
}
#line 119 "bsepart.proc"
  proc->help = "Delete an existing event from a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 128 "bsepart.proc"
 }
static BseErrorType
#line 128 "bsepart.proc"
delete_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 131 "bsepart.proc"
{
#line 132 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean deleted;
  
#line 137 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 141 "bsepart.proc"
  
  deleted = bse_part_delete_event (self, id);
  
#line 144 "bsepart.proc"
  
  g_value_set_enum (out_values++, deleted ? BSE_ERROR_NONE : BSE_ERROR_NO_EVENT);
  
  return BSE_ERROR_NONE;
}

/* --- is-selected-event --- */
static GType type_id_is_selected_event = 0;
static void
is_selected_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 150 "bsepart.proc"
 {
#line 152 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_bool ("selected", "Selected", NULL,
			  FALSE, SFI_PARAM_DEFAULT);
}
#line 151 "bsepart.proc"
  proc->help = "Check whether a specific event is selected.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 159 "bsepart.proc"
 }
static BseErrorType
#line 159 "bsepart.proc"
is_selected_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 162 "bsepart.proc"
{
#line 163 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean selected;
  
#line 168 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 172 "bsepart.proc"
  
  selected = bse_part_is_selected_event (self, id);
  
#line 175 "bsepart.proc"
  
  sfi_value_set_bool (out_values++, selected);
  
  return BSE_ERROR_NONE;
}

/* --- list-notes-crossing --- */
static GType type_id_list_notes_crossing = 0;
static void
list_notes_crossing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 181 "bsepart.proc"
 {
#line 183 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 182 "bsepart.proc"
  proc->help = "List all notes within or crossing a tick range.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 192 "bsepart.proc"
 }
static BseErrorType
#line 192 "bsepart.proc"
list_notes_crossing_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 195 "bsepart.proc"
{
#line 196 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  
#line 201 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 205 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_around (self, tick, duration, BSE_MIN_NOTE, BSE_MAX_NOTE));
  
  return BSE_ERROR_NONE;
}

/* --- queue-notes-within --- */
static GType type_id_queue_notes_within = 0;
static void
queue_notes_within_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 211 "bsepart.proc"
 {
#line 213 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 212 "bsepart.proc"
  proc->help = "Queue updates for all notes starting within the given region.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 224 "bsepart.proc"
 }
static BseErrorType
#line 224 "bsepart.proc"
queue_notes_within_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 227 "bsepart.proc"
{
#line 228 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     min_note = sfi_value_get_note (in_values++);
  gint     max_note = sfi_value_get_note (in_values++);
  
#line 235 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 239 "bsepart.proc"
  
  bse_part_queue_notes_within (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- list-selected-notes --- */
static GType type_id_list_selected_notes = 0;
static void
list_selected_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 245 "bsepart.proc"
 {
#line 247 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 246 "bsepart.proc"
  proc->help = "List all currently selected notes.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 252 "bsepart.proc"
 }
static BseErrorType
#line 252 "bsepart.proc"
list_selected_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 255 "bsepart.proc"
{
#line 256 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 259 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 263 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_selected_notes (self));
  
  return BSE_ERROR_NONE;
}

/* --- check-overlap --- */
static GType type_id_check_overlap = 0;
static void
check_overlap_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 269 "bsepart.proc"
 {
#line 271 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Start Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 270 "bsepart.proc"
  proc->help = "Check whether a note would overlap with neighbours.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 281 "bsepart.proc"
 }
static BseErrorType
#line 281 "bsepart.proc"
check_overlap_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 284 "bsepart.proc"
{
#line 285 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  guint    duration = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 291 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 295 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_around (self, tick, duration, note, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-notes --- */
static GType type_id_get_notes = 0;
static void
get_notes_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 301 "bsepart.proc"
 {
#line 303 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", NULL,
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("note_list", "Note List", NULL,
				BSE_TYPE_PART_NOTE_SEQ, SFI_PARAM_DEFAULT);
}
#line 302 "bsepart.proc"
  proc->help = "Retrieve all notes of specific frequency at a specific tick.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 312 "bsepart.proc"
 }
static BseErrorType
#line 312 "bsepart.proc"
get_notes_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 315 "bsepart.proc"
{
#line 316 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    tick	    = sfi_value_get_int (in_values++);
  gint     note     = sfi_value_get_note (in_values++);
  
#line 321 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 325 "bsepart.proc"
  
  bse_value_take_boxed (out_values++, bse_part_list_notes_at (self, tick, note));
  
  return BSE_ERROR_NONE;
}

/* --- get-min-note --- */
static GType type_id_get_min_note = 0;
static void
get_min_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 331 "bsepart.proc"
 {
#line 333 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 332 "bsepart.proc"
  proc->help = "Retrieve the minimum note supported in this part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 338 "bsepart.proc"
 }
static BseErrorType
#line 338 "bsepart.proc"
get_min_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 341 "bsepart.proc"
{
#line 342 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 345 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 349 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MIN_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-note --- */
static GType type_id_get_max_note = 0;
static void
get_max_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 355 "bsepart.proc"
 {
#line 357 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 356 "bsepart.proc"
  proc->help = "Retrieve the maximum note supported in this part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 362 "bsepart.proc"
 }
static BseErrorType
#line 362 "bsepart.proc"
get_max_note_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 365 "bsepart.proc"
{
#line 366 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 369 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 373 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_MAX_NOTE);
  
  return BSE_ERROR_NONE;
}

/* --- get-max-tick --- */
static GType type_id_get_max_tick = 0;
static void
get_max_tick_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 379 "bsepart.proc"
 {
#line 381 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(out_pspecs++) = sfi_pspec_int ("tick", "Tick", "Maximum Tick",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
}
#line 380 "bsepart.proc"
  proc->help = "Retrieve the maximum tick count represented in a part.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 386 "bsepart.proc"
 }
static BseErrorType
#line 386 "bsepart.proc"
get_max_tick_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 389 "bsepart.proc"
{
#line 390 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  
#line 393 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 397 "bsepart.proc"
  
  sfi_value_set_int (out_values++, BSE_PART_MAX_TICK);
  
  return BSE_ERROR_NONE;
}

/* --- select-rectangle-exclusive --- */
static GType type_id_select_rectangle_exclusive = 0;
static void
select_rectangle_exclusive_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 403 "bsepart.proc"
 {
#line 405 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 404 "bsepart.proc"
  proc->help = "Select all notes within rectangle and deselect all others.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 416 "bsepart.proc"
 }
static BseErrorType
#line 416 "bsepart.proc"
select_rectangle_exclusive_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 419 "bsepart.proc"
{
#line 420 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 427 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_rectangle_ex (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- select-rectangle --- */
static GType type_id_select_rectangle = 0;
static void
select_rectangle_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 436 "bsepart.proc"
 {
#line 438 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 437 "bsepart.proc"
  proc->help = "Select all notes within rectangle.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 449 "bsepart.proc"
 }
static BseErrorType
#line 449 "bsepart.proc"
select_rectangle_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 452 "bsepart.proc"
{
#line 453 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 460 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_select_rectangle (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- deselect-rectangle --- */
static GType type_id_deselect_rectangle = 0;
static void
deselect_rectangle_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 469 "bsepart.proc"
 {
#line 471 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", "Part",
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("tick", "Tick", "Selection Tick",
			 0, 0, BSE_PART_MAX_TICK - 1, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("duration", "Duration", "Selection Duration",
			 0, 0, BSE_PART_MAX_TICK, 384, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("min_note", "Minimum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
  *(in_pspecs++) = bse_pspec_note_simple ("max_note", "Maximum Selection Note", NULL,
				 SFI_PARAM_DEFAULT);
}
#line 470 "bsepart.proc"
  proc->help = "Deselect all notes within rectangle.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 482 "bsepart.proc"
 }
static BseErrorType
#line 482 "bsepart.proc"
deselect_rectangle_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 485 "bsepart.proc"
{
#line 486 "bsepart.proc"
  
  BsePart *self   = bse_value_get_object (in_values++);
  guint tick      = sfi_value_get_int (in_values++);
  guint duration  = sfi_value_get_int (in_values++);
  gint  min_note  = sfi_value_get_note (in_values++);
  gint  max_note  = sfi_value_get_note (in_values++);
  
#line 493 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  bse_part_deselect_rectangle (self, tick, duration, min_note, max_note);
  
  return BSE_ERROR_NONE;
}

/* --- select-event --- */
static GType type_id_select_event = 0;
static void
select_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 502 "bsepart.proc"
 {
#line 504 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
}
#line 503 "bsepart.proc"
  proc->help = "Select an existing event.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 509 "bsepart.proc"
 }
static BseErrorType
#line 509 "bsepart.proc"
select_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 512 "bsepart.proc"
{
#line 513 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean id_valid;
  
#line 518 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 522 "bsepart.proc"
  
  id_valid = bse_part_select_event (self, id);
  
  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- deselect-event --- */
static GType type_id_deselect_event = 0;
static void
deselect_event_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 528 "bsepart.proc"
 {
#line 530 "bsepart.proc"
  *(in_pspecs++) = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++) = sfi_pspec_int ("id", "ID", NULL,
			 0, 0, BSE_PART_MAX_TICK, 10, SFI_PARAM_DEFAULT);
}
#line 529 "bsepart.proc"
  proc->help = "Deselect an existing event.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 535 "bsepart.proc"
 }
static BseErrorType
#line 535 "bsepart.proc"
deselect_event_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 538 "bsepart.proc"
{
#line 539 "bsepart.proc"
  
  BsePart *self     = bse_value_get_object (in_values++);
  guint    id	    = sfi_value_get_int (in_values++);
  gboolean id_valid;
  
#line 544 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 548 "bsepart.proc"
  
  id_valid = bse_part_deselect_event (self, id);
  
  return id_valid ? BSE_ERROR_NONE : BSE_ERROR_PROC_PARAM_INVAL;
}

/* --- get-timing --- */
static GType type_id_get_timing = 0;
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 554 "bsepart.proc"
 {
#line 556 "bsepart.proc"
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL, BSE_TYPE_PART, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_DEFAULT);
#line 555 "bsepart.proc"
  proc->help = "Retrieve song timing information at a specific tick.";
#line 24 "bsepart.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 25 "bsepart.proc"
  proc->copyright = "Copyright (C) 2002 Tim Janik";
#line 559 "bsepart.proc"
}  }
static BseErrorType
#line 559 "bsepart.proc"
get_timing_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 562 "bsepart.proc"
{
#line 563 "bsepart.proc"
  
  BsePart *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseItem *parent;
  BseSongTiming timing = { 0, };

#line 569 "bsepart.proc"
  
  if (!BSE_IS_PART (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 573 "bsepart.proc"
  
  parent = BSE_ITEM (self)->parent;
  if (BSE_IS_SONG (parent))
    bse_song_get_timing (BSE_SONG (parent), tick, &timing);
  else
    bse_song_timing_get_default (&timing);

#line 580 "bsepart.proc"
  
  bse_value_set_boxed (out_values++, &timing);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
BSE_EXPORTS_BEGIN (BSE_PLUGIN_NAME);
BSE_EXPORT_PROCEDURES = {
  { &type_id_insert_note, "BsePart+insert-note", NULL, 0, insert_note_setup, insert_note_exec, NULL, "/Method/BsePart/General/Insert Note", { 0, }, },
  { &type_id_change_note, "BsePart+change-note", NULL, 0, change_note_setup, change_note_exec, NULL, "/Method/BsePart/General/Change Note", { 0, }, },
  { &type_id_delete_event, "BsePart+delete-event", NULL, 0, delete_event_setup, delete_event_exec, NULL, "/Method/BsePart/General/Delete Event", { 0, }, },
  { &type_id_is_selected_event, "BsePart+is-selected-event", NULL, 0, is_selected_event_setup, is_selected_event_exec, NULL, "/Method/BsePart/General/Is Selected Event", { 0, }, },
  { &type_id_list_notes_crossing, "BsePart+list-notes-crossing", NULL, 0, list_notes_crossing_setup, list_notes_crossing_exec, NULL, "/Method/BsePart/General/List Notes Crossing", { 0, }, },
  { &type_id_queue_notes_within, "BsePart+queue-notes-within", NULL, 0, queue_notes_within_setup, queue_notes_within_exec, NULL, "/Method/BsePart/General/Queue Notes Within", { 0, }, },
  { &type_id_list_selected_notes, "BsePart+list-selected-notes", NULL, 0, list_selected_notes_setup, list_selected_notes_exec, NULL, "/Method/BsePart/General/List Selected Notes", { 0, }, },
  { &type_id_check_overlap, "BsePart+check-overlap", NULL, 0, check_overlap_setup, check_overlap_exec, NULL, "/Method/BsePart/General/Check Overlap", { 0, }, },
  { &type_id_get_notes, "BsePart+get-notes", NULL, 0, get_notes_setup, get_notes_exec, NULL, "/Method/BsePart/General/Get Notes", { 0, }, },
  { &type_id_get_min_note, "BsePart+get-min-note", NULL, 0, get_min_note_setup, get_min_note_exec, NULL, "/Method/BsePart/General/Get Min Note", { 0, }, },
  { &type_id_get_max_note, "BsePart+get-max-note", NULL, 0, get_max_note_setup, get_max_note_exec, NULL, "/Method/BsePart/General/Get Max Note", { 0, }, },
  { &type_id_get_max_tick, "BsePart+get-max-tick", NULL, 0, get_max_tick_setup, get_max_tick_exec, NULL, "/Method/BsePart/General/Get Max Tick", { 0, }, },
  { &type_id_select_rectangle_exclusive, "BsePart+select-rectangle-exclusive", NULL, 0, select_rectangle_exclusive_setup, select_rectangle_exclusive_exec, NULL, "/Method/BsePart/General/Select Rectangle Exclusive", { 0, }, },
  { &type_id_select_rectangle, "BsePart+select-rectangle", NULL, 0, select_rectangle_setup, select_rectangle_exec, NULL, "/Method/BsePart/General/Select Rectangle", { 0, }, },
  { &type_id_deselect_rectangle, "BsePart+deselect-rectangle", NULL, 0, deselect_rectangle_setup, deselect_rectangle_exec, NULL, "/Method/BsePart/General/Deselect Rectangle", { 0, }, },
  { &type_id_select_event, "BsePart+select-event", NULL, 0, select_event_setup, select_event_exec, NULL, "/Method/BsePart/General/Select Event", { 0, }, },
  { &type_id_deselect_event, "BsePart+deselect-event", NULL, 0, deselect_event_setup, deselect_event_exec, NULL, "/Method/BsePart/General/Deselect Event", { 0, }, },
  { &type_id_get_timing, "BsePart+get-timing", NULL, 0, get_timing_setup, get_timing_exec, NULL, "/Method/BsePart/General/Get Timing", { 0, }, },
  { NULL, },
};
BSE_EXPORTS_END;

/**
 ** Generated data ends here
 **/
