
/*-------- begin ../sfi/bse-plugin-generator generated code --------*/



#include <bse/bsecxxplugin.h>

namespace Bse {

/* class prototypes */
class BalanceBase;
class Balance;

/* choice/enum types */

/* classes */
class BalanceBase : public ::Bse::Effect {
#define BSE_TYPE_BALANCE (BSE_CXX_DECLARED_CLASS_TYPE (Balance))
  template<bool> static inline const unsigned char* pixstream();
public:
  static inline const unsigned char* pixstream () { return pixstream<true>(); }
  static inline const char* category  () { return "/Modules/Spatial/Balance"; }
  static inline const char* blurb     () { return "BseBalance is a stereo panning module with two audio and two control inputs, each of which can be seperately level adjusted. The resulting output balance is controlled by a balance adjustment and the sum of the control inputs. To avoid aliasing artefacts for rapid balance changes, the control signal is preprocessed by a simple lowpass filter with adjustable cutoff frequency."; }
  static inline const char* type_name () { return "BseBalance"; }
public:
  enum {
    ICHANNEL_AUDIO_IN1,
    ICHANNEL_AUDIO_IN2,
    ICHANNEL_CTRL_IN1,
    ICHANNEL_CTRL_IN2,
    N_ICHANNELS
  };
  enum {
    OCHANNEL_LEFT_OUT,
    OCHANNEL_MIX_OUT,
    OCHANNEL_RIGHT_OUT,
    N_OCHANNELS
  };
  /* "transport" structure to configure synthesis modules from properties */
  struct BalanceProperties {
    SfiReal alevel1;
    SfiReal alevel2;
    SfiReal abalance;
    SfiReal clevel1;
    SfiReal clevel2;
    SfiReal cbalance;
    SfiReal ostrength;
    SfiReal lowpass;
    SfiReal obalance;
    explicit BalanceProperties (BalanceBase *p) :
      alevel1 (p->alevel1),
      alevel2 (p->alevel2),
      abalance (p->abalance),
      clevel1 (p->clevel1),
      clevel2 (p->clevel2),
      cbalance (p->cbalance),
      ostrength (p->ostrength),
      lowpass (p->lowpass),
      obalance (p->obalance)
    {
    }
  };
protected:
  SfiReal alevel1;
  SfiReal alevel2;
  SfiReal abalance;
  SfiReal clevel1;
  SfiReal clevel2;
  SfiReal cbalance;
  SfiReal ostrength;
  SfiReal lowpass;
  SfiReal obalance;
protected:
  enum BalancePropertyID {
    PROP_ALEVEL1 = 1,
    PROP_ALEVEL2,
    PROP_ABALANCE,
    PROP_CLEVEL1,
    PROP_CLEVEL2,
    PROP_CBALANCE,
    PROP_OSTRENGTH,
    PROP_LOWPASS,
    PROP_OBALANCE,
  };
public:
  void set_property (guint prop_id, const ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ALEVEL1:
      alevel1 = sfi_value_get_real (&value);
    break;
    case PROP_ALEVEL2:
      alevel2 = sfi_value_get_real (&value);
    break;
    case PROP_ABALANCE:
      abalance = sfi_value_get_real (&value);
    break;
    case PROP_CLEVEL1:
      clevel1 = sfi_value_get_real (&value);
    break;
    case PROP_CLEVEL2:
      clevel2 = sfi_value_get_real (&value);
    break;
    case PROP_CBALANCE:
      cbalance = sfi_value_get_real (&value);
    break;
    case PROP_OSTRENGTH:
      ostrength = sfi_value_get_real (&value);
    break;
    case PROP_LOWPASS:
      lowpass = sfi_value_get_real (&value);
    break;
    case PROP_OBALANCE:
      obalance = sfi_value_get_real (&value);
    break;
    };
    property_changed ((BalancePropertyID) prop_id);
    update_modules();
    switch (prop_id) {
    default: ;
    };
  }
  void get_property (guint prop_id, ::Bse::Value &value, GParamSpec *pspec)
  {
    switch (prop_id) {
    case PROP_ALEVEL1:
      sfi_value_set_real (&value, alevel1);
    break;
    case PROP_ALEVEL2:
      sfi_value_set_real (&value, alevel2);
    break;
    case PROP_ABALANCE:
      sfi_value_set_real (&value, abalance);
    break;
    case PROP_CLEVEL1:
      sfi_value_set_real (&value, clevel1);
    break;
    case PROP_CLEVEL2:
      sfi_value_set_real (&value, clevel2);
    break;
    case PROP_CBALANCE:
      sfi_value_set_real (&value, cbalance);
    break;
    case PROP_OSTRENGTH:
      sfi_value_set_real (&value, ostrength);
    break;
    case PROP_LOWPASS:
      sfi_value_set_real (&value, lowpass);
    break;
    case PROP_OBALANCE:
      sfi_value_set_real (&value, obalance);
    break;
    };
  }
private:
  static struct StaticData {
    int dummy;
  } static_data;
protected:
  virtual void property_changed (BalancePropertyID) {}
  virtual ~BalanceBase ()
  {
  }
public:
  static void class_init (::Bse::CxxBaseClass *klass)
  {
    klass->add (PROP_ALEVEL1, sfidl_pspec_Perc ("Audio Input","alevel1","Input 1 [%]" , "Attenuate the level of audio input 1" , 100 , ":r:w:G:S:"));
    klass->add (PROP_ALEVEL2, sfidl_pspec_Perc ("Audio Input","alevel2","Input 2 [%]" , "Attenuate the level of audio input 2" , 100 , ":r:w:G:S:"));
    klass->add (PROP_ABALANCE, sfidl_pspec_Balance ("Audio Input","abalance","Balance" , "Balance audio input levels" , 0 , ":r:w:G:"));
    klass->add (PROP_CLEVEL1, sfidl_pspec_Perc ("Control Input","clevel1","Input 1 [%]" , "Attenuate the level of control input 1" , 100 , ":r:w:G:S:"));
    klass->add (PROP_CLEVEL2, sfidl_pspec_Perc ("Control Input","clevel2","Input 2 [%]" , "Attenuate the level of control input 2" , 100 , ":r:w:G:S:"));
    klass->add (PROP_CBALANCE, sfidl_pspec_Balance ("Control Input","cbalance","Balance" , "Balance control input levels" , 0 , ":r:w:G:"));
    klass->add (PROP_OSTRENGTH, sfidl_pspec_Perc ("Output Panning","ostrength","Control Strength" , "Adjust how much the control signals affect the output balance" , 100 , ":r:w:G:S:"));
    klass->add (PROP_LOWPASS, sfidl_pspec_Frequency ("Output Panning","lowpass","Lowpass [Hz]" , "Lowpass filter frequency for the control signal" , 100 , 100 , 1000 , ":r:w:G:S:"));
    klass->add (PROP_OBALANCE, sfidl_pspec_Balance ("Output Panning","obalance","Output Balance" , "Adjust output balance between left and right" , 0 , ":r:w:G:S:"));
    klass->add_ichannel ("Audio In1", "First audio input", ICHANNEL_AUDIO_IN1);
    klass->add_ichannel ("Audio In2", "Second audio input", ICHANNEL_AUDIO_IN2);
    klass->add_ichannel ("Ctrl In1", "First control input", ICHANNEL_CTRL_IN1);
    klass->add_ichannel ("Ctrl In2", "Second control input", ICHANNEL_CTRL_IN2);
    klass->add_ochannel ("Left Out", "Left audio output", OCHANNEL_LEFT_OUT);
    klass->add_ochannel ("Mix Out", "Mixed audio output", OCHANNEL_MIX_OUT);
    klass->add_ochannel ("Right Out", "Right audio output", OCHANNEL_RIGHT_OUT);
  }
};
BSE_CXX_DECLARE_CLASS (Balance);


template<bool> const unsigned char*
BalanceBase::pixstream()
{
  /* GdkPixbuf RGBA C-Source image dump 1-byte-run-length-encoded */

#ifdef __SUNPRO_C
#pragma align 4 (local_pixstream)
#endif
#ifdef __GNUC__
static const guint8 local_pixstream[] __attribute__ ((__aligned__ (4))) = 
#else
static const guint8 local_pixstream[] = 
#endif
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (2323) */
  "\0\0\11+"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (256) */
  "\0\0\1\0"
  /* width (64) */
  "\0\0\0@"
  /* height (64) */
  "\0\0\0@"
  /* pixel_data: */
  "\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\212\0\0\0\0\1\0\0\0"
  "\377\262\0\0\0\0\1\0\0\0\377\214\0\0\0\0\202\0\0\0\377\260\0\0\0\0\202"
  "\0\0\0\377\214\0\0\0\0\203\0\0\0\377\256\0\0\0\0\203\0\0\0\377\214\0"
  "\0\0\0\204\0\0\0\377\254\0\0\0\0\204\0\0\0\377\214\0\0\0\0\205\0\0\0"
  "\377\252\0\0\0\0\205\0\0\0\377\214\0\0\0\0\203\0\0\0\377\1\276\32""4"
  "\377\202\0\0\0\377\250\0\0\0\0\202\0\0\0\377\1l&\226\377\203\0\0\0\377"
  "\214\0\0\0\0\203\0\0\0\377\2\275\32""6\377\273\33""8\377\202\0\0\0\377"
  "\246\0\0\0\0\202\0\0\0\377\2l&\226\377j&\230\377\203\0\0\0\377\214\0"
  "\0\0\0\203\0\0\0\377\3\273\33""8\377\272\33:\377\270\33<\377\202\0\0"
  "\0\377\244\0\0\0\0\202\0\0\0\377\3l&\225\377k&\227\377i'\231\377\203"
  "\0\0\0\377\214\0\0\0\0\203\0\0\0\377\4\272\33""9\377\270\33<\377\266"
  "\33>\377\264\34@\377\202\0\0\0\377\242\0\0\0\0\202\0\0\0\377\4m&\225"
  "\377k&\227\377i&\231\377g'\233\377\203\0\0\0\377\214\0\0\0\0\205\0\0"
  "\0\377\3\265\34\77\377\263\34B\377\261\34D\377\202\0\0\0\377\240\0\0"
  "\0\0\202\0\0\0\377\3m&\224\377k&\226\377j&\230\377\205\0\0\0\377\214"
  "\0\0\0\0\207\0\0\0\377\2\260\34E\377\256\35H\377\207\0\0\0\377\224\0"
  "\0\0\0\207\0\0\0\377\2n&\224\377l&\226\377\207\0\0\0\377\214\0\0\0\0"
  "\220\0\0\0\377\224\0\0\0\0\220\0\0\0\377\214\0\0\0\0\203\0\0\0\377\2"
  "\264\34@\377\262\34B\377\213\0\0\0\377\224\0\0\0\0\213\0\0\0\377\2d'"
  "\240\377b(\242\377\203\0\0\0\377\214\0\0\0\0\203\0\0\0\377\4\263\34B"
  "\377\261\34D\377\257\34F\377\255\35H\377\205\0\0\0\377\202\233\222+\377"
  "\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202\233\222+\377\205\0\0\0\377"
  "\4f'\235\377d'\237\377b'\241\377`(\243\377\203\0\0\0\377\214\0\0\0\0"
  "\203\0\0\0\377\6\261\34D\377\260\34F\377\256\35H\377\254\35J\377\252"
  "\35L\377\250\35N\377\203\0\0\0\377\202\233\222+\377\202\0\0\0\377\224"
  "\0\0\0\0\202\0\0\0\377\202\233\222+\377\203\0\0\0\377\6h'\232\377f'\235"
  "\377d'\237\377b'\241\377a(\243\377_(\245\377\203\0\0\0\377\214\0\0\0"
  "\0\203\0\0\0\377\6\260\34E\377\256\34G\377\254\35J\377\252\35L\377\251"
  "\35N\377\247\36P\377\203\0\0\0\377\202\233\222+\377\202\0\0\0\377\224"
  "\0\0\0\0\202\0\0\0\377\202\233\222+\377\203\0\0\0\377\6g'\234\377e'\236"
  "\377c'\240\377a(\243\377_(\245\377](\247\377\203\0\0\0\377\214\0\0\0"
  "\0\214\0\0\0\377\202\233\222+\377\202\0\0\0\377\224\0\0\0\0\202\0\0\0"
  "\377\202\233\222+\377\214\0\0\0\377\214\0\0\0\0\214\0\0\0\377\202\233"
  "\222+\377\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202\233\222+\377\214"
  "\0\0\0\377\214\0\0\0\0\214\0\0\0\377\202\233\222+\377\202\0\0\0\377\224"
  "\0\0\0\0\202\0\0\0\377\202\233\222+\377\214\0\0\0\377\214\0\0\0\0\214"
  "\0\0\0\377\202\233\222+\377\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202"
  "\233\222+\377\214\0\0\0\377\214\0\0\0\0\203\0\0\0\377\6\251\35N\377\247"
  "\36P\377\245\36R\377\243\36T\377\241\36V\377\240\37Y\377\203\0\0\0\377"
  "\202\233\222+\377\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202\233\222"
  "+\377\203\0\0\0\377\6_(\244\377^(\247\377\\(\251\377Z)\253\377X)\255"
  "\377V)\257\377\203\0\0\0\377\214\0\0\0\0\203\0\0\0\377\6\247\35O\377"
  "\246\36R\377\244\36T\377\242\36V\377\240\37X\377\236\37Z\377\203\0\0"
  "\0\377\202\233\222+\377\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202\233"
  "\222+\377\203\0\0\0\377\6^(\246\377\\(\250\377Z)\252\377Y)\255\377W)"
  "\257\377U)\261\377\203\0\0\0\377\214\0\0\0\0\203\0\0\0\377\4\246\36Q"
  "\377\244\36S\377\242\36U\377\240\36X\377\205\0\0\0\377\202\233\222+\377"
  "\202\0\0\0\377\224\0\0\0\0\202\0\0\0\377\202\233\222+\377\205\0\0\0\377"
  "\4Y)\254\377W)\256\377U)\261\377S*\263\377\203\0\0\0\377\214\0\0\0\0"
  "\203\0\0\0\377\2\245\36S\377\243\36U\377\213\0\0\0\377\224\0\0\0\0\213"
  "\0\0\0\377\2T*\262\377R*\264\377\203\0\0\0\377\214\0\0\0\0\220\0\0\0"
  "\377\224\0\0\0\0\220\0\0\0\377\214\0\0\0\0\207\0\0\0\377\2\232\37_\377"
  "\231\40a\377\207\0\0\0\377\224\0\0\0\0\207\0\0\0\377\2X)\255\377V)\257"
  "\377\207\0\0\0\377\214\0\0\0\0\205\0\0\0\377\3\235\37\\\377\233\37^\377"
  "\231\40`\377\202\0\0\0\377\240\0\0\0\0\202\0\0\0\377\3U)\261\377S*\263"
  "\377Q*\265\377\205\0\0\0\377\214\0\0\0\0\203\0\0\0\377\4\237\37Z\377"
  "\235\37\\\377\233\37^\377\231\37`\377\202\0\0\0\377\242\0\0\0\0\202\0"
  "\0\0\377\4R*\265\377P*\267\377N*\271\377L+\273\377\203\0\0\0\377\214"
  "\0\0\0\0\203\0\0\0\377\3\235\37[\377\234\37]\377\232\37`\377\202\0\0"
  "\0\377\244\0\0\0\0\202\0\0\0\377\3O*\270\377M+\273\377K+\275\377\203"
  "\0\0\0\377\214\0\0\0\0\203\0\0\0\377\2\234\37]\377\232\37_\377\202\0"
  "\0\0\377\246\0\0\0\0\202\0\0\0\377\2K+\274\377I+\276\377\203\0\0\0\377"
  "\214\0\0\0\0\203\0\0\0\377\1\233\37_\377\202\0\0\0\377\250\0\0\0\0\202"
  "\0\0\0\377\1H+\300\377\203\0\0\0\377\214\0\0\0\0\205\0\0\0\377\252\0"
  "\0\0\0\205\0\0\0\377\214\0\0\0\0\204\0\0\0\377\254\0\0\0\0\204\0\0\0"
  "\377\214\0\0\0\0\203\0\0\0\377\256\0\0\0\0\203\0\0\0\377\214\0\0\0\0"
  "\202\0\0\0\377\260\0\0\0\0\202\0\0\0\377\214\0\0\0\0\1\0\0\0\377\262"
  "\0\0\0\0\1\0\0\0\377\377\0\0\0\0\377\0\0\0\0\377\0\0\0\0\220\0\0\0\0"
  "\262\0\0\0\377\216\0\0\0\0\262\0\0\0\377\216\0\0\0\0\203\0\0\0\377\17"
  "\205\"x\377\203#{\377\201#}\377\177#\177\377}$\201\377|$\203\377z$\205"
  "\377x$\210\377v%\212\377t%\214\377r%\216\377q%\220\377o&\222\377m&\225"
  "\377k&\227\377\204\0\0\0\377\206\321\253\317\377\204\0\0\0\377\15P*\267"
  "\377N*\271\377L+\274\377J+\276\377H+\300\377F+\302\377E,\304\377C,\306"
  "\377A,\311\377\77-\313\377=-\315\377;-\317\377:-\321\377\2029-\322\377"
  "\203\0\0\0\377\216\0\0\0\0\203\0\0\0\377\15\203#z\377\201#|\377\200#"
  "~\377~#\201\377|$\203\377z$\205\377x$\207\377v%\211\377u%\213\377s%\216"
  "\377q%\220\377o&\222\377m&\224\377\204\0\0\0\377\212\321\253\317\377"
  "\204\0\0\0\377\12J+\275\377I+\277\377G+\302\377E,\304\377C,\306\377A"
  ",\310\377\77,\312\377>-\314\377<-\317\377:-\321\377\2039-\322\377\203"
  "\0\0\0\377\216\0\0\0\0\203\0\0\0\377\15\202#|\377\200#~\377~#\200\377"
  "|$\202\377{$\204\377y$\207\377w$\211\377u%\213\377s%\215\377q%\217\377"
  "p&\221\377n&\224\377l&\226\377\204\0\0\0\377\212\321\253\317\377\204"
  "\0\0\0\377\11I+\277\377G+\301\377E,\303\377D,\305\377B,\310\377@,\312"
  "\377>-\314\377<-\316\377:-\320\377\2049-\322\377\203\0\0\0\377\216\0"
  "\0\0\0\203\0\0\0\377\17\200#}\377\177#\200\377}$\202\377{$\204\377y$"
  "\206\377w$\210\377u%\212\377t%\215\377r%\217\377p%\221\377n&\223\377"
  "l&\225\377j&\227\377i'\232\377g'\234\377\204\0\0\0\377\206\321\253\317"
  "\377\204\0\0\0\377\12K+\274\377I+\276\377H+\301\377F,\303\377D,\305\377"
  "B,\307\377@,\311\377>-\314\377=-\316\377;-\320\377\2059-\322\377\203"
  "\0\0\0\377\216\0\0\0\0\262\0\0\0\377\216\0\0\0\0\262\0\0\0\377\377\0"
  "\0\0\0\377\0\0\0\0\377\0\0\0\0\212\0\0\0\0"};



  return local_pixstream;
}

}; /* Bse */


/*-------- end ../sfi/bse-plugin-generator generated code --------*/


