---
title: Modules
---

These add-on modules are available from other developers; follow the links for more information. If you've developed a module you would like to share with others, feel free to [add a link](https://github.com/premake/premake-core/edit/master/website/community/modules.md) to the list!

## IDE Modules

* [Android Studio](https://github.com/polymonster/premake-android-studio) : Generate .gradle and CMakeLists for Android Studio
* [Code::Blocks](https://github.com/chris-be/premake-codeblocks) : [Code::Blocks](http://www.codeblocks.org/) support
* [Eclipse](https://github.com/premake/premake-eclipse) : [Eclipse](http://www.eclipse.org) support
* [NetBeans](https://github.com/TurkeyMan/premake-netbeans) : [NetBeans](https://netbeans.org) support
* [SlickEdit](https://github.com/TurkeyMan/premake-slickedit) : [SlickEdit](http://www.slickedit.com) support
* [qmake](https://github.com/Gaztin/premake-qmake) : [QtCreator](https://doc.qt.io/qtcreator/creator-overview.html) and [qmake](http://doc.qt.io/qt-5/qmake-manual.html) support

## Platform Modules

* [Android.mk](https://github.com/Meoo/premake-androidmk) : Generator for Android NDK's [ndk-build system](https://developer.android.com/ndk/guides/build.html)
* [Emscripten](https://github.com/tritao/premake-emscripten) : [Emscripten](http://kripken.github.io/emscripten-site/) support
* [NaCL](https://github.com/TurkeyMan/premake-nacl) : [Google Native Client](https://developer.chrome.com/native-client) support
* [VSLinux](https://github.com/LORgames/premake-vslinux) : [VSLinux](https://visualstudiogallery.msdn.microsoft.com/725025cf-7067-45c2-8d01-1e0fd359ae6e) support
* [VS-Tool](https://github.com/TurkeyMan/premake-vstool) : GCC and Clang toolset Visual Studio support via [vs-tool](https://github.com/juj/vs-tool)
* [WinRT](https://github.com/LORgames/premake-winrt) : Windows Runtime support
* [Xbox 360](https://github.com/redorav/premake-xbox360) : Xbox 360 support

## Build System Modules

* [CMake](https://github.com/Jarod42/premake-cmake) : CMakeLists exporter for premake
* [Ninja](https://github.com/jimon/premake-ninja) : [Ninja](https://github.com/martine/ninja) support

## Tool Modules

* [Autoconf](https://github.com/Blizzard/premake-autoconf) : Autoconf tools for premake
* [CompilationUnit](https://github.com/dcourtois/premake-compilationunit) : [Single compilation unit](https://en.wikipedia.org/wiki/Single_Compilation_Unit) support
* [Export](https://github.com/Meoo/premake-export) : premake usage/export module
* [Generate compile_commands.json](https://github.com/tarruda/premake-export-compile-commands) : Export clang compilation database
* [Generate compile_commands.json](https://github.com/MattBystrin/premake-ecc) : Alternative exporter for clang compilation database
* [Pkgconfig](https://github.com/tarruda/premake-pkgconfig) : Pure lua implementation of pkgconfig for premake
* [Platform test](https://github.com/tarruda/premake-platform-test) : Perform platform checks in your premake configuration

## Library Modules

* [CUDA](https://github.com/theComputeKid/premake5-cuda) : Enables CUDA development in Visual Studio using the native CUDA Toolkit integration and with nvcc on Linux
* [Qt](https://github.com/dcourtois/premake-qt) : [Qt](https://www.qt.io) support
* [WIX](https://github.com/mikisch81/premake-wix) : Premake extension to support [WIX](http://wixtoolset.org/) project files on Visual Studio
