"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cffOptimizeDrawCall = exports.DrawCallOmit = exports.DrawCallOptimizationPass = exports.argIsZero = void 0;
function argIsZero(x) {
    if (typeof x === "number")
        return x === 0;
    else
        return x.isZero();
}
exports.argIsZero = argIsZero;
class DrawCallOptimizationPass {
    constructor(ctx) {
        this.ctx = ctx;
        this.state = null;
    }
    *update(dc) {
        if (this.state) {
            const s1Merge = this.tryUpdateState(this.state, dc);
            if (s1Merge) {
                this.state = s1Merge;
                return;
            }
            else {
                yield* this.doFlush(this.state);
            }
        }
        this.state = this.tryInitState(dc);
        if (!this.state)
            yield dc;
    }
    *end() {
        if (this.state)
            yield* this.doFlush(this.state);
    }
}
exports.DrawCallOptimizationPass = DrawCallOptimizationPass;
class DrawCallOmit extends DrawCallOptimizationPass {
    doFlush() {
        return [];
    }
    tryInitState(dc) {
        if (this.match(dc)) {
            return true;
        }
        else {
            return null;
        }
    }
    tryUpdateState() {
        return null;
    }
}
exports.DrawCallOmit = DrawCallOmit;
function* optimizePass(dcSeq, pass) {
    for (const dc of dcSeq) {
        yield* pass.update(dc);
    }
    yield* pass.end();
}
function* cffOptimizeDrawCall(dcSeq, passes) {
    if (!passes.length) {
        yield* dcSeq;
    }
    else {
        const last = passes[passes.length - 1];
        const front = passes.slice(0, passes.length - 1);
        yield* optimizePass(cffOptimizeDrawCall(dcSeq, front), last);
    }
}
exports.cffOptimizeDrawCall = cffOptimizeDrawCall;
//# sourceMappingURL=general.js.map