"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.Tag = void 0;
exports.Tag = "maxp";
class Table {
    constructor(version) {
        this.version = version;
        this.numGlyphs = 0; // VOLATILE (somehow)
        this.maxPoints = 0; // VOLATILE
        this.maxContours = 0; // VOLATILE
        this.maxCompositePoints = 0; // VOLATILE
        this.maxCompositeContours = 0; // VOLATILE
        this.maxZones = 0;
        this.maxTwilightPoints = 0;
        this.maxStorage = 0;
        this.maxFunctionDefs = 0;
        this.maxInstructionDefs = 0;
        this.maxStackElements = 0;
        this.maxSizeOfInstructions = 0; // VOLATILE
        this.maxComponentElements = 0; // VOLATILE
        this.maxComponentDepth = 0; // VOLATILE
    }
    static FromVersion(version) {
        return new Table(version);
    }
    static TrueType() {
        return new Table(0x10000);
    }
    static Cff() {
        return new Table(0x5000);
    }
}
exports.Table = Table;
//# sourceMappingURL=maxp.js.map