"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformShape = exports.transformPointXY = exports.transformPoint = exports.CompositeTransform = exports.LinearTransform = void 0;
const point_1 = require("../point/point");
const arcs_1 = require("./arcs");
class LinearTransform {
    constructor(xx, xy, yx, yy, x, y) {
        this.xx = xx;
        this.xy = xy;
        this.yx = yx;
        this.yy = yy;
        this.tx = x;
        this.ty = y;
    }
    x(x, y) {
        return x * this.xx + y * this.xy + this.tx;
    }
    y(x, y) {
        return x * this.yx + y * this.yy + this.ty;
    }
    dxx(x, y) {
        return this.xx;
    }
    dxy(x, y) {
        return this.xy;
    }
    dyx(x, y) {
        return this.yx;
    }
    dyy(x, y) {
        return this.yy;
    }
    inverse() {
        const denom = this.xx * this.yy - this.yx * this.xy;
        return new LinearTransform(this.yy / denom, -this.xy / denom, -this.yx / denom, this.xx / denom, -(this.tx * this.yy - this.ty * this.xy) / denom, -(-this.tx * this.yx + this.ty * this.xx) / denom);
    }
}
exports.LinearTransform = LinearTransform;
LinearTransform.neutral = new LinearTransform(1, 0, 0, 1, 0, 0);
class CompositeTransform {
    constructor(a, b) {
        this.a = a;
        this.b = b;
    }
    x(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.x(x1, y1);
    }
    y(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.y(x1, y1);
    }
    dxx(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.dxx(x1, y1) * this.a.dxx(x, y) + this.b.dxy(x1, y1) * this.a.dyx(x, y);
    }
    dxy(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.dxx(x1, y1) * this.a.dxy(x, y) + this.b.dxy(x1, y1) * this.a.dyy(x, y);
    }
    dyx(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.dyx(x1, y1) * this.a.dxx(x, y) + this.b.dyy(x1, y1) * this.a.dyx(x, y);
    }
    dyy(x, y) {
        const x1 = this.a.x(x, y);
        const y1 = this.a.y(x, y);
        return this.b.dyx(x1, y1) * this.a.dxy(x, y) + this.b.dyy(x1, y1) * this.a.dyy(x, y);
    }
    static from(a, b) {
        if (a === LinearTransform.neutral)
            return b;
        if (b === LinearTransform.neutral)
            return a;
        return new CompositeTransform(a, b);
    }
}
exports.CompositeTransform = CompositeTransform;
function transformPoint(t, z) {
    return new point_1.Point2(t.x(z.x, z.y), t.y(z.x, z.y));
}
exports.transformPoint = transformPoint;
function transformPointXY(t, x, y) {
    return new point_1.Point2(t.x(x, y), t.y(x, y));
}
exports.transformPointXY = transformPointXY;
function transformShape(sh, tfm) {
    let out = [];
    for (let j = 0; j < sh.length; j++) {
        const c = sh[j];
        const contour = [];
        for (let k = 0; k < c.length; k++) {
            contour[k] = new arcs_1.Transformed(c[k], tfm);
        }
        out[j] = contour;
    }
    return out;
}
exports.transformShape = transformShape;
