<!-- BEGIN Section-Package-List -->
<!-- THIS SECTION IS AUTOMATICALLY GENERATED. DO NOT EDIT. -->

# Package list of Release 34.1.0
## Prebuilt Packages

Iosevka provides a large variety of variants. Prebuilt variants are listed below. For all Monospace variants' packages, it will contain three _spacing variants_. You can either download the package containing all the spacing variants (recommended), or cherry-pick the variant with specific spacing.
  - _Default_: The default variant with ligatures. Various symbols, like arrows and geometric, are wide (2-column).
  - _Terminal_ (“Term”)：A narrower variant focusing terminal uses. Arrows and geometric symbols will be narrow to follow typical terminal usages.
  - _Fixed_: Exact monospace font without ligatures and wide glyphs. Since some environments cannot interpret Iosevka or Iosevka Term as monospace, and have difficulties with ligatures included, you can use Iosevka Fixed as an alternative.

## Packaging Formats

Iosevka provides various packaging formats, here is the list of them:

| Option         | Contents                                            | Description                                                  |
| -------------- | --------------------------------------------------- | ------------------------------------------------------------ |
| Super TTC | 1 `.ttc` file                                       | Bundles all fonts in the scope together into a single file. It is the recommended way to install fonts for Desktop usage, if your operating system is updated to date. Package files with `-sgr-` infix in the filename only contains fonts for one single group (variant and spacing). |
| TTC            | 9 `.ttc` files                                      | Each TTC file bundles fonts with the same weight together.  Package files with `-sgr-` infix in the filename only contains fonts for one single group (variant and spacing).   |
| TTF            | 54 `.ttf` files                                     | Each TTF file contains one font for a specific weight, width, slope and spacing variant. This option is ideal for embedding Iosevka into applications, or for desktop usage if TTC options have compatibility issues.<br/>TTF packages also provide *unhinted* version which removes [hints](https://en.wikipedia.org/wiki/Font_hinting), which reduced file size, but will be less clear on certain platforms. |
| WebFont        | 1 `.css` file + 54 `.woff2` files + 54 `.ttf` files | Contains contents required to use Iosevka on websites.       |


<table>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka</b> — <i>Monospace, Default</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-Iosevka-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-Iosevka-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-Iosevka-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-Iosevka-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Iosevka-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-Iosevka-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Iosevka-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-Iosevka-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTerm-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTerm-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTerm-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTerm-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTerm-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTerm-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixed-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixed-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixed-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixed-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixed-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixed-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-Iosevka.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-Iosevka.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Slab</b> — <i>Monospace, Slab-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSlab-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSlab-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Slab</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Slab</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Slab</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSlab.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSlab.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Curly</b> — <i>Monospace, Curly Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaCurly-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaCurly-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Curly</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaCurly-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaCurly-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaCurly-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaCurly-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaCurly-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaCurly-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Curly</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermCurly-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermCurly-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermCurly-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermCurly-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermCurly-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermCurly-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Curly</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedCurly-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedCurly-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedCurly-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedCurly-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedCurly-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedCurly-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaCurly.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaCurly.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Curly Slab</b> — <i>Monospace, Curly Style, Slab-serif</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaCurlySlab-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaCurlySlab-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Curly Slab</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaCurlySlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaCurlySlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaCurlySlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaCurlySlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaCurlySlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaCurlySlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term Curly Slab</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermCurlySlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermCurlySlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermCurlySlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermCurlySlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermCurlySlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermCurlySlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed Curly Slab</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedCurlySlab-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedCurlySlab-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedCurlySlab-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedCurlySlab-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedCurlySlab-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedCurlySlab-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaCurlySlab.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaCurlySlab.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS01</b> — <i>Monospace, Andale Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS01-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS01-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS01</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS01-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS01-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS01-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS01-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS01-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS01-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS01</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS01-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS01-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS01-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS01-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS01-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS01-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS01</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS01-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS01-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS01-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS01-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS01-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS01-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS01.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS01.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS02</b> — <i>Monospace, Anonymous Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS02-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS02-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS02</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS02-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS02-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS02-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS02-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS02-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS02-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS02</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS02-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS02-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS02-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS02-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS02-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS02-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS02</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS02-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS02-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS02-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS02-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS02-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS02-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS02.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS02.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS03</b> — <i>Monospace, Consolas Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS03-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS03-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS03</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS03-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS03-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS03-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS03-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS03-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS03-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS03</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS03-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS03-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS03-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS03-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS03-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS03-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS03</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS03-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS03-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS03-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS03-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS03-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS03-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS03.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS03.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS04</b> — <i>Monospace, Menlo Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS04-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS04-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS04</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS04-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS04-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS04-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS04-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS04-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS04-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS04</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS04-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS04-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS04-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS04-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS04-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS04-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS04</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS04-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS04-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS04-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS04-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS04-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS04-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS04.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS04.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS05</b> — <i>Monospace, Fira Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS05-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS05-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS05</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS05-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS05-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS05-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS05-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS05-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS05-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS05</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS05-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS05-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS05-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS05-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS05-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS05-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS05</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS05-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS05-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS05-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS05-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS05-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS05-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS05.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS05.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS06</b> — <i>Monospace, Liberation Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS06-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS06-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS06</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS06-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS06-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS06-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS06-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS06-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS06-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS06</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS06-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS06-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS06-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS06-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS06-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS06-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS06</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS06-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS06-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS06-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS06-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS06-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS06-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS06.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS06.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS07</b> — <i>Monospace, Monaco Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS07-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS07-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS07</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS07-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS07-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS07-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS07-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS07-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS07-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS07</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS07-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS07-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS07-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS07-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS07-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS07-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS07</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS07-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS07-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS07-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS07-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS07-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS07-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS07.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS07.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS08</b> — <i>Monospace, Pragmata Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS08-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS08-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS08</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS08-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS08-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS08-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS08-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS08-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS08-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS08</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS08-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS08-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS08-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS08-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS08-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS08-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS08</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS08-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS08-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS08-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS08-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS08-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS08-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS08.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS08.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS09</b> — <i>Monospace, Source Code Pro Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS09-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS09-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS09</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS09-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS09-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS09-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS09-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS09-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS09-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS09</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS09-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS09-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS09-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS09-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS09-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS09-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS09</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS09-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS09-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS09-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS09-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS09-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS09-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS09.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS09.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS10</b> — <i>Monospace, Envy Code R Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS10-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS10-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS10</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS10-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS10-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS10-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS10-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS10-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS10-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS10</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS10-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS10-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS10-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS10-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS10-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS10-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS10</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS10-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS10-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS10-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS10-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS10-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS10-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS10.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS10.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS11</b> — <i>Monospace, X Windows Fixed Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS11-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS11-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS11</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS11-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS11-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS11-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS11-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS11-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS11-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS11</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS11-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS11-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS11-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS11-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS11-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS11-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS11</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS11-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS11-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS11-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS11-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS11-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS11-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS11.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS11.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS12</b> — <i>Monospace, Ubuntu Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS12-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS12-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS12</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS12-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS12-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS12-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS12-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS12-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS12-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS12</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS12-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS12-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS12-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS12-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS12-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS12-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS12</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS12-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS12-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS12-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS12-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS12-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS12-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS12.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS12.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS13</b> — <i>Monospace, Lucida Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS13-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS13-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS13</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS13-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS13-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS13-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS13-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS13-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS13-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS13</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS13-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS13-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS13-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS13-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS13-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS13-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS13</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS13-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS13-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS13-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS13-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS13-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS13-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS13.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS13.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS14</b> — <i>Monospace, JetBrains Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS14-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS14-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS14</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS14-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS14-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS14-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS14-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS14-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS14-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS14</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS14-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS14-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS14-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS14-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS14-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS14-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS14</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS14-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS14-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS14-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS14-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS14-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS14-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS14.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS14.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS15</b> — <i>Monospace, IBM Plex Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS15-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS15-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS15</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS15-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS15-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS15-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS15-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS15-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS15-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS15</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS15-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS15-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS15-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS15-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS15-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS15-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS15</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS15-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS15-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS15-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS15-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS15-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS15-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS15.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS15.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS16</b> — <i>Monospace, PT Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS16-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS16-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS16</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS16-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS16-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS16-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS16-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS16-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS16-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS16</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS16-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS16-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS16-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS16-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS16-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS16-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS16</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS16-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS16-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS16-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS16-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS16-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS16-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS16.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS16.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS17</b> — <i>Monospace, Recursive Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS17-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS17-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS17</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS17-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS17-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS17-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS17-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS17-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS17-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS17</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS17-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS17-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS17-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS17-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS17-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS17-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS17</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS17-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS17-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS17-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS17-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS17-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS17-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS17.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS17.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka SS18</b> — <i>Monospace, Input Mono Style</i></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaSS18-34.1.0.zip">Super TTC</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaSS18-34.1.0.zip">TTC</b></td><td colspan="2">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka SS18</b></td><td>Default</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaSS18-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaSS18-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaSS18-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaSS18-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaSS18-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaSS18-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;├&nbsp;<b>Iosevka Term SS18</b></td><td>Terminal</td><td><b>Yes</b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaTermSS18-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaTermSS18-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaTermSS18-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaTermSS18-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaTermSS18-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaTermSS18-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Fixed SS18</b></td><td>Fixed</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-SGr-IosevkaFixedSS18-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-SGr-IosevkaFixedSS18-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaFixedSS18-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaFixedSS18-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaFixedSS18-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaFixedSS18-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS18.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaSS18.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Aile</b> — <i>Quasi-proportional, Sans-serif</i></td><td colspan="4">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Aile</b></td><td>Default</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaAile-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaAile-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaAile-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaAile-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaAile-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaAile-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaAile.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaAile.dark.svg#gh-dark-mode-only"/></td></tr>
<tr><td colspan="3"><b>&#x1F4E6; Iosevka Etoile</b> — <i>Quasi-proportional, Slab-serif</i></td><td colspan="4">&nbsp;</td></tr>
<tr><td><b>&nbsp;&nbsp;└ Sub-packages</b></td><td><b>Spacing</b></td><td><b>Ligatures</b></td><td colspan="4"><b>Downloads</b></td></tr>
<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;└&nbsp;<b>Iosevka Etoile</b></td><td>Default</td><td>No</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/SuperTTC-IosevkaEtoile-34.1.0.zip">Super TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTC-IosevkaEtoile-34.1.0.zip">TTC</a></b></td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-IosevkaEtoile-34.1.0.zip">TTF</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgTTF-Unhinted-IosevkaEtoile-34.1.0.zip">Unhinted</a></b>)</td><td><b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-IosevkaEtoile-34.1.0.zip">WebFont</a></b>&nbsp;(<b><a href="https://github.com/be5invis/Iosevka/releases/download/v34.1.0/PkgWebFont-Unhinted-IosevkaEtoile-34.1.0.zip">Unhinted</a></b>)</td></tr>
<tr><td colspan="8"><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaEtoile.light.svg#gh-light-mode-only"/><img src="https://raw.githubusercontent.com/be5invis/Iosevka/v34.1.0/images/package-sample-IosevkaEtoile.dark.svg#gh-dark-mode-only"/></td></tr>
</table>


<!-- END Section-Package-List -->
