"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.Panose = exports.UnicodeRange4 = exports.UnicodeRange3 = exports.UnicodeRange2 = exports.UnicodeRange1 = exports.CodePageRange2 = exports.CodePageRange1 = exports.FsSelection = exports.FsType = exports.Tag = void 0;
exports.Tag = "OS/2";
var FsType;
(function (FsType) {
    FsType[FsType["None"] = 0] = "None";
    FsType[FsType["InstallableEmbedding"] = 1] = "InstallableEmbedding";
    FsType[FsType["RestrictedLicense"] = 2] = "RestrictedLicense";
    FsType[FsType["PreviewPrintLicense"] = 4] = "PreviewPrintLicense";
    FsType[FsType["EditableEmbedding"] = 8] = "EditableEmbedding";
    FsType[FsType["Reserved4"] = 16] = "Reserved4";
    FsType[FsType["Reserved5"] = 32] = "Reserved5";
    FsType[FsType["Reserved6"] = 64] = "Reserved6";
    FsType[FsType["Reserved7"] = 128] = "Reserved7";
    FsType[FsType["NoSubsetting"] = 256] = "NoSubsetting";
    FsType[FsType["BitmapEmbeddingOnly"] = 512] = "BitmapEmbeddingOnly";
})(FsType || (exports.FsType = FsType = {}));
var FsSelection;
(function (FsSelection) {
    FsSelection[FsSelection["None"] = 0] = "None";
    FsSelection[FsSelection["ITALIC"] = 1] = "ITALIC";
    FsSelection[FsSelection["UNDERSCORE"] = 2] = "UNDERSCORE";
    FsSelection[FsSelection["NEGATIVE"] = 4] = "NEGATIVE";
    FsSelection[FsSelection["OUTLINED"] = 8] = "OUTLINED";
    FsSelection[FsSelection["STRIKEOUT"] = 16] = "STRIKEOUT";
    FsSelection[FsSelection["BOLD"] = 32] = "BOLD";
    FsSelection[FsSelection["REGULAR"] = 64] = "REGULAR";
    FsSelection[FsSelection["USE_TYPO_METRICS"] = 128] = "USE_TYPO_METRICS";
    FsSelection[FsSelection["WWS"] = 256] = "WWS";
    FsSelection[FsSelection["OBLIQUE"] = 512] = "OBLIQUE";
})(FsSelection || (exports.FsSelection = FsSelection = {}));
var CodePageRange1;
(function (CodePageRange1) {
    CodePageRange1[CodePageRange1["None"] = 0] = "None";
    CodePageRange1[CodePageRange1["CP1252"] = 1] = "CP1252";
    CodePageRange1[CodePageRange1["CP1250"] = 2] = "CP1250";
    CodePageRange1[CodePageRange1["CP1251"] = 4] = "CP1251";
    CodePageRange1[CodePageRange1["CP1253"] = 8] = "CP1253";
    CodePageRange1[CodePageRange1["CP1254"] = 16] = "CP1254";
    CodePageRange1[CodePageRange1["CP1255"] = 32] = "CP1255";
    CodePageRange1[CodePageRange1["CP1256"] = 64] = "CP1256";
    CodePageRange1[CodePageRange1["CP1257"] = 128] = "CP1257";
    CodePageRange1[CodePageRange1["CP1258"] = 256] = "CP1258";
    CodePageRange1[CodePageRange1["Ansi1"] = 512] = "Ansi1";
    CodePageRange1[CodePageRange1["Ansi2"] = 1024] = "Ansi2";
    CodePageRange1[CodePageRange1["Ansi3"] = 2048] = "Ansi3";
    CodePageRange1[CodePageRange1["Ansi4"] = 4096] = "Ansi4";
    CodePageRange1[CodePageRange1["Ansi5"] = 8192] = "Ansi5";
    CodePageRange1[CodePageRange1["Ansi6"] = 16384] = "Ansi6";
    CodePageRange1[CodePageRange1["Ansi7"] = 32768] = "Ansi7";
    CodePageRange1[CodePageRange1["CP874"] = 65536] = "CP874";
    CodePageRange1[CodePageRange1["CP932"] = 131072] = "CP932";
    CodePageRange1[CodePageRange1["CP936"] = 262144] = "CP936";
    CodePageRange1[CodePageRange1["CP949"] = 524288] = "CP949";
    CodePageRange1[CodePageRange1["CP950"] = 1048576] = "CP950";
    CodePageRange1[CodePageRange1["CP1361"] = 2097152] = "CP1361";
    CodePageRange1[CodePageRange1["Oem1"] = 4194304] = "Oem1";
    CodePageRange1[CodePageRange1["Oem2"] = 8388608] = "Oem2";
    CodePageRange1[CodePageRange1["Oem3"] = 16777216] = "Oem3";
    CodePageRange1[CodePageRange1["Oem4"] = 33554432] = "Oem4";
    CodePageRange1[CodePageRange1["Oem5"] = 67108864] = "Oem5";
    CodePageRange1[CodePageRange1["Oem6"] = 134217728] = "Oem6";
    CodePageRange1[CodePageRange1["Oem7"] = 268435456] = "Oem7";
    CodePageRange1[CodePageRange1["MacRoman"] = 536870912] = "MacRoman";
    CodePageRange1[CodePageRange1["Oem"] = 1073741824] = "Oem";
    CodePageRange1[CodePageRange1["Symbol"] = -2147483648] = "Symbol";
})(CodePageRange1 || (exports.CodePageRange1 = CodePageRange1 = {}));
var CodePageRange2;
(function (CodePageRange2) {
    CodePageRange2[CodePageRange2["None"] = 0] = "None";
    CodePageRange2[CodePageRange2["Oem8"] = 1] = "Oem8";
    CodePageRange2[CodePageRange2["Oem9"] = 2] = "Oem9";
    CodePageRange2[CodePageRange2["Oem10"] = 4] = "Oem10";
    CodePageRange2[CodePageRange2["Oem11"] = 8] = "Oem11";
    CodePageRange2[CodePageRange2["Oem12"] = 16] = "Oem12";
    CodePageRange2[CodePageRange2["Oem13"] = 32] = "Oem13";
    CodePageRange2[CodePageRange2["Oem14"] = 64] = "Oem14";
    CodePageRange2[CodePageRange2["Oem15"] = 128] = "Oem15";
    CodePageRange2[CodePageRange2["Oem16"] = 256] = "Oem16";
    CodePageRange2[CodePageRange2["Oem17"] = 512] = "Oem17";
    CodePageRange2[CodePageRange2["Oem18"] = 1024] = "Oem18";
    CodePageRange2[CodePageRange2["Oem19"] = 2048] = "Oem19";
    CodePageRange2[CodePageRange2["Oem20"] = 4096] = "Oem20";
    CodePageRange2[CodePageRange2["Oem21"] = 8192] = "Oem21";
    CodePageRange2[CodePageRange2["Oem22"] = 16384] = "Oem22";
    CodePageRange2[CodePageRange2["Oem23"] = 32768] = "Oem23";
    CodePageRange2[CodePageRange2["CP869"] = 65536] = "CP869";
    CodePageRange2[CodePageRange2["CP866"] = 131072] = "CP866";
    CodePageRange2[CodePageRange2["CP865"] = 262144] = "CP865";
    CodePageRange2[CodePageRange2["CP864"] = 524288] = "CP864";
    CodePageRange2[CodePageRange2["CP863"] = 1048576] = "CP863";
    CodePageRange2[CodePageRange2["CP862"] = 2097152] = "CP862";
    CodePageRange2[CodePageRange2["CP861"] = 4194304] = "CP861";
    CodePageRange2[CodePageRange2["CP860"] = 8388608] = "CP860";
    CodePageRange2[CodePageRange2["CP857"] = 16777216] = "CP857";
    CodePageRange2[CodePageRange2["CP855"] = 33554432] = "CP855";
    CodePageRange2[CodePageRange2["CP852"] = 67108864] = "CP852";
    CodePageRange2[CodePageRange2["CP775"] = 134217728] = "CP775";
    CodePageRange2[CodePageRange2["CP737"] = 268435456] = "CP737";
    CodePageRange2[CodePageRange2["CP708"] = 536870912] = "CP708";
    CodePageRange2[CodePageRange2["CP850"] = 1073741824] = "CP850";
    CodePageRange2[CodePageRange2["CP437"] = -2147483648] = "CP437";
})(CodePageRange2 || (exports.CodePageRange2 = CodePageRange2 = {}));
var UnicodeRange1;
(function (UnicodeRange1) {
    UnicodeRange1[UnicodeRange1["None"] = 0] = "None";
    UnicodeRange1[UnicodeRange1["BasicLatin"] = 1] = "BasicLatin";
    UnicodeRange1[UnicodeRange1["Latin1Supplement"] = 2] = "Latin1Supplement";
    UnicodeRange1[UnicodeRange1["LatinExtendedA"] = 4] = "LatinExtendedA";
    UnicodeRange1[UnicodeRange1["LatinExtendedB"] = 8] = "LatinExtendedB";
    UnicodeRange1[UnicodeRange1["Phonetics"] = 16] = "Phonetics";
    UnicodeRange1[UnicodeRange1["SpacingModifiers"] = 32] = "SpacingModifiers";
    UnicodeRange1[UnicodeRange1["CombiningDiacriticalMarks"] = 64] = "CombiningDiacriticalMarks";
    UnicodeRange1[UnicodeRange1["GreekAndCoptic"] = 128] = "GreekAndCoptic";
    UnicodeRange1[UnicodeRange1["Coptic"] = 256] = "Coptic";
    UnicodeRange1[UnicodeRange1["Cyrillic"] = 512] = "Cyrillic";
    UnicodeRange1[UnicodeRange1["Armenian"] = 1024] = "Armenian";
    UnicodeRange1[UnicodeRange1["Hebrew"] = 2048] = "Hebrew";
    UnicodeRange1[UnicodeRange1["Vai"] = 4096] = "Vai";
    UnicodeRange1[UnicodeRange1["Arabic"] = 8192] = "Arabic";
    UnicodeRange1[UnicodeRange1["NKo"] = 16384] = "NKo";
    UnicodeRange1[UnicodeRange1["Devanagari"] = 32768] = "Devanagari";
    UnicodeRange1[UnicodeRange1["Bengali"] = 65536] = "Bengali";
    UnicodeRange1[UnicodeRange1["Gurmukhi"] = 131072] = "Gurmukhi";
    UnicodeRange1[UnicodeRange1["Gujarati"] = 262144] = "Gujarati";
    UnicodeRange1[UnicodeRange1["Oriya"] = 524288] = "Oriya";
    UnicodeRange1[UnicodeRange1["Tamil"] = 1048576] = "Tamil";
    UnicodeRange1[UnicodeRange1["Telugu"] = 2097152] = "Telugu";
    UnicodeRange1[UnicodeRange1["Kannada"] = 4194304] = "Kannada";
    UnicodeRange1[UnicodeRange1["Malayalam"] = 8388608] = "Malayalam";
    UnicodeRange1[UnicodeRange1["Thai"] = 16777216] = "Thai";
    UnicodeRange1[UnicodeRange1["Lao"] = 33554432] = "Lao";
    UnicodeRange1[UnicodeRange1["Georgian"] = 67108864] = "Georgian";
    UnicodeRange1[UnicodeRange1["Balinese"] = 134217728] = "Balinese";
    UnicodeRange1[UnicodeRange1["HangulJamo"] = 268435456] = "HangulJamo";
    UnicodeRange1[UnicodeRange1["LatinExtendedAdditional"] = 536870912] = "LatinExtendedAdditional";
    UnicodeRange1[UnicodeRange1["GreekExtended"] = 1073741824] = "GreekExtended";
    UnicodeRange1[UnicodeRange1["Punctuations"] = -2147483648] = "Punctuations";
})(UnicodeRange1 || (exports.UnicodeRange1 = UnicodeRange1 = {}));
var UnicodeRange2;
(function (UnicodeRange2) {
    UnicodeRange2[UnicodeRange2["None"] = 0] = "None";
    UnicodeRange2[UnicodeRange2["SuperscriptsAndSubscripts"] = 1] = "SuperscriptsAndSubscripts";
    UnicodeRange2[UnicodeRange2["CurrencySymbols"] = 2] = "CurrencySymbols";
    UnicodeRange2[UnicodeRange2["CombiningDiacriticalMarksForSymbols"] = 4] = "CombiningDiacriticalMarksForSymbols";
    UnicodeRange2[UnicodeRange2["LetterLikeSymbols"] = 8] = "LetterLikeSymbols";
    UnicodeRange2[UnicodeRange2["NumberForms"] = 16] = "NumberForms";
    UnicodeRange2[UnicodeRange2["Arrows"] = 32] = "Arrows";
    UnicodeRange2[UnicodeRange2["MathematicalOperators"] = 64] = "MathematicalOperators";
    UnicodeRange2[UnicodeRange2["MiscellaneousTechnical"] = 128] = "MiscellaneousTechnical";
    UnicodeRange2[UnicodeRange2["ControlPictures"] = 256] = "ControlPictures";
    UnicodeRange2[UnicodeRange2["OpticalCharacterRecognition"] = 512] = "OpticalCharacterRecognition";
    UnicodeRange2[UnicodeRange2["EnclosedAlphanumerics"] = 1024] = "EnclosedAlphanumerics";
    UnicodeRange2[UnicodeRange2["BoxDrawing"] = 2048] = "BoxDrawing";
    UnicodeRange2[UnicodeRange2["BlockElements"] = 4096] = "BlockElements";
    UnicodeRange2[UnicodeRange2["GeometricShapes"] = 8192] = "GeometricShapes";
    UnicodeRange2[UnicodeRange2["MiscellaneousSymbols"] = 16384] = "MiscellaneousSymbols";
    UnicodeRange2[UnicodeRange2["Dingbats"] = 32768] = "Dingbats";
    UnicodeRange2[UnicodeRange2["CJKSymbolsAndPunctuation"] = 65536] = "CJKSymbolsAndPunctuation";
    UnicodeRange2[UnicodeRange2["Hiragana"] = 131072] = "Hiragana";
    UnicodeRange2[UnicodeRange2["Katakana"] = 262144] = "Katakana";
    UnicodeRange2[UnicodeRange2["Bopomofo"] = 524288] = "Bopomofo";
    UnicodeRange2[UnicodeRange2["HangulCompatibilityJamo"] = 1048576] = "HangulCompatibilityJamo";
    UnicodeRange2[UnicodeRange2["Phagspa"] = 2097152] = "Phagspa";
    UnicodeRange2[UnicodeRange2["EnclosedCJKLettersAndMonths"] = 4194304] = "EnclosedCJKLettersAndMonths";
    UnicodeRange2[UnicodeRange2["CJKCompatibility"] = 8388608] = "CJKCompatibility";
    UnicodeRange2[UnicodeRange2["HangulSyllables"] = 16777216] = "HangulSyllables";
    UnicodeRange2[UnicodeRange2["NonPlane0"] = 33554432] = "NonPlane0";
    UnicodeRange2[UnicodeRange2["Phoenician"] = 67108864] = "Phoenician";
    UnicodeRange2[UnicodeRange2["CJKUnifiedIdeographs"] = 134217728] = "CJKUnifiedIdeographs";
    UnicodeRange2[UnicodeRange2["PrivateUseAreaP0"] = 268435456] = "PrivateUseAreaP0";
    UnicodeRange2[UnicodeRange2["CJKStrokes"] = 536870912] = "CJKStrokes";
    UnicodeRange2[UnicodeRange2["AlphabeticPresentationForms"] = 1073741824] = "AlphabeticPresentationForms";
    UnicodeRange2[UnicodeRange2["ArabicPresentationFormsA"] = -2147483648] = "ArabicPresentationFormsA";
})(UnicodeRange2 || (exports.UnicodeRange2 = UnicodeRange2 = {}));
var UnicodeRange3;
(function (UnicodeRange3) {
    UnicodeRange3[UnicodeRange3["None"] = 0] = "None";
    UnicodeRange3[UnicodeRange3["CombiningHalfMarks"] = 1] = "CombiningHalfMarks";
    UnicodeRange3[UnicodeRange3["VerticalFormsAndCJKCompatibilityForms"] = 2] = "VerticalFormsAndCJKCompatibilityForms";
    UnicodeRange3[UnicodeRange3["SmallFormVariants"] = 4] = "SmallFormVariants";
    UnicodeRange3[UnicodeRange3["ArabicPresentationFormsB"] = 8] = "ArabicPresentationFormsB";
    UnicodeRange3[UnicodeRange3["HalfWidthAndFullWidthForms"] = 16] = "HalfWidthAndFullWidthForms";
    UnicodeRange3[UnicodeRange3["Specials"] = 32] = "Specials";
    UnicodeRange3[UnicodeRange3["Tibetan"] = 64] = "Tibetan";
    UnicodeRange3[UnicodeRange3["Syriac"] = 128] = "Syriac";
    UnicodeRange3[UnicodeRange3["Thaana"] = 256] = "Thaana";
    UnicodeRange3[UnicodeRange3["Sinhala"] = 512] = "Sinhala";
    UnicodeRange3[UnicodeRange3["Myanmar"] = 1024] = "Myanmar";
    UnicodeRange3[UnicodeRange3["Ethiopic"] = 2048] = "Ethiopic";
    UnicodeRange3[UnicodeRange3["Cherokee"] = 4096] = "Cherokee";
    UnicodeRange3[UnicodeRange3["UnifiedCanadianAboriginalSyllabics"] = 8192] = "UnifiedCanadianAboriginalSyllabics";
    UnicodeRange3[UnicodeRange3["Ogham"] = 16384] = "Ogham";
    UnicodeRange3[UnicodeRange3["Runic"] = 32768] = "Runic";
    UnicodeRange3[UnicodeRange3["Khmer"] = 65536] = "Khmer";
    UnicodeRange3[UnicodeRange3["Mongolian"] = 131072] = "Mongolian";
    UnicodeRange3[UnicodeRange3["BraillePatterns"] = 262144] = "BraillePatterns";
    UnicodeRange3[UnicodeRange3["YiSyllables"] = 524288] = "YiSyllables";
    UnicodeRange3[UnicodeRange3["Tagalog"] = 1048576] = "Tagalog";
    UnicodeRange3[UnicodeRange3["OldItalic"] = 2097152] = "OldItalic";
    UnicodeRange3[UnicodeRange3["Gothic"] = 4194304] = "Gothic";
    UnicodeRange3[UnicodeRange3["Deseret"] = 8388608] = "Deseret";
    UnicodeRange3[UnicodeRange3["MusicalSymbols"] = 16777216] = "MusicalSymbols";
    UnicodeRange3[UnicodeRange3["MathematicalAlphanumericSymbols"] = 33554432] = "MathematicalAlphanumericSymbols";
    UnicodeRange3[UnicodeRange3["PrivateUseP15AndP16"] = 67108864] = "PrivateUseP15AndP16";
    UnicodeRange3[UnicodeRange3["VariationSelectors"] = 134217728] = "VariationSelectors";
    UnicodeRange3[UnicodeRange3["Tags"] = 268435456] = "Tags";
    UnicodeRange3[UnicodeRange3["Limbu"] = 536870912] = "Limbu";
    UnicodeRange3[UnicodeRange3["TaiLe"] = 1073741824] = "TaiLe";
    UnicodeRange3[UnicodeRange3["NewTaiLue"] = -2147483648] = "NewTaiLue";
})(UnicodeRange3 || (exports.UnicodeRange3 = UnicodeRange3 = {}));
var UnicodeRange4;
(function (UnicodeRange4) {
    UnicodeRange4[UnicodeRange4["None"] = 0] = "None";
    UnicodeRange4[UnicodeRange4["Buginese"] = 1] = "Buginese";
    UnicodeRange4[UnicodeRange4["Glagolitic"] = 2] = "Glagolitic";
    UnicodeRange4[UnicodeRange4["Tifinagh"] = 4] = "Tifinagh";
    UnicodeRange4[UnicodeRange4["YijingHexagramSymbols"] = 8] = "YijingHexagramSymbols";
    UnicodeRange4[UnicodeRange4["SylotiNagri"] = 16] = "SylotiNagri";
    UnicodeRange4[UnicodeRange4["LinearBSyllabaryIdeogramsAndAegeanNumbers"] = 32] = "LinearBSyllabaryIdeogramsAndAegeanNumbers";
    UnicodeRange4[UnicodeRange4["AncientGreekNumbers"] = 64] = "AncientGreekNumbers";
    UnicodeRange4[UnicodeRange4["Ugaritic"] = 128] = "Ugaritic";
    UnicodeRange4[UnicodeRange4["OldPersian"] = 256] = "OldPersian";
    UnicodeRange4[UnicodeRange4["Shavian"] = 512] = "Shavian";
    UnicodeRange4[UnicodeRange4["Osmanya"] = 1024] = "Osmanya";
    UnicodeRange4[UnicodeRange4["CypriotSyllabary"] = 2048] = "CypriotSyllabary";
    UnicodeRange4[UnicodeRange4["Kharoshthi"] = 4096] = "Kharoshthi";
    UnicodeRange4[UnicodeRange4["TaiXuanJingSymbols"] = 8192] = "TaiXuanJingSymbols";
    UnicodeRange4[UnicodeRange4["Cuneiform"] = 16384] = "Cuneiform";
    UnicodeRange4[UnicodeRange4["CountingRodNumerals"] = 32768] = "CountingRodNumerals";
    UnicodeRange4[UnicodeRange4["Sundanese"] = 65536] = "Sundanese";
    UnicodeRange4[UnicodeRange4["Lepcha"] = 131072] = "Lepcha";
    UnicodeRange4[UnicodeRange4["OlChiki"] = 262144] = "OlChiki";
    UnicodeRange4[UnicodeRange4["Saurashtra"] = 524288] = "Saurashtra";
    UnicodeRange4[UnicodeRange4["KayahLi"] = 1048576] = "KayahLi";
    UnicodeRange4[UnicodeRange4["Rejang"] = 2097152] = "Rejang";
    UnicodeRange4[UnicodeRange4["Cham"] = 4194304] = "Cham";
    UnicodeRange4[UnicodeRange4["AncientSymbols"] = 8388608] = "AncientSymbols";
    UnicodeRange4[UnicodeRange4["PhaistosDisc"] = 16777216] = "PhaistosDisc";
    UnicodeRange4[UnicodeRange4["CarianAndLycian"] = 33554432] = "CarianAndLycian";
    UnicodeRange4[UnicodeRange4["DominoAndMahjongTiles"] = 67108864] = "DominoAndMahjongTiles";
})(UnicodeRange4 || (exports.UnicodeRange4 = UnicodeRange4 = {}));
class Panose {
    constructor() {
        this.bFamilyType = 0;
        this.bSerifStyle = 0;
        this.bWeight = 0;
        this.bProportion = 0;
        this.bContrast = 0;
        this.bStrokeVariation = 0;
        this.bArmStyle = 0;
        this.bLetterform = 0;
        this.bMidline = 0;
        this.bXHeight = 0;
    }
}
exports.Panose = Panose;
class Table {
    constructor(version) {
        this.version = version;
        this.xAvgCharWidth = 0;
        this.usWeightClass = 0;
        this.usWidthClass = 0;
        this.fsType = FsType.None;
        this.ySubscriptXSize = 0;
        this.ySubscriptYSize = 0;
        this.ySubscriptXOffset = 0;
        this.ySubscriptYOffset = 0;
        this.ySuperscriptXSize = 0;
        this.ySuperscriptYSize = 0;
        this.ySuperscriptXOffset = 0;
        this.ySuperscriptYOffset = 0;
        this.yStrikeoutSize = 0;
        this.yStrikeoutPosition = 0;
        this.sFamilyClass = 0;
        this.panose = new Panose();
        this.ulUnicodeRange1 = UnicodeRange1.None;
        this.ulUnicodeRange2 = UnicodeRange2.None;
        this.ulUnicodeRange3 = UnicodeRange3.None;
        this.ulUnicodeRange4 = UnicodeRange4.None;
        this.achVendID = "UKWN";
        this.fsSelection = FsSelection.None;
        this.usFirstCharIndex = 0;
        this.usLastCharIndex = 0;
        this.sTypoAscender = 0;
        this.sTypoDescender = 0;
        this.sTypoLineGap = 0;
        this.usWinAscent = 0;
        this.usWinDescent = 0;
        this.ulCodePageRange1 = CodePageRange1.None;
        this.ulCodePageRange2 = CodePageRange2.None;
        this.sxHeight = 0;
        this.sCapHeight = 0;
        this.usDefaultChar = 0;
        this.usBreakChar = 0;
        this.usMaxContext = 0;
        this.usLowerOpticalPointSize = 0;
        this.usUpperOpticalPointSize = 0;
    }
}
exports.Table = Table;
//# sourceMappingURL=os2.js.map