"use strict";
/* eslint-disable @typescript-eslint/no-explicit-any */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyBag = exports.DependentPair = exports.TypeID = void 0;
class TypeID {
    constructor(id) {
        this.id = id;
    }
}
exports.TypeID = TypeID;
class DependentPair {
    constructor(tid, value) {
        this.tid = tid;
        this.value = value;
    }
    cast(expected) {
        if (this.tid.id === expected.id)
            return this.value;
        else
            return undefined;
    }
    static create(tid, value) {
        return new DependentPair(tid, value);
    }
}
exports.DependentPair = DependentPair;
class PropertyBag {
    constructor() {
        this.mapping = new Map();
    }
    set(tid, value) {
        this.mapping.set(tid.id, value);
    }
    get(tid) {
        return this.mapping.get(tid.id);
    }
    delete(tid) {
        this.mapping.delete(tid.id);
    }
    *entries() {
        for (const [id, value] of this.mapping) {
            yield DependentPair.create(new TypeID(id), value);
        }
    }
}
exports.PropertyBag = PropertyBag;
//# sourceMappingURL=index.js.map