"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.rectifyCffTable = rectifyCffTable;
const Ot = require("@ot-builder/ot");
const shared_1 = require("../shared");
function rectifyCoordPrivateDict(rec, pd) {
    const result = new Ot.Cff.PrivateDict();
    result.blueValues = shared_1.RectifyImpl.Coord.list(rec, pd.blueValues);
    result.otherBlues = shared_1.RectifyImpl.Coord.list(rec, pd.otherBlues);
    result.familyBlues = shared_1.RectifyImpl.Coord.list(rec, pd.familyBlues);
    result.familyOtherBlues = shared_1.RectifyImpl.Coord.list(rec, pd.familyOtherBlues);
    result.stemSnapH = shared_1.RectifyImpl.Coord.list(rec, pd.stemSnapH);
    result.stemSnapV = shared_1.RectifyImpl.Coord.list(rec, pd.stemSnapV);
    result.blueScale = rec.coord(pd.blueScale);
    result.blueShift = rec.coord(pd.blueShift);
    result.blueFuzz = rec.coord(pd.blueFuzz);
    result.stdHW = rec.coord(pd.stdHW);
    result.stdVW = rec.coord(pd.stdVW);
    result.languageGroup = pd.languageGroup;
    result.expansionFactor = rec.coord(pd.expansionFactor);
    result.defaultWidthX = pd.defaultWidthX;
    result.nominalWidthX = pd.nominalWidthX;
    return result;
}
function rectifyCoordFontDict(rec, fd) {
    const result = new Ot.Cff.FontDict();
    result.version = fd.version;
    result.notice = fd.notice;
    result.copyright = fd.copyright;
    result.fullName = fd.fullName;
    result.familyName = fd.familyName;
    result.weight = fd.weight;
    result.isFixedPitch = fd.isFixedPitch;
    result.italicAngle = fd.italicAngle;
    result.underlinePosition = fd.underlinePosition;
    result.underlineThickness = fd.underlineThickness;
    result.paintType = fd.paintType;
    result.strokeWidth = fd.strokeWidth;
    result.cidFontName = fd.cidFontName;
    result.cidFontVersion = fd.cidFontVersion;
    result.cidFontRevision = fd.cidFontRevision;
    result.cidFontType = fd.cidFontType;
    result.cidCount = fd.cidCount;
    if (fd.privateDict) {
        result.privateDict = rectifyCoordPrivateDict(rec, fd.privateDict);
    }
    if (fd.fontMatrix) {
        result.fontMatrix = {
            ...fd.fontMatrix,
            dx: rec.coord(fd.fontMatrix.dx),
            dy: rec.coord(fd.fontMatrix.dy)
        };
    }
    return result;
}
function rectifyGlyphCID(rec, cid) {
    const result = new Ot.Cff.CID();
    result.registry = cid.registry;
    result.ordering = cid.ordering;
    result.supplement = cid.supplement;
    if (cid.mapping) {
        result.mapping = shared_1.RectifyImpl.Glyph.comapSome(rec, cid.mapping);
    }
    return result;
}
function rectifyCffTable(rg, rc, table) {
    const result = new Ot.Cff.Table(table.version);
    result.postScriptFontName = table.postScriptFontName;
    result.topDict = rectifyCoordFontDict(rc, table.topDict);
    if (table.cid)
        result.cid = rectifyGlyphCID(rg, table.cid);
    if (table.fdArray) {
        result.fdArray = shared_1.RectifyImpl.listAllT(rc, table.fdArray, rectifyCoordFontDict);
    }
    if (table.fdSelect)
        result.fdSelect = shared_1.RectifyImpl.Glyph.mapSome(rg, table.fdSelect);
    return result;
}
//# sourceMappingURL=cff.js.map