/* { dg-do compile } */
/* { dg-options "-mrvv-vector-bits=scalable -march=rv32gcv -mabi=ilp32 -fno-tree-vectorize" } */

#include "riscv_vector.h"

void f6 (int8_t * restrict in, int8_t * restrict out, int n)
{
  if (n == 0) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 500);
    *(vfloat32mf2_t*)(out + 500) = v;
  } else if (n == 1) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 600);
    *(vfloat32mf2_t*)(out + 600) = v;
  } else {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 700);
    *(vfloat32mf2_t*)(out + 700) = v;
  }

  for (int i = 0 ; i < n * n; i++)
    out[i] = out[i] + out[i];
  
  for (int i = 0 ; i < n * n * n; i++)
    out[i] = out[i] * out[i];

  for (int i = 0 ; i < n * n * n * n; i++)
    out[i] = out[i] * out[i];
  
  for (int i = 0 ; i < n * n * n * n; i++) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 900 + i);
    *(vfloat32mf2_t*)(out + 900 + i) = v;
  }

  for (int i = 0 ; i < n * n; i++)
    out[i] = out[i] + out[i];
  
  for (int i = 0 ; i < n * n * n; i++)
    out[i] = out[i] * out[i];

  for (int i = 0 ; i < n * n * n * n; i++)
    out[i] = out[i] * out[i];
  
  for (int i = 0 ; i < n * n; i++)
    out[i] = out[i] + out[i];
  
  for (int i = 0 ; i < n * n * n; i++)
    out[i] = out[i] * out[i];

  for (int i = 0 ; i < n * n * n * n; i++)
    out[i] = out[i] * out[i];
  
  if (n == 0) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 500);
    *(vfloat32mf2_t*)(out + 500) = v;
  } else if (n == 1) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 600);
    *(vfloat32mf2_t*)(out + 600) = v;
  } else {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 700);
    *(vfloat32mf2_t*)(out + 700) = v;
  }
  
  for (int i = 0 ; i < n * n; i++)
    out[i] = out[i] + out[i];
  
  for (int i = 0 ; i < n * n * n; i++)
    out[i] = out[i] * out[i];

  for (int i = 0 ; i < n * n * n * n; i++)
    out[i] = out[i] * out[i];
  
  for (int i = 0 ; i < n * n; i++)
    out[i] = out[i] + out[i];
  
  for (int i = 0 ; i < n * n * n; i++)
    out[i] = out[i] * out[i];

  for (int i = 0 ; i < n * n * n * n; i++)
    out[i] = out[i] * out[i];
  
  for (int i = 0 ; i < n * n * n * n; i++) {
    vfloat32mf2_t v = *(vfloat32mf2_t*)(in + 900 + i);
    *(vfloat32mf2_t*)(out + 900 + i) = v;
  }
}

/* { dg-final { scan-assembler-times {vsetvli\s+[a-x0-9]+,\s*zero,\s*e32,\s*mf2,\s*t[au],\s*m[au]} 3 { target { no-opts "-O0" no-opts "-O1"  no-opts "-Os" no-opts "-Oz" no-opts "-funroll-loops" no-opts "-g" } } } } */
