/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2016 Glenn Ruben Bakke
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// Pin numbering scheme for nrf52840-based boards
//
// Software Pins 0-31 correspond to physical pins
// 0.x and software Pins 32-47 correspond to physical pins 1.x.
//
// Example: Pin(47) would be 1.15 on the PCA10059

// Board data
#define MICROPY_HW_BOARD_NAME       "EVK_NINA_B3"
#define MICROPY_HW_MCU_NAME         "NRF52840"
#define MICROPY_PY_SYS_PLATFORM     "nrf52"

// Enable @viper and @native
#define MICROPY_EMIT_THUMB          (1)
#define MICROPY_EMIT_INLINE_THUMB   (1)

// Enable optional modules
#define MICROPY_PY_ERRNO            (1)
#define MICROPY_PY_HASHLIB          (1)

// Peripherals Config
#define MICROPY_PY_MACHINE_UART     (1)
#define MICROPY_PY_MACHINE_HW_PWM   (1)
#define MICROPY_PY_MACHINE_RTCOUNTER (1)
#define MICROPY_PY_MACHINE_I2C      (1)
#define MICROPY_PY_MACHINE_ADC      (1)
#define MICROPY_PY_MACHINE_TEMP     (1)
#define MICROPY_HW_ENABLE_RNG       (1)

// Configure LEDS
#define MICROPY_HW_HAS_LED          (1)
#define MICROPY_HW_LED_COUNT        (3)
#define MICROPY_HW_LED_PULLUP       (1)
#define MICROPY_HW_LED1             (13) // LED1 RED
#define MICROPY_HW_LED2             (25) // LED2 GREEN
#define MICROPY_HW_LED3             (32) // LED3 BLUE

// UART config
#define MICROPY_HW_UART1_RX         (29)
#define MICROPY_HW_UART1_TX         (45)
#define MICROPY_HW_UART1_CTS        (44)
#define MICROPY_HW_UART1_RTS        (31)
#define MICROPY_HW_UART1_HWFC       (1)

// SPI config
#define MICROPY_HW_SPI0_NAME        "SPI0"
#define MICROPY_HW_SPI0_SCK         (12)
#define MICROPY_HW_SPI0_MOSI        (14)
#define MICROPY_HW_SPI0_MISO        (15)

// PWM Names
#define MICROPY_HW_PWM0_NAME        "PWM0"
#define MICROPY_HW_PWM1_NAME        "PWM1"
#define MICROPY_HW_PWM2_NAME        "PWM2"

// How Many LED indexes appear in the help() message
#define HELP_TEXT_BOARD_LED         "1,2,3"
