/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Hashtable;

public class CalendarDB {
    private Hashtable events = new Hashtable(12);
    private static final String[] time = new String[]{"8:00 am", "9:00 am", "10:00 am", "11:00 am", "12:00 pm", "1:00 pm", "2:00 pm", "3:00 pm", "4:00 pm", "5:00 pm", "6:00 pm", "7:00 pm", "8:00 pm"};
    public static final int rows = 12;

    public CalendarDB() {
        int i = 0;
        while (i < 12) {
            this.events.put(time[i], new Event(time[i]));
            ++i;
        }
    }

    public int getRows() {
        return 12;
    }

    public Event getEvent(int index) {
        return (Event)this.events.get(time[index]);
    }

    public int getIndex(String tm) {
        int i = 0;
        while (i < 12) {
            if (tm.equals(time[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addEvent(String tm, String desc) {
        int index = this.getIndex(tm);
        if (index >= 0) {
            String descr = desc;
            Event e = (Event)this.events.get(time[index]);
            e.setDescription(descr);
        }
    }

    static {
        rows = 12;
    }

    public class Event {
        String hour;
        String description;

        public Event(String hourx) {
            this.hour = hourx;
            this.description = "";
        }

        public String getHour() {
            return this.hour;
        }

        public String getDescription() {
            if (this.description.equals("")) {
                return "";
            }
            return this.description;
        }

        public void setDescription(String descr) {
            this.description = descr;
        }
    }
}

