# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementIpGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_get(self, resource_group):
        response = await self.client.ip_groups.get(
            resource_group_name=resource_group.name,
            ip_groups_name="str",
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.ip_groups.begin_create_or_update(
                resource_group_name=resource_group.name,
                ip_groups_name="str",
                parameters={
                    "etag": "str",
                    "firewallPolicies": [{"id": "str"}],
                    "firewalls": [{"id": "str"}],
                    "id": "str",
                    "ipAddresses": ["str"],
                    "location": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_update_groups(self, resource_group):
        response = await self.client.ip_groups.update_groups(
            resource_group_name=resource_group.name,
            ip_groups_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_begin_delete(self, resource_group):
        response = await (
            await self.client.ip_groups.begin_delete(
                resource_group_name=resource_group.name,
                ip_groups_name="str",
                api_version="2024-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_list_by_resource_group(self, resource_group):
        response = self.client.ip_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_ip_groups_list(self, resource_group):
        response = self.client.ip_groups.list(
            api_version="2024-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
