% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_styles.R
\name{docx_set_character_style}
\alias{docx_set_character_style}
\title{Add character style in a Word document}
\usage{
docx_set_character_style(
  x,
  style_id,
  style_name,
  base_on,
  fp_t = fp_text_lite()
)
}
\arguments{
\item{x}{an rdocx object}

\item{style_id}{a unique style identifier for Word.}

\item{style_name}{a unique label associated with the style identifier.
This label is the name of the style when Word edit the document.}

\item{base_on}{the character style name used as base style}

\item{fp_t}{Text formatting properties, see \code{\link[=fp_text]{fp_text()}}.}
}
\description{
The function lets you add or modify Word character styles.
}
\examples{
library(officer)
doc <- read_docx()

doc <- docx_set_character_style(
  doc,
  style_id = "newcharstyle",
  style_name = "label for char style",
  base_on = "Default Paragraph Font",
  fp_text_lite(
    shading.color = "red",
    color = "white")
)
paragraph <- fpar(
  run_wordtext("hello",
    style_id = "newcharstyle"))

doc <- body_add_fpar(doc, value = paragraph)
docx_file <- print(doc, target = tempfile(fileext = ".docx"))
docx_file
}
