#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Add extra_data column to sync_point table

Revision ID: d2db381e3324
Revises: c6214ca60943
Create Date: 2025-01-03

"""
from alembic import op
import sqlalchemy as sa

from heat.db import types

# revision identifiers, used by Alembic.
revision = 'd2db381e3324'
down_revision = 'c6214ca60943'
branch_labels = None
depends_on = None


def upgrade():
    op.add_column('sync_point',
                  sa.Column('extra_data', types.Json, nullable=True))


def downgrade():
    op.drop_column('sync_point', 'extra_data')
