
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotVisualiserAttributes.h
    \\brief Definition of BoxPlotVisualiser Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "BoxPlotVisualiserAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BoxPlotVisualiserAttributes::BoxPlotVisualiserAttributes():
	box_(ParameterManager::getBool("boxplot_box")),
	box_width_(ParameterManager::getDouble("boxplot_box_width")),
	box_border_(ParameterManager::getBool("boxplot_box_border")),
	box_border_thickness_(ParameterManager::getInt("boxplot_box_border_thickness")),
	median_(ParameterManager::getBool("boxplot_median")),
	median_thickness_(ParameterManager::getInt("boxplot_median_thickness")),
	whisker_(ParameterManager::getString("boxplot_whisker")),
	whisker_box_width_(ParameterManager::getDouble("boxplot_whisker_box_width")),
	whisker_box_border_(ParameterManager::getBool("boxplot_whisker_box_border")),
	whisker_box_border_thickness_(ParameterManager::getInt("boxplot_whisker_box_border_thickness")),
	whisker_line_thickness_(ParameterManager::getInt("boxplot_whisker_line_thickness"))
	,
	box_colour_(MagTranslator<string, Colour>().magics("boxplot_box_colour")),
	box_border_colour_(MagTranslator<string, Colour>().magics("boxplot_box_border_colour")),
	box_border_style_(MagTranslator<string, LineStyle>().magics("boxplot_box_border_line_style")),
	median_colour_(MagTranslator<string, Colour>().magics("boxplot_median_colour")),
	median_style_(MagTranslator<string, LineStyle>().magics("boxplot_median_line_style")),
	whisker_box_colour_(MagTranslator<string, Colour>().magics("boxplot_whisker_box_colour")),
	whisker_box_border_colour_(MagTranslator<string, Colour>().magics("boxplot_whisker_box_border_colour")),
	whisker_box_border_style_(MagTranslator<string, LineStyle>().magics("boxplot_whisker_box_border_line_style")),
	whisker_line_colour_(MagTranslator<string, Colour>().magics("boxplot_whisker_line_colour")),
	whisker_line_style_(MagTranslator<string, LineStyle>().magics("boxplot_whisker_line_style"))
	
{
}


BoxPlotVisualiserAttributes::~BoxPlotVisualiserAttributes()
{

}


void BoxPlotVisualiserAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "boxplot_box", box_, params);
	setAttribute(prefix, "boxplot_box_width", box_width_, params);
	setAttribute(prefix, "boxplot_box_border", box_border_, params);
	setAttribute(prefix, "boxplot_box_border_thickness", box_border_thickness_, params);
	setAttribute(prefix, "boxplot_median", median_, params);
	setAttribute(prefix, "boxplot_median_thickness", median_thickness_, params);
	setAttribute(prefix, "boxplot_whisker", whisker_, params);
	setAttribute(prefix, "boxplot_whisker_box_width", whisker_box_width_, params);
	setAttribute(prefix, "boxplot_whisker_box_border", whisker_box_border_, params);
	setAttribute(prefix, "boxplot_whisker_box_border_thickness", whisker_box_border_thickness_, params);
	setAttribute(prefix, "boxplot_whisker_line_thickness", whisker_line_thickness_, params);
	
	setMember(prefix, "boxplot_box_colour", box_colour_, params);
	setMember(prefix, "boxplot_box_border_colour", box_border_colour_, params);
	setAttribute(prefix, "boxplot_box_border_line_style", box_border_style_, params);
	setMember(prefix, "boxplot_median_colour", median_colour_, params);
	setAttribute(prefix, "boxplot_median_line_style", median_style_, params);
	setMember(prefix, "boxplot_whisker_box_colour", whisker_box_colour_, params);
	setMember(prefix, "boxplot_whisker_box_border_colour", whisker_box_border_colour_, params);
	setAttribute(prefix, "boxplot_whisker_box_border_line_style", whisker_box_border_style_, params);
	setMember(prefix, "boxplot_whisker_line_colour", whisker_line_colour_, params);
	setAttribute(prefix, "boxplot_whisker_line_style", whisker_line_style_, params);
	
}

void BoxPlotVisualiserAttributes::copy(const BoxPlotVisualiserAttributes& other)
{
	box_ = other.box_;
	box_width_ = other.box_width_;
	box_border_ = other.box_border_;
	box_border_thickness_ = other.box_border_thickness_;
	median_ = other.median_;
	median_thickness_ = other.median_thickness_;
	whisker_ = other.whisker_;
	whisker_box_width_ = other.whisker_box_width_;
	whisker_box_border_ = other.whisker_box_border_;
	whisker_box_border_thickness_ = other.whisker_box_border_thickness_;
	whisker_line_thickness_ = other.whisker_line_thickness_;
	box_colour_ = unique_ptr<Colour>(other.box_colour_->clone());
	box_border_colour_ = unique_ptr<Colour>(other.box_border_colour_->clone());
	box_border_style_ = other.box_border_style_;
	median_colour_ = unique_ptr<Colour>(other.median_colour_->clone());
	median_style_ = other.median_style_;
	whisker_box_colour_ = unique_ptr<Colour>(other.whisker_box_colour_->clone());
	whisker_box_border_colour_ = unique_ptr<Colour>(other.whisker_box_border_colour_->clone());
	whisker_box_border_style_ = other.whisker_box_border_style_;
	whisker_line_colour_ = unique_ptr<Colour>(other.whisker_line_colour_->clone());
	whisker_line_style_ = other.whisker_line_style_;
	
}


bool BoxPlotVisualiserAttributes::accept(const string& node)
{

	if ( magCompare(node, "boxplot")  )
		return true;
	
	return false;
}

void BoxPlotVisualiserAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "boxplot")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void BoxPlotVisualiserAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " box = " <<  box_;
	out << " box_width = " <<  box_width_;
	out << " box_border = " <<  box_border_;
	out << " box_border_thickness = " <<  box_border_thickness_;
	out << " median = " <<  median_;
	out << " median_thickness = " <<  median_thickness_;
	out << " whisker = " <<  whisker_;
	out << " whisker_box_width = " <<  whisker_box_width_;
	out << " whisker_box_border = " <<  whisker_box_border_;
	out << " whisker_box_border_thickness = " <<  whisker_box_border_thickness_;
	out << " whisker_line_thickness = " <<  whisker_line_thickness_;
	out << " box_colour = " <<  *box_colour_;
	out << " box_border_colour = " <<  *box_border_colour_;
	out << " box_border_style = " <<  box_border_style_;
	out << " median_colour = " <<  *median_colour_;
	out << " median_style = " <<  median_style_;
	out << " whisker_box_colour = " <<  *whisker_box_colour_;
	out << " whisker_box_border_colour = " <<  *whisker_box_border_colour_;
	out << " whisker_box_border_style = " <<  whisker_box_border_style_;
	out << " whisker_line_colour = " <<  *whisker_line_colour_;
	out << " whisker_line_style = " <<  whisker_line_style_;
	
	out << "]" << "\n";
}

void BoxPlotVisualiserAttributes::toxml(ostream& out)  const
{
	out <<  "\"boxplot\"";
	out << ", \"boxplot_box\":";
	niceprint(out,box_);
	out << ", \"boxplot_box_width\":";
	niceprint(out,box_width_);
	out << ", \"boxplot_box_border\":";
	niceprint(out,box_border_);
	out << ", \"boxplot_box_border_thickness\":";
	niceprint(out,box_border_thickness_);
	out << ", \"boxplot_median\":";
	niceprint(out,median_);
	out << ", \"boxplot_median_thickness\":";
	niceprint(out,median_thickness_);
	out << ", \"boxplot_whisker\":";
	niceprint(out,whisker_);
	out << ", \"boxplot_whisker_box_width\":";
	niceprint(out,whisker_box_width_);
	out << ", \"boxplot_whisker_box_border\":";
	niceprint(out,whisker_box_border_);
	out << ", \"boxplot_whisker_box_border_thickness\":";
	niceprint(out,whisker_box_border_thickness_);
	out << ", \"boxplot_whisker_line_thickness\":";
	niceprint(out,whisker_line_thickness_);
	out << ", \"boxplot_box_colour\":";
	niceprint(out, *box_colour_);
	out << ", \"boxplot_box_border_colour\":";
	niceprint(out, *box_border_colour_);
	out << ", \"boxplot_box_border_line_style\":";
	niceprint(out, box_border_style_);
	out << ", \"boxplot_median_colour\":";
	niceprint(out, *median_colour_);
	out << ", \"boxplot_median_line_style\":";
	niceprint(out, median_style_);
	out << ", \"boxplot_whisker_box_colour\":";
	niceprint(out, *whisker_box_colour_);
	out << ", \"boxplot_whisker_box_border_colour\":";
	niceprint(out, *whisker_box_border_colour_);
	out << ", \"boxplot_whisker_box_border_line_style\":";
	niceprint(out, whisker_box_border_style_);
	out << ", \"boxplot_whisker_line_colour\":";
	niceprint(out, *whisker_line_colour_);
	out << ", \"boxplot_whisker_line_style\":";
	niceprint(out, whisker_line_style_);
	
}

static MagicsParameter<string> boxplot_box("boxplot_box", "on");
static MagicsParameter<double> boxplot_box_width("boxplot_box_width", 1.0);
static MagicsParameter<string> boxplot_box_border("boxplot_box_border", "on");
static MagicsParameter<int> boxplot_box_border_thickness("boxplot_box_border_thickness", 1);
static MagicsParameter<string> boxplot_median("boxplot_median", "on");
static MagicsParameter<int> boxplot_median_thickness("boxplot_median_thickness", 3);
static MagicsParameter<string> boxplot_whisker("boxplot_whisker", "line");
static MagicsParameter<double> boxplot_whisker_box_width("boxplot_whisker_box_width", 0.25);
static MagicsParameter<string> boxplot_whisker_box_border("boxplot_whisker_box_border", "on");
static MagicsParameter<int> boxplot_whisker_box_border_thickness("boxplot_whisker_box_border_thickness", 1);
static MagicsParameter<int> boxplot_whisker_line_thickness("boxplot_whisker_line_thickness", 3);
static MagicsParameter<string> boxplot_box_colour("boxplot_box_colour", "sky");
static MagicsParameter<string> boxplot_box_border_colour("boxplot_box_border_colour", "navy");
static MagicsParameter<string> boxplot_box_border_line_style("boxplot_box_border_line_style", "solid");
static MagicsParameter<string> boxplot_median_colour("boxplot_median_colour", "navy");
static MagicsParameter<string> boxplot_median_line_style("boxplot_median_line_style", "solid");
static MagicsParameter<string> boxplot_whisker_box_colour("boxplot_whisker_box_colour", "sky");
static MagicsParameter<string> boxplot_whisker_box_border_colour("boxplot_whisker_box_border_colour", "navy");
static MagicsParameter<string> boxplot_whisker_box_border_line_style("boxplot_whisker_box_border_line_style", "solid");
static MagicsParameter<string> boxplot_whisker_line_colour("boxplot_whisker_line_colour", "navy");
static MagicsParameter<string> boxplot_whisker_line_style("boxplot_whisker_line_style", "solid");
