# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementTenantConfigurationOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tenant_configuration_begin_deploy(self, resource_group):
        response = self.client.tenant_configuration.begin_deploy(
            resource_group_name=resource_group.name,
            service_name="str",
            configuration_name="str",
            parameters={"branch": "str", "force": bool},
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tenant_configuration_begin_save(self, resource_group):
        response = self.client.tenant_configuration.begin_save(
            resource_group_name=resource_group.name,
            service_name="str",
            configuration_name="str",
            parameters={"branch": "str", "force": bool},
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tenant_configuration_begin_validate(self, resource_group):
        response = self.client.tenant_configuration.begin_validate(
            resource_group_name=resource_group.name,
            service_name="str",
            configuration_name="str",
            parameters={"branch": "str", "force": bool},
            api_version="2024-05-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_tenant_configuration_get_sync_state(self, resource_group):
        response = self.client.tenant_configuration.get_sync_state(
            resource_group_name=resource_group.name,
            service_name="str",
            configuration_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
