% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b2r.R
\name{b2r}
\alias{b2r}
\title{Obtain correlation coefficients and their variance-covariances}
\usage{
b2r(b, s, rho, n)
}
\arguments{
\item{b}{the vector of linear regression coefficients.}

\item{s}{the corresponding vector of standard errors.}

\item{rho}{triangular array of between-SNP correlation.}

\item{n}{the sample size.}
}
\value{
The returned value is a list containing:
\itemize{
\item r the vector of correlation coefficients.
\item V the variance-covariance matrix of correlations.
}
}
\description{
Obtain correlation coefficients and their variance-covariances
}
\details{
This function converts linear regression coefficients of phenotype on
single nucleotide polymorphisms (SNPs) into Pearson correlation coefficients
with their variance-covariance matrix. It is useful as a preliminary step
for meta-analyze SNP-trait associations at a given region. Between-SNP
correlations (e.g., from HapMap) are required as auxiliary information.
}
\examples{
\dontrun{
n <- 10
r <- c(1,0.2,1,0.4,0.5,1)
b <- c(0.1,0.2,0.3)
s <- c(0.4,0.3,0.2)
bs <- b2r(b,s,r,n)
}

}
\references{
\insertRef{elston75}{gap}

\insertRef{becker00}{gap}

\insertRef{casella02}{gap}
}
\seealso{
\code{\link{mvmeta}}, \code{\link{LD22}}
}
\author{
Jing Hua Zhao
}
\keyword{datagen}
