/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

abstract class BitExpandInputStream
extends InputStream {
    private final InputStream base_;
    private int rack_;
    private int mask_;
    private boolean ended_;
    protected static final int END_OF_STREAM = 256;

    protected BitExpandInputStream(InputStream inputStream) {
        this.base_ = inputStream;
        this.mask_ = 128;
    }

    public void close() throws IOException {
        this.base_.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.ended_) {
            return -1;
        }
        int n = this.readToken();
        if (n == 256) {
            this.ended_ = true;
            return -1;
        }
        return n;
    }

    protected abstract int readToken() throws IOException;

    public boolean readBit() throws IOException {
        if (this.mask_ == 128) {
            this.rack_ = BitExpandInputStream.read1(this.base_);
        }
        int n = this.rack_ & this.mask_;
        this.mask_ >>= 1;
        if (this.mask_ == 0) {
            this.mask_ = 128;
        }
        return n != 0;
    }

    public int readBits(int n) throws IOException {
        int n2 = 0;
        for (int i = 1 << n - 1; i != 0; i >>= 1) {
            if (!this.readBit()) continue;
            n2 |= i;
        }
        return n2;
    }

    private static int read1(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public static class AdaptiveHuffmanInputStream
    extends BitExpandInputStream {
        private final int[] leafs_ = new int[258];
        private final Node[] nodes_ = new Node[515];
        private int nextFreeNode_;
        private static final int ESCAPE = 257;
        private static final int SYMBOL_COUNT = 258;
        private static final int NODE_TABLE_COUNT = 515;
        private static final int ROOT_NODE = 0;
        private static final int MAX_WEIGHT = 32768;

        public AdaptiveHuffmanInputStream(InputStream inputStream) {
            super(inputStream);
            this.nodes_[0] = new Node(1, false, 2, -1);
            this.nodes_[1] = new Node(256, true, 1, 0);
            this.leafs_[256] = 1;
            this.nodes_[2] = new Node(257, true, 1, 0);
            this.leafs_[257] = 2;
            this.nextFreeNode_ = 3;
            for (int i = 0; i < 256; ++i) {
                this.leafs_[i] = -1;
            }
        }

        protected int readToken() throws IOException {
            int n;
            int n2 = 0;
            while (!this.nodes_[n2].childIsLeaf_) {
                n2 = this.nodes_[n2].child_;
                n = this.readBit() ? 1 : 0;
                n2 += n != 0 ? 1 : 0;
            }
            n = this.nodes_[n2].child_;
            if (n == 257) {
                n = this.readBits(8);
                this.addNewNode(n);
            }
            this.updateModel(n);
            return n;
        }

        private void addNewNode(int n) {
            int n2 = this.nextFreeNode_ - 1;
            int n3 = this.nextFreeNode_;
            int n4 = this.nextFreeNode_ + 1;
            this.nextFreeNode_ += 2;
            this.nodes_[n3] = new Node(this.nodes_[n2]);
            this.nodes_[n3].parent_ = n2;
            this.leafs_[this.nodes_[n3].child_] = n3;
            this.nodes_[n2] = new Node(n3, false, this.nodes_[n2].weight_, this.nodes_[n2].parent_);
            this.nodes_[n4] = new Node(n, true, 0, n2);
            this.leafs_[n] = n4;
        }

        private void updateModel(int n) {
            if (this.nodes_[0].weight_ == 32768) {
                this.rebuildTree();
            }
            int n2 = this.leafs_[n];
            while (n2 != -1) {
                int n3;
                ++this.nodes_[n2].weight_;
                for (n3 = n2; n3 > 0 && this.nodes_[n3 - 1].weight_ < this.nodes_[n2].weight_; --n3) {
                }
                if (n2 != n3) {
                    this.swapNodes(n2, n3);
                    n2 = n3;
                }
                n2 = this.nodes_[n2].parent_;
            }
        }

        private void swapNodes(int n, int n2) {
            if (this.nodes_[n].childIsLeaf_) {
                this.leafs_[this.nodes_[n].child_] = n2;
            } else {
                this.nodes_[this.nodes_[n].child_].parent_ = n2;
                this.nodes_[this.nodes_[n].child_ + 1].parent_ = n2;
            }
            if (this.nodes_[n2].childIsLeaf_) {
                this.leafs_[this.nodes_[n2].child_] = n;
            } else {
                this.nodes_[this.nodes_[n2].child_].parent_ = n;
                this.nodes_[this.nodes_[n2].child_ + 1].parent_ = n;
            }
            Node node = new Node(this.nodes_[n]);
            this.nodes_[n] = new Node(this.nodes_[n2]);
            this.nodes_[n].parent_ = node.parent_;
            node.parent_ = this.nodes_[n2].parent_;
            this.nodes_[n2] = node;
        }

        private void rebuildTree() {
            int n;
            int n2;
            int n3;
            for (n3 = n2 = this.nextFreeNode_ - 1; n3 >= 0; --n3) {
                if (!this.nodes_[n3].childIsLeaf_) continue;
                this.nodes_[n2] = new Node(this.nodes_[n3]);
                this.nodes_[n2].weight_ = (this.nodes_[n2].weight_ + 1) / 2;
                --n2;
            }
            n3 = this.nextFreeNode_ - 2;
            while (n2 >= 0) {
                n = n3 + 1;
                int n4 = this.nodes_[n2].weight_ = this.nodes_[n3].weight_ + this.nodes_[n].weight_;
                this.nodes_[n2].childIsLeaf_ = false;
                n = n2 + 1;
                while (n4 < this.nodes_[n].weight_) {
                    ++n;
                }
                System.arraycopy(this.nodes_, n2 + 1, this.nodes_, n2, --n - n2);
                this.nodes_[n] = new Node(n3, false, n4, this.nodes_[n].parent_);
                n3 -= 2;
                --n2;
            }
            for (n3 = this.nextFreeNode_ - 1; n3 >= 0; --n3) {
                if (this.nodes_[n3].childIsLeaf_) {
                    n = this.nodes_[n3].child_;
                    this.leafs_[n] = n3;
                    continue;
                }
                n = this.nodes_[n3].child_;
                this.nodes_[n].parent_ = this.nodes_[n + 1].parent_ = n3;
            }
        }

        private static class Node {
            int child_;
            boolean childIsLeaf_;
            int weight_;
            int parent_;

            Node(int n, boolean bl, int n2, int n3) {
                this.child_ = n;
                this.childIsLeaf_ = bl;
                this.weight_ = n2;
                this.parent_ = n3;
            }

            Node(Node node) {
                this(node.child_, node.childIsLeaf_, node.weight_, node.parent_);
            }
        }
    }

    public static class HuffmanInputStream
    extends BitExpandInputStream {
        private final Node[] nodes_;
        private final int iRoot_;
        private boolean ended_;

        public HuffmanInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            this.nodes_ = HuffmanInputStream.inputCounts(inputStream);
            this.iRoot_ = HuffmanInputStream.buildTree(this.nodes_);
        }

        protected int readToken() throws IOException {
            Node node;
            boolean bl;
            int n = this.iRoot_;
            do {
                node = this.nodes_[n];
            } while ((n = (bl = this.readBit()) ? node.child1_ : node.child0_) > 256);
            return n;
        }

        private static Node[] inputCounts(InputStream inputStream) throws IOException {
            int n;
            Node[] nodeArray = new Node[514];
            for (n = 0; n < 514; ++n) {
                nodeArray[n] = new Node();
            }
            n = BitExpandInputStream.read1(inputStream);
            int n2 = BitExpandInputStream.read1(inputStream);
            while (true) {
                for (int i = n; i <= n2; ++i) {
                    nodeArray[i].count_ = BitExpandInputStream.read1(inputStream);
                }
                n = BitExpandInputStream.read1(inputStream);
                if (n == 0) break;
                n2 = BitExpandInputStream.read1(inputStream);
            }
            nodeArray[256].count_ = 1;
            return nodeArray;
        }

        private static int buildTree(Node[] nodeArray) {
            nodeArray[513].count_ = Integer.MAX_VALUE;
            int n = 257;
            while (true) {
                int n2 = 513;
                int n3 = 513;
                for (int i = 0; i < n; ++i) {
                    if (nodeArray[i].count_ == 0) continue;
                    if (nodeArray[i].count_ < nodeArray[n2].count_) {
                        n3 = n2;
                        n2 = i;
                        continue;
                    }
                    if (nodeArray[i].count_ >= nodeArray[n3].count_) continue;
                    n3 = i;
                }
                if (n3 == 513) break;
                nodeArray[n].count_ = nodeArray[n2].count_ + nodeArray[n3].count_;
                nodeArray[n2].savedCount_ = nodeArray[n2].count_;
                nodeArray[n2].count_ = 0;
                nodeArray[n3].savedCount_ = nodeArray[n3].count_;
                nodeArray[n3].count_ = 0;
                nodeArray[n].child0_ = n2;
                nodeArray[n].child1_ = n3;
                ++n;
            }
            nodeArray[--n].savedCount_ = nodeArray[n].count_;
            return n;
        }

        private static class Node {
            int count_;
            int savedCount_;
            int child0_;
            int child1_;

            private Node() {
            }
        }
    }
}

