/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensolaris.os.dtrace.AggregationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Distribution
implements AggregationValue,
Iterable<Bucket>,
Serializable {
    static final long serialVersionUID = 1186243118882654932L;
    private List<Bucket> buckets;
    private transient double total;
    private transient boolean initialized;

    Distribution(long base, long constant, long[] frequencies) {
        this.total = 0.0;
        int len = frequencies.length;
        for (int i = 0; i < len; ++i) {
            long frequency = frequencies[i];
            this.total += (double)frequency;
        }
        this.buckets = this.createBuckets(base, constant, frequencies);
        this.initialized = true;
    }

    Distribution(List<Bucket> frequencies) {
        int len = frequencies.size();
        this.buckets = new ArrayList<Bucket>(len);
        this.buckets.addAll(frequencies);
    }

    final void initialize() {
        this.total = 0.0;
        int len = this.buckets.size();
        for (int i = 0; i < len; ++i) {
            Bucket bucket = this.buckets.get(i);
            long frequency = bucket.getFrequency();
            this.checkBucketRange(i, len, bucket);
            this.total += (double)frequency;
        }
        this.initialized = true;
    }

    private void checkInit() {
        if (!this.initialized) {
            throw new IllegalStateException("Uninitialized");
        }
    }

    abstract long[] getBucketRange(int var1, int var2, long var3, long var5);

    abstract long[] getBucketRange(int var1, int var2);

    private List<Bucket> createBuckets(long base, long constant, long[] frequencies) {
        int len = frequencies.length;
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(len);
        for (int i = 0; i < len; ++i) {
            long[] range = this.getBucketRange(i, len, base, constant);
            long min = range[0];
            long max = range[1];
            Bucket bucket = new Bucket(min, max, frequencies[i]);
            buckets.add(bucket);
        }
        return buckets;
    }

    private void checkBucketRange(int i, int bucketCount, Bucket bucket, long base, long constant) {
        long[] range = this.getBucketRange(i, bucketCount, base, constant);
        this.checkBucketRange(i, bucket, range);
    }

    private void checkBucketRange(int i, int bucketCount, Bucket bucket) {
        long[] range = this.getBucketRange(i, bucketCount);
        this.checkBucketRange(i, bucket, range);
    }

    private void checkBucketRange(int i, Bucket bucket, long[] range) {
        long min = range[0];
        long max = range[1];
        if (bucket.getMin() != min) {
            throw new IllegalArgumentException("bucket min " + bucket.getMin() + " at index " + i + ", expected " + min);
        }
        if (bucket.getMax() != max) {
            throw new IllegalArgumentException("bucket max " + bucket.getMax() + " at index " + i + ", expected " + max);
        }
    }

    public List<Bucket> getBuckets() {
        this.checkInit();
        return new ArrayList<Bucket>(this.buckets);
    }

    public List<Bucket> asList() {
        this.checkInit();
        return Collections.unmodifiableList(this.buckets);
    }

    public int size() {
        this.checkInit();
        return this.buckets.size();
    }

    public Bucket get(int index) {
        this.checkInit();
        return this.buckets.get(index);
    }

    @Override
    public Iterator<Bucket> iterator() {
        this.checkInit();
        return this.buckets.iterator();
    }

    public boolean equals(Object o) {
        this.checkInit();
        if (o instanceof Distribution) {
            Distribution d = (Distribution)o;
            return ((Object)this.buckets).equals(d.buckets);
        }
        return false;
    }

    public int hashCode() {
        this.checkInit();
        return ((Object)this.buckets).hashCode();
    }

    public double getTotal() {
        this.checkInit();
        return this.total;
    }

    @Override
    public abstract Number getValue();

    private void normalizeBuckets(long normal) {
        for (Bucket b : this.buckets) {
            b.frequency /= normal;
        }
    }

    public List<Bucket> getDisplayRange() {
        Bucket b;
        int i;
        this.checkInit();
        int min = -1;
        int max = -1;
        int len = this.size();
        for (i = 0; i < len; ++i) {
            b = this.buckets.get(i);
            if (b.getFrequency() <= 0L) continue;
            min = i;
            break;
        }
        if (min < 0) {
            return Collections.emptyList();
        }
        for (i = len - 1; i >= 0; --i) {
            b = this.buckets.get(i);
            if (b.getFrequency() <= 0L) continue;
            max = i;
            break;
        }
        if (min > 0) {
            --min;
        }
        if (max < len - 1) {
            ++max;
        }
        return Collections.unmodifiableList(this.buckets).subList(min, max + 1);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = this.buckets.size();
        ArrayList<Bucket> copy = new ArrayList<Bucket>(len);
        copy.addAll(this.buckets);
        this.buckets = copy;
    }

    public String toString() {
        this.checkInit();
        StringBuilder buf = new StringBuilder();
        buf.append(Distribution.class.getName());
        buf.append("[buckets = ");
        List<Bucket> list = this.getDisplayRange();
        if (list.isEmpty()) {
            buf.append("<empty>");
        } else {
            buf.append(Arrays.toString(this.getDisplayRange().toArray()));
        }
        buf.append(", total = ");
        buf.append(this.getTotal());
        buf.append(']');
        return buf.toString();
    }

    public static final class Bucket
    implements Serializable {
        static final long serialVersionUID = 4863264115375406295L;
        private final long min;
        private final long max;
        private long frequency;

        public Bucket(long rangeMinimumInclusive, long rangeMaximumInclusive, long valuesInRange) {
            if (rangeMaximumInclusive < rangeMinimumInclusive) {
                throw new IllegalArgumentException("upper bound " + rangeMaximumInclusive + " is less than lower bound " + rangeMinimumInclusive);
            }
            this.min = rangeMinimumInclusive;
            this.max = rangeMaximumInclusive;
            this.frequency = valuesInRange;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public long getFrequency() {
            return this.frequency;
        }

        public boolean equals(Object o) {
            if (o instanceof Bucket) {
                Bucket b = (Bucket)o;
                return this.min == b.min && this.max == b.max && this.frequency == b.frequency;
            }
            return false;
        }

        public int hashCode() {
            int hash = 17;
            hash = 37 * hash + (int)(this.min ^ this.min >>> 32);
            hash = 37 * hash + (int)(this.max ^ this.max >>> 32);
            hash = 37 * hash + (int)(this.frequency ^ this.frequency >>> 32);
            return hash;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (this.max < this.min) {
                throw new InvalidObjectException("upper bound " + this.max + " is less than lower bound " + this.min);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(Bucket.class.getName());
            buf.append("[min = ");
            buf.append(this.min);
            buf.append(", max = ");
            buf.append(this.max);
            buf.append(", frequency = ");
            buf.append(this.frequency);
            buf.append(']');
            return buf.toString();
        }

        static {
            try {
                BeanInfo info = Introspector.getBeanInfo(Bucket.class);
                DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"min", "max", "frequency"}){

                    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                        return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                    }
                };
                BeanDescriptor d = info.getBeanDescriptor();
                d.setValue("persistenceDelegate", persistenceDelegate);
            }
            catch (IntrospectionException e) {
                System.out.println(e);
            }
        }
    }
}

