/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.script.Token;
import org.jmol.util.Escape;
import org.jmol.util.TextFormat;

public class XmlUtil {
    public static void openDocument(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
    }

    public static void openTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append("<").append(string).append(">\n");
    }

    public static void openTag(StringBuffer stringBuffer, String string, Object[] objectArray) {
        XmlUtil.appendTag(stringBuffer, string, objectArray, null, false, false);
        stringBuffer.append("\n");
    }

    public static void closeTag(StringBuffer stringBuffer, String string) {
        stringBuffer.append("</").append(string).append(">\n");
    }

    public static void appendTag(StringBuffer stringBuffer, String string, Object[] objectArray, Object object, boolean bl, boolean bl2) {
        String string2 = ">";
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
            if (object == null) {
                string2 = "/>\n";
                bl2 = false;
            }
        }
        stringBuffer.append("<").append(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 instanceof Object[]) {
                    XmlUtil.appendAttrib(stringBuffer, ((Object[])object2)[0], ((Object[])object2)[1]);
                    continue;
                }
                XmlUtil.appendAttrib(stringBuffer, object2, objectArray[++i]);
            }
        }
        stringBuffer.append(string2);
        if (object != null) {
            if (bl) {
                object = XmlUtil.wrapCdata(object);
            }
            stringBuffer.append(object);
        }
        if (bl2) {
            XmlUtil.closeTag(stringBuffer, string);
        }
    }

    public static String wrapCdata(Object object) {
        String string = "" + object;
        return string.indexOf("&") < 0 && string.indexOf("<") < 0 ? (string.startsWith("\n") ? "" : "\n") + string : "<![CDATA[" + TextFormat.simpleReplace(string, "]]>", "]]]]><![CDATA[>") + "]]>";
    }

    public static String unwrapCdata(String string) {
        return string.startsWith("<![CDATA[") && string.endsWith("]]>") ? string.substring(9, string.length() - 3).replace("]]]]><![CDATA[>", "]]>") : string;
    }

    public static void appendTag(StringBuffer stringBuffer, String string, Object[] objectArray, Object object) {
        XmlUtil.appendTag(stringBuffer, string, objectArray, object, false, true);
    }

    public static void appendTag(StringBuffer stringBuffer, String string, Object object) {
        if (object instanceof Object[]) {
            XmlUtil.appendTag(stringBuffer, string, (Object[])object, null, false, true);
        } else {
            XmlUtil.appendTag(stringBuffer, string, null, object, false, true);
        }
    }

    public static void appendCdata(StringBuffer stringBuffer, String string, Object[] objectArray, String string2) {
        XmlUtil.appendTag(stringBuffer, string, objectArray, string2, true, true);
    }

    public static void appendAttrib(StringBuffer stringBuffer, Object object, Object object2) {
        if (object2 == null) {
            return;
        }
        stringBuffer.append(" ").append(object).append("=\"").append(object2).append("\"");
    }

    public static void toXml(StringBuffer stringBuffer, String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object[] objectArray = (Object[])vector.get(i);
            XmlUtil.appendTag(stringBuffer, string, (Object[])objectArray[0], objectArray[1]);
        }
    }

    public static Object escape(String string, Vector vector, Object object, boolean bl, String string2) {
        int n;
        StringBuffer stringBuffer;
        Object[] objectArray;
        String string3;
        String string4 = string3 = object == null ? null : object.getClass().getName();
        if (string == "token") {
            string3 = null;
            object = Token.nameOf((Integer)object);
        } else if (string3 != null) {
            string3 = string3.substring(0, string3.lastIndexOf("[") + 1) + string3.substring(string3.lastIndexOf(".") + 1);
            if (object instanceof String) {
                object = XmlUtil.wrapCdata(object);
            } else if (object instanceof BitSet) {
                object = Escape.escape((BitSet)object);
            } else if (object instanceof Vector) {
                objectArray = (Vector)object;
                stringBuffer = new StringBuffer("\n");
                if (vector == null) {
                    vector = new Vector<Object[]>();
                }
                vector.add(new Object[]{"count", new Integer(objectArray.size())});
                for (n = 0; n < objectArray.size(); ++n) {
                    stringBuffer.append(XmlUtil.escape(null, null, objectArray.get(n), true, string2 + "  "));
                }
                object = stringBuffer.toString();
            } else if (object instanceof Hashtable) {
                objectArray = (Hashtable)object;
                stringBuffer = new StringBuffer("\n");
                Enumeration enumeration = objectArray.keys();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    ++n2;
                    String string5 = (String)enumeration.nextElement();
                    stringBuffer.append(XmlUtil.escape(string5, null, objectArray.get(string5), true, string2 + "  "));
                }
                if (vector == null) {
                    vector = new Vector();
                }
                vector.add(new Object[]{"count", new Integer(n2)});
                object = stringBuffer.toString();
            } else if (string3.startsWith("[")) {
                if (object instanceof float[]) {
                    objectArray = (float[])object;
                    stringBuffer = new StringBuffer("\n");
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(new Object[]{"count", new Integer(objectArray.length)});
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(XmlUtil.escape(null, null, new Float((float)objectArray[i]), true, string2 + "  "));
                    }
                    object = stringBuffer.toString();
                } else if (object instanceof int[]) {
                    objectArray = (int[])object;
                    stringBuffer = new StringBuffer("\n");
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(new Object[]{"count", new Integer(objectArray.length)});
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(XmlUtil.escape(null, null, new Integer((int)objectArray[i]), true, string2 + "  "));
                    }
                    object = stringBuffer.toString();
                } else if (object instanceof Object[]) {
                    objectArray = (Object[])object;
                    stringBuffer = new StringBuffer("\n");
                    if (vector == null) {
                        vector = new Vector();
                    }
                    vector.add(new Object[]{"count", new Integer(objectArray.length)});
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(XmlUtil.escape(null, null, objectArray[i], true, string2 + "  "));
                    }
                    object = stringBuffer.toString();
                }
            }
        }
        objectArray = new Vector();
        objectArray.add(new Object[]{"name", string});
        objectArray.add(new Object[]{"type", string3});
        if (vector != null) {
            for (n = 0; n < vector.size(); ++n) {
                objectArray.add(vector.get(n));
            }
        }
        if (!bl) {
            return new Object[]{objectArray.toArray(), object};
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        XmlUtil.appendTag(stringBuffer, "val", objectArray.toArray(), null, false, false);
        stringBuffer.append(object);
        if (object instanceof String && ((String)object).contains("\n")) {
            stringBuffer.append(string2);
        }
        XmlUtil.closeTag(stringBuffer, "val");
        return stringBuffer.toString();
    }
}

